/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.util;

import com.destroystokyo.paper.PaperVersionFetcher;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import io.papermc.paper.ServerBuildInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.StreamSupport;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LeavesVersionFetcher
extends PaperVersionFetcher {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private static final int DISTANCE_ERROR = -1;
    private static final int DISTANCE_UNKNOWN = -2;
    private static final String DOWNLOAD_PAGE = "https://leavesmc.org/downloads/leaves";

    @Override
    @NotNull
    public Component getVersionMessage(@NotNull String serverVersion) {
        ServerBuildInfo build = ServerBuildInfo.buildInfo();
        Object updateMessage = build.buildNumber().isEmpty() && build.gitCommit().isEmpty() ? Component.text((String)"You are running a development version without access to version information", (TextColor)TextColor.color((int)16732928)) : LeavesVersionFetcher.getUpdateStatusMessage("LeavesMC/Leaves", build);
        @Nullable Component history = this.getHistory();
        return history != null ? Component.textOfChildren((ComponentLike[])new ComponentLike[]{updateMessage, Component.newline(), history}) : updateMessage;
    }

    private static Component getUpdateStatusMessage(@NotNull String repo, @NotNull ServerBuildInfo build) {
        int distance = LeavesVersionFetcher.fetchDistanceFromLeavesApiV2Build(build);
        if (distance == -1) {
            distance = LeavesVersionFetcher.fetchDistanceFromLeavesApiV2Hash(build);
        }
        if (distance == -1) {
            Optional gitBranch = build.gitBranch();
            Optional gitCommit = build.gitCommit();
            if (gitBranch.isPresent() && gitCommit.isPresent()) {
                distance = LeavesVersionFetcher.fetchDistanceFromGitHub(repo, (String)gitBranch.get(), (String)gitCommit.get());
            }
        }
        return switch (distance) {
            case -1 -> Component.text((String)"Error obtaining version information", (TextColor)NamedTextColor.YELLOW);
            case 0 -> Component.text((String)"You are running the latest version", (TextColor)NamedTextColor.GREEN);
            case -2 -> Component.text((String)"Unknown version", (TextColor)NamedTextColor.YELLOW);
            default -> (TextComponent)((TextComponent)Component.text((String)("You are " + distance + " version(s) behind"), (TextColor)NamedTextColor.YELLOW).append((Component)Component.newline())).append(Component.text((String)"Download the new version at: ").append(((TextComponent)Component.text((String)DOWNLOAD_PAGE, (TextColor)NamedTextColor.GOLD).hoverEvent((HoverEventSource)Component.text((String)"Click to open", (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.openUrl((String)DOWNLOAD_PAGE))));
        };
    }

    private static int fetchDistanceFromLeavesApiV2Build(ServerBuildInfo build) {
        int n;
        block11: {
            OptionalInt buildNumber = build.buildNumber();
            if (buildNumber.isEmpty()) {
                return -1;
            }
            BufferedReader reader = Resources.asCharSource((URL)URI.create("https://api.leavesmc.org/v2/projects/leaves/versions/" + build.minecraftVersionId()).toURL(), (Charset)Charsets.UTF_8).openBufferedStream();
            try {
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                JsonArray builds = json.getAsJsonArray("builds");
                int latest = StreamSupport.stream(builds.spliterator(), false).mapToInt(JsonElement::getAsInt).max().orElseThrow();
                n = latest - buildNumber.getAsInt();
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonSyntaxException ex) {
                        LOGGER.error("Error parsing json from Leaves's downloads API", (Throwable)ex);
                        return -1;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error while parsing version", (Throwable)e);
                    return -1;
                }
            }
            reader.close();
        }
        return n;
    }

    private static int fetchDistanceFromLeavesApiV2Hash(ServerBuildInfo build) {
        int n;
        block9: {
            if (build.gitCommit().isEmpty()) {
                return -1;
            }
            BufferedReader reader = Resources.asCharSource((URL)URI.create("https://api.leavesmc.org/v2/projects/leaves/versions/" + build.minecraftVersionId() + "/differ/" + String.valueOf(build.gitCommit())).toURL(), (Charset)Charsets.UTF_8).openBufferedStream();
            try {
                n = Integer.parseInt(reader.readLine());
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Error while parsing version", (Throwable)e);
                    return -1;
                }
            }
            reader.close();
        }
        return n;
    }
}

