/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.util;

import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.jetbrains.annotations.NotNull;
import org.leavesmc.leaves.LeavesConfig;

public class ShulkerBoxUtils {
    public static final int TAG_END = 0;
    public static final int TAG_BYTE = 1;
    public static final int TAG_SHORT = 2;
    public static final int TAG_INT = 3;
    public static final int TAG_LONG = 4;
    public static final int TAG_FLOAT = 5;
    public static final int TAG_DOUBLE = 6;
    public static final int TAG_BYTEARRAY = 7;
    public static final int TAG_STRING = 8;
    public static final int TAG_LIST = 9;
    public static final int TAG_COMPOUND = 10;
    public static final int TAG_INTARRAY = 11;
    public static final int TAG_LONGARRAY = 12;

    public static boolean cleanUpShulkerBoxTag(@NotNull ItemStack stack) {
        boolean changed = false;
        DataComponentMap components = stack.getComponents();
        if (!components.has(DataComponents.BLOCK_ENTITY_DATA)) {
            return false;
        }
        CompoundTag bet = components.get(DataComponents.BLOCK_ENTITY_DATA).copyTag();
        if (bet.contains("Items", 9) && bet.getList("Items", 10).isEmpty()) {
            bet.remove("Items");
            stack.applyComponents(DataComponentPatch.builder().set(DataComponents.BLOCK_ENTITY_DATA, CustomData.of(bet)).build());
            changed = true;
        }
        if (bet.isEmpty() || bet.size() == 1 && bet.getString("id").equals("minecraft:shulker_box")) {
            stack.applyComponents(DataComponentPatch.builder().remove(DataComponents.BLOCK_ENTITY_DATA).build());
            changed = true;
        }
        if (components.isEmpty()) {
            stack.components = PatchedDataComponentMap.fromPatch(DataComponentMap.EMPTY, DataComponentPatch.EMPTY);
            changed = true;
        }
        return changed;
    }

    public static boolean shulkerBoxHasItems(@NotNull ItemStack stack) {
        DataComponentMap components = stack.getComponents();
        if (!components.has(DataComponents.BLOCK_ENTITY_DATA)) {
            return false;
        }
        CompoundTag bet = components.get(DataComponents.BLOCK_ENTITY_DATA).copyTag();
        return bet.contains("Items", 9) && !bet.getList("Items", 10).isEmpty();
    }

    public static int getItemStackMaxCount(ItemStack stack) {
        BlockItem bi;
        Item item;
        if (LeavesConfig.shulkerBoxStackSize > 1 && (item = stack.getItem()) instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock && !ShulkerBoxUtils.shulkerBoxHasItems(stack)) {
            return LeavesConfig.shulkerBoxStackSize;
        }
        return stack.getMaxStackSize();
    }

    public static boolean isStackable(ItemStack itemStack) {
        return ShulkerBoxUtils.getItemStackMaxCount(itemStack) > 1 && (!itemStack.isDamageableItem() || !itemStack.isDamaged());
    }
}

