/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leaves.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.storage.LevelResource;
import org.leavesmc.leaves.LeavesConfig;

public class TicketHelper {
    private static final Set<TicketType<?>> NEED_SAVED = Set.of(TicketType.PLAYER, TicketType.PORTAL, TicketType.ENTITY_LOAD, TicketType.POI_LOAD);

    public static void tryToLoadTickets() {
        if (!LeavesConfig.fastResume) {
            return;
        }
        File file = MinecraftServer.getServer().getWorldPath(LevelResource.ROOT).resolve("chunk_tickets.leaves.json").toFile();
        if (file.isFile()) {
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)bfr, JsonObject.class);
                TicketHelper.loadSavedChunkTickets(json);
                file.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void tryToSaveTickets() {
        if (!LeavesConfig.fastResume) {
            return;
        }
        File file = MinecraftServer.getServer().getWorldPath(LevelResource.ROOT).resolve("chunk_tickets.leaves.json").toFile();
        if (!file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (BufferedWriter bfw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            bfw.write(new Gson().toJson((JsonElement)TicketHelper.getSavedChunkTickets()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadSavedChunkTickets(JsonObject json) {
        MinecraftServer server = MinecraftServer.getServer();
        for (String worldKey : json.keySet()) {
            ServerLevel level = server.getLevel(ResourceKey.create(Registries.DIMENSION, new ResourceLocation(worldKey)));
            if (level == null) continue;
            ChunkMap.ChunkDistanceManager chunkDistanceManager = level.getChunkSource().chunkMap.distanceManager;
            for (JsonElement chunkElement : json.get(worldKey).getAsJsonArray()) {
                JsonObject chunkJson = (JsonObject)chunkElement;
                long chunkKey = chunkJson.get("key").getAsLong();
                for (JsonElement ticketElement : chunkJson.get("tickets").getAsJsonArray()) {
                    Ticket ticket = TicketHelper.tickFormJson((JsonObject)ticketElement);
                    chunkDistanceManager.getChunkHolderManager().addTicketAtLevelCustom(ticket, chunkKey, true);
                }
            }
        }
    }

    public static JsonObject getSavedChunkTickets() {
        JsonObject json = new JsonObject();
        for (ServerLevel level : MinecraftServer.getServer().getAllLevels()) {
            JsonArray levelArray = new JsonArray();
            ChunkMap.ChunkDistanceManager chunkDistanceManager = level.getChunkSource().chunkMap.distanceManager;
            for (Long2ObjectMap.Entry chunkTickets : chunkDistanceManager.getChunkHolderManager().getTicketsCopy().long2ObjectEntrySet()) {
                long chunkKey = chunkTickets.getLongKey();
                JsonArray ticketArray = new JsonArray();
                SortedArraySet tickets = (SortedArraySet)chunkTickets.getValue();
                for (Ticket ticket : tickets) {
                    if (!NEED_SAVED.contains(ticket.getType())) continue;
                    ticketArray.add((JsonElement)TicketHelper.ticketToJson(ticket));
                }
                if (ticketArray.isEmpty()) continue;
                JsonObject chunkJson = new JsonObject();
                chunkJson.addProperty("key", (Number)chunkKey);
                chunkJson.add("tickets", (JsonElement)ticketArray);
                levelArray.add((JsonElement)chunkJson);
            }
            if (levelArray.isEmpty()) continue;
            json.add(level.dimension().location().toString(), (JsonElement)levelArray);
        }
        return json;
    }

    private static JsonObject ticketToJson(Ticket<?> ticket) {
        JsonObject json = new JsonObject();
        json.addProperty("type", ticket.getType().toString());
        json.addProperty("ticketLevel", (Number)ticket.getTicketLevel());
        json.addProperty("removeDelay", (Number)ticket.removeDelay);
        Object t = ticket.key;
        if (t instanceof BlockPos) {
            BlockPos pos = (BlockPos)t;
            json.addProperty("key", (Number)pos.asLong());
        } else {
            t = ticket.key;
            if (t instanceof ChunkPos) {
                ChunkPos pos = (ChunkPos)t;
                json.addProperty("key", (Number)pos.toLong());
            } else {
                t = ticket.key;
                if (t instanceof Long) {
                    Long l = (Long)t;
                    json.addProperty("key", (Number)l);
                }
            }
        }
        return json;
    }

    private static <T> Ticket<T> tickFormJson(JsonObject json) {
        TicketType<Object> ticketType = null;
        Object key = null;
        switch (json.get("type").getAsString()) {
            case "player": {
                ticketType = TicketType.PLAYER;
                key = new ChunkPos(json.get("key").getAsLong());
                break;
            }
            case "portal": {
                ticketType = TicketType.PORTAL;
                key = BlockPos.of(json.get("key").getAsLong());
                break;
            }
            case "entity_load": {
                ticketType = TicketType.ENTITY_LOAD;
                key = json.get("key").getAsLong();
                break;
            }
            case "poi_load": {
                ticketType = TicketType.POI_LOAD;
                key = json.get("key").getAsLong();
                break;
            }
            case "region_player_ticket": {
                ticketType = RegionizedPlayerChunkLoader.REGION_PLAYER_TICKET;
                key = json.get("key").getAsLong();
            }
        }
        if (ticketType == null) {
            throw new IllegalArgumentException("???");
        }
        int ticketLevel = json.get("ticketLevel").getAsInt();
        long removeDelay = json.get("removeDelay").getAsLong();
        return new Ticket<Object>(ticketType, ticketLevel, key, removeDelay);
    }
}

