/*
 * Decompiled with CFR 0.152.
 */
package org.leavesmc.leavesclip;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class AutoUpdate {
    public static String autoUpdateCorePath;
    public static String autoUpdateDir;
    public static boolean useAutoUpdateJar;

    public static void init() {
        File workingDirFile = new File(autoUpdateDir);
        if (!workingDirFile.isDirectory() || !workingDirFile.exists()) {
            return;
        }
        File corePathFile = new File(autoUpdateDir + "/core.path");
        if (!corePathFile.isFile() || !corePathFile.exists()) {
            return;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(corePathFile));){
            String firstLine = bufferedReader.readLine();
            if (firstLine == null) {
                return;
            }
            autoUpdateCorePath = firstLine;
            File jarFile = new File(autoUpdateCorePath);
            if (!jarFile.isFile() || !jarFile.exists()) {
                System.out.println("The specified server core: " + autoUpdateCorePath + " does not exist. Using the original jar!");
                return;
            }
            useAutoUpdateJar = true;
            if (!AutoUpdate.detectionLeavesclipVersion(autoUpdateCorePath)) {
                System.out.println("Leavesclip version detection in server core: " + autoUpdateCorePath + " failed. Using the original jar!");
                useAutoUpdateJar = false;
                return;
            }
            System.out.println("Using server core: " + autoUpdateCorePath + " provide by Leavesclip-Auto-Update");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean detectionLeavesclipVersion(String jarPath) {
        byte[] localBytes;
        try (InputStream localStream = AutoUpdate.class.getResourceAsStream("/META-INF/leavesclip-version");){
            if (localStream == null) {
                boolean bl3 = false;
                return bl3;
            }
            localBytes = localStream.readAllBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (InputStream externalStream = AutoUpdate.getResourceAsStream(jarPath, "/META-INF/leavesclip-version");){
            if (externalStream != null) {
                boolean bl2 = Arrays.equals(localBytes, externalStream.readAllBytes());
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getResourceAsStream(String jarPath, String name) {
        if (!useAutoUpdateJar) {
            return AutoUpdate.class.getResourceAsStream(name);
        }
        name = name.replaceFirst("/", "");
        ByteArrayInputStream result = null;
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(jarPath));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.getName().equals(name)) {
                    result = new ByteArrayInputStream(zipInputStream.readAllBytes());
                    break;
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
            if (result == null) {
                throw new IOException(name + " not found in our jar or in the " + jarPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        autoUpdateDir = "auto_update";
        useAutoUpdateJar = false;
    }
}

