/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Pathfinder {
    @NotNull
    public Mob getEntity();

    public void stopPathfinding();

    public boolean hasPath();

    @Nullable
    public PathResult getCurrentPath();

    @Nullable
    public PathResult findPath(@NotNull Location var1);

    @Nullable
    public PathResult findPath(@NotNull LivingEntity var1);

    default public boolean moveTo(@NotNull Location loc) {
        return this.moveTo(loc, 1.0);
    }

    default public boolean moveTo(@NotNull Location loc, double speed) {
        PathResult path = this.findPath(loc);
        return path != null && this.moveTo(path, speed);
    }

    default public boolean moveTo(@NotNull LivingEntity target) {
        return this.moveTo(target, 1.0);
    }

    default public boolean moveTo(@NotNull LivingEntity target, double speed) {
        PathResult path = this.findPath(target);
        return path != null && this.moveTo(path, speed);
    }

    default public boolean moveTo(@NotNull PathResult path) {
        return this.moveTo(path, 1.0);
    }

    public boolean moveTo(@NotNull PathResult var1, double var2);

    public boolean canOpenDoors();

    public void setCanOpenDoors(boolean var1);

    public boolean canPassDoors();

    public void setCanPassDoors(boolean var1);

    public boolean canFloat();

    public void setCanFloat(boolean var1);

    public static interface PathResult {
        @NotNull
        public List<Location> getPoints();

        public int getNextPointIndex();

        @Nullable
        public Location getNextPoint();

        @Nullable
        public Location getFinalPoint();

        public boolean canReachFinalPoint();
    }
}

