/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.entity;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.entity.PotionSplashEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class WaterBottleSplashEvent
extends PotionSplashEvent {
    @NotNull
    private final Set<LivingEntity> rehydrate;
    @NotNull
    private final Set<LivingEntity> extinguish;

    @ApiStatus.Internal
    public WaterBottleSplashEvent(@NotNull ThrownPotion potion, @Nullable Entity hitEntity, @Nullable Block hitBlock, @Nullable BlockFace hitFace, @NotNull Map<LivingEntity, Double> affectedEntities, @NotNull Set<LivingEntity> rehydrate, @NotNull Set<LivingEntity> extinguish) {
        super(potion, hitEntity, hitBlock, hitFace, affectedEntities);
        this.rehydrate = rehydrate;
        this.extinguish = extinguish;
    }

    @NotNull
    public @Unmodifiable Collection<LivingEntity> getToDamage() {
        return this.affectedEntities.entrySet().stream().filter(entry -> (Double)entry.getValue() > 0.0).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }

    public void doNotDamageAsWaterSensitive(@NotNull LivingEntity entity) {
        this.affectedEntities.remove(entity);
    }

    public void damageAsWaterSensitive(@NotNull LivingEntity entity) {
        this.affectedEntities.put(entity, 1.0);
    }

    @NotNull
    public Collection<LivingEntity> getToRehydrate() {
        return this.rehydrate;
    }

    @NotNull
    public Collection<LivingEntity> getToExtinguish() {
        return this.extinguish;
    }

    @Override
    @Deprecated(since="1.19.3")
    @NotNull
    public Collection<LivingEntity> getAffectedEntities() {
        return super.getAffectedEntities();
    }

    @Override
    @Deprecated(since="1.19.3")
    public double getIntensity(@NotNull LivingEntity entity) {
        return super.getIntensity(entity);
    }

    @Override
    @Deprecated(since="1.19.3")
    public void setIntensity(@NotNull LivingEntity entity, double intensity) {
        super.setIntensity(entity, intensity);
    }
}

