/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import io.papermc.paper.annotation.DoNotUse;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.jetbrains.annotations.NotNull;

public class BlockExplodeEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancel;
    private final BlockState blockState;
    private final List<Block> blocks;
    private float yield;

    public BlockExplodeEvent(@NotNull Block what, @NotNull BlockState blockState, @NotNull List<Block> blocks, float yield) {
        super(what);
        this.blockState = blockState;
        this.blocks = blocks;
        this.yield = yield;
        this.cancel = false;
    }

    @DoNotUse
    @Deprecated(forRemoval=true)
    public BlockExplodeEvent(@NotNull Block what, @NotNull List<Block> blocks, float yield) {
        this(what, what.getState(), blocks, yield);
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancel = cancel;
    }

    @NotNull
    public BlockState getExplodedBlockState() {
        return this.blockState;
    }

    @NotNull
    public List<Block> blockList() {
        return this.blocks;
    }

    public float getYield() {
        return this.yield;
    }

    public void setYield(float yield) {
        this.yield = yield;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

