/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.field;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.util.DescriptorUtils;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public interface FieldRewriteRule
extends RewriteRule {
    default public boolean shouldProcess(ClassProcessingContext context, int opcode, String owner, String name, String descriptor) {
        return true;
    }

    @Override
    default public ClassVisitor createVisitor(int api, ClassVisitor parent, final ClassProcessingContext context) {
        return new ClassVisitor(api, parent){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                        Rewrite rewrite;
                        if (FieldRewriteRule.this.shouldProcess(context, opcode, owner, name, descriptor) && (rewrite = FieldRewriteRule.this.rewrite(context, opcode, owner, name, DescriptorUtils.classDesc(descriptor))) != null) {
                            rewrite.apply(this.getDelegate());
                            return;
                        }
                        super.visitFieldInsn(opcode, owner, name, descriptor);
                    }
                };
            }
        };
    }

    public @Nullable Rewrite rewrite(ClassProcessingContext var1, int var2, String var3, String var4, ClassDesc var5);

    public record RewriteToMethod(int opcode, String owner, String name, MethodTypeDesc descriptor, boolean isInterface) implements Rewrite
    {
        public RewriteToMethod {
            if (descriptor.parameterCount() != 0 && descriptor.parameterCount() != 1) {
                throw new IllegalArgumentException("Can only have 0 or 1 param on a method replacing a field");
            }
        }

        @Override
        public void apply(MethodVisitor delegate) {
            delegate.visitMethodInsn(this.opcode(), this.owner(), this.name(), this.descriptor().descriptorString(), this.isInterface());
        }
    }

    public record RewriteField(int opcode, String owner, String name, ClassDesc descriptor) implements Rewrite
    {
        @Override
        public void apply(MethodVisitor delegate) {
            delegate.visitFieldInsn(this.opcode(), this.owner(), this.name(), this.descriptor().descriptorString());
        }
    }

    public static interface Rewrite {
        public void apply(MethodVisitor var1);
    }
}

