/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.util.JSONUtil;
import java.util.List;

class TimingData {
    private final int id;
    private int count = 0;
    private int lagCount = 0;
    private long totalTime = 0L;
    private long lagTotalTime = 0L;
    private int curTickCount = 0;
    private long curTickTotal = 0L;

    TimingData(int id) {
        this.id = id;
    }

    private TimingData(TimingData data) {
        this.id = data.id;
        this.totalTime = data.totalTime;
        this.lagTotalTime = data.lagTotalTime;
        this.count = data.count;
        this.lagCount = data.lagCount;
    }

    void add(long diff) {
        ++this.curTickCount;
        this.curTickTotal += diff;
    }

    void processTick(boolean violated) {
        this.totalTime += this.curTickTotal;
        this.count += this.curTickCount;
        if (violated) {
            this.lagTotalTime += this.curTickTotal;
            this.lagCount += this.curTickCount;
        }
        this.curTickTotal = 0L;
        this.curTickCount = 0;
    }

    void reset() {
        this.count = 0;
        this.lagCount = 0;
        this.curTickTotal = 0L;
        this.curTickCount = 0;
        this.totalTime = 0L;
        this.lagTotalTime = 0L;
    }

    protected TimingData clone() {
        return new TimingData(this);
    }

    List<Object> export() {
        List list = JSONUtil.toArray(this.id, this.count, this.totalTime);
        if (this.lagCount > 0) {
            list.add(this.lagCount);
            list.add(this.lagTotalTime);
        }
        return list;
    }

    boolean hasData() {
        return this.count > 0;
    }

    long getTotalTime() {
        return this.totalTime;
    }

    int getCurTickCount() {
        return this.curTickCount;
    }

    void setCurTickCount(int curTickCount) {
        this.curTickCount = curTickCount;
    }

    long getCurTickTotal() {
        return this.curTickTotal;
    }

    void setCurTickTotal(long curTickTotal) {
        this.curTickTotal = curTickTotal;
    }
}

