/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.entity;

import org.bukkit.Material;
import org.bukkit.entity.Witch;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.inventory.ItemStack;

public class WitchReadyPotionEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private ItemStack potion;
    private boolean cancelled = false;

    public WitchReadyPotionEvent(Witch witch, ItemStack potion) {
        super(witch);
        this.potion = potion;
    }

    public static ItemStack process(Witch witch, ItemStack potion) {
        WitchReadyPotionEvent event = new WitchReadyPotionEvent(witch, potion);
        if (!event.callEvent() || event.getPotion() == null) {
            return new ItemStack(Material.AIR);
        }
        return event.getPotion();
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public Witch getEntity() {
        return (Witch)super.getEntity();
    }

    public ItemStack getPotion() {
        return this.potion;
    }

    public void setPotion(ItemStack potion) {
        this.potion = potion != null ? potion.clone() : null;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

