/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc;

import com.mohistmc.MohistMC;
import com.mohistmc.common.async.MohistThreadBox;
import com.mohistmc.configuration.MohistConfig;
import com.mohistmc.util.i18n.Message;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.spigotmc.TicksPerSecondCommand;

public class WatchMohist
implements Runnable {
    private static long Time = 0L;
    private static long WarnTime = 0L;

    @Override
    public void run() {
        long curTime = System.currentTimeMillis();
        if (Time > 0L && curTime - Time > 2000L && curTime - WarnTime > 30000L) {
            WarnTime = curTime;
            MohistMC.LOGGER.warn(Message.getString("watchmohist.1"));
            double[] tps = Bukkit.getTPS();
            Object[] tpsAvg = new String[tps.length];
            for (int i2 = 0; i2 < tps.length; ++i2) {
                tpsAvg[i2] = TicksPerSecondCommand.format(tps[i2]);
            }
            MohistMC.LOGGER.warn(Message.getFormatString("watchmohist.2", new Object[]{String.valueOf(curTime - Time), StringUtils.join((Object[])tpsAvg, (String)", ")}));
            MohistMC.LOGGER.warn(Message.getString("watchmohist.3"));
            for (StackTraceElement stack : MinecraftServer.getServerInst().primaryThread.getStackTrace()) {
                MohistMC.LOGGER.warn(Message.getString("watchmohist.4") + stack);
            }
            MohistMC.LOGGER.warn(Message.getString("watchmohist.1"));
        }
    }

    public static void start() {
        if (WatchMohist.isEnable()) {
            MohistThreadBox.WatchMohist.scheduleAtFixedRate(new WatchMohist(), 30000L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public static void update() {
        if (WatchMohist.isEnable()) {
            Time = System.currentTimeMillis();
        }
    }

    public static void stop() {
        if (WatchMohist.isEnable()) {
            MohistThreadBox.WatchMohist.shutdown();
        }
    }

    public static boolean isEnable() {
        return MohistConfig.instance.watchdog_mohist.getValue();
    }
}

