/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public final class EntityEntryBuilder<E extends vg> {
    private final ModContainer mod = Loader.instance().activeModContainer();
    @Nullable
    private Class<? extends E> entity;
    @Nullable
    private Function<amu, E> factory;
    @Nullable
    private nf id;
    private int network;
    @Nullable
    private String name;
    private int trackingRange;
    private int trackingUpdateFrequency;
    private boolean trackingVelocityUpdates;
    private boolean eggProvided;
    private int primaryEggColor;
    private int secondaryEggColor;
    private boolean statisticsRegistered;
    @Nullable
    private qo killEntityStatistic;
    @Nullable
    private qo entityKilledByStatistic;
    @Nullable
    private Collection<Spawn> spawns;

    @Nonnull
    public static <E extends vg> EntityEntryBuilder<E> create() {
        return new EntityEntryBuilder<E>();
    }

    private EntityEntryBuilder() {
    }

    @Nonnull
    public final EntityEntryBuilder<E> entity(@Nonnull Class<? extends E> entity) {
        this.entity = (Class)Preconditions.checkNotNull(entity, (Object)"entity class");
        return this;
    }

    @Nonnull
    public final EntityEntryBuilder<E> factory(@Nonnull Function<amu, E> factory) {
        this.factory = (Function)Preconditions.checkNotNull(factory, (Object)"entity factory");
        return this;
    }

    @Nonnull
    public final EntityEntryBuilder<E> id(@Nonnull nf id, int network) {
        this.id = (nf)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.network = network;
        return this;
    }

    @Nonnull
    public final EntityEntryBuilder<E> id(@Nonnull String id, int network) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        return this.id(new nf(id.indexOf(58) == -1 ? this.mod.getModId() + ':' + id : id), network);
    }

    @Nonnull
    public final EntityEntryBuilder<E> name(@Nonnull String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        return this;
    }

    @Nonnull
    public final EntityEntryBuilder<E> tracker(int range, int updateFrequency, boolean sendVelocityUpdates) {
        this.trackingRange = range;
        this.trackingUpdateFrequency = updateFrequency;
        this.trackingVelocityUpdates = sendVelocityUpdates;
        return this;
    }

    @Nonnull
    public final EntityEntryBuilder<E> spawn(@Nonnull vr type, int weight, int min, int max, anh ... biomes) {
        Preconditions.checkNotNull((Object)biomes, (Object)"biomes");
        return this.spawn(type, weight, min, max, Arrays.asList(biomes));
    }

    @Nonnull
    public final EntityEntryBuilder<E> spawn(@Nonnull vr type, int weight, int min, int max, @Nonnull Iterable<anh> biomes) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkNotNull(biomes, (Object)"biomes");
        if (this.entity != null) {
            Preconditions.checkArgument((boolean)vq.class.isAssignableFrom(this.entity), (String)"Cannot add spawns to a non-%s", (Object)vq.class.getSimpleName());
        }
        if (this.spawns == null) {
            this.spawns = new ArrayList<Spawn>();
        }
        this.spawns.add(new Spawn(type, weight, min, max, biomes));
        return this;
    }

    @Nonnull
    public final EntityEntryBuilder<E> egg(int primaryColor, int secondaryColor) {
        this.eggProvided = true;
        this.primaryEggColor = primaryColor;
        this.secondaryEggColor = secondaryColor;
        return this;
    }

    @Nonnull
    public EntityEntry build() {
        Preconditions.checkState((this.entity != null ? 1 : 0) != 0, (Object)"entity class not provided");
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"entity id not provided");
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"entity name not provided");
        if (this.spawns != null) {
            Preconditions.checkState((boolean)vq.class.isAssignableFrom(this.entity), (String)"Cannot add spawns to a non-%s", (Object)vq.class.getSimpleName());
        }
        BuiltEntityEntry entry = new BuiltEntityEntry(this.entity, this.name);
        entry.factory = this.factory != null ? this.factory : new ConstructorFactory<E>(this.entity){

            @Override
            protected String describeEntity() {
                return String.valueOf(EntityEntryBuilder.this.id);
            }
        };
        entry.setRegistryName(this.id);
        if (this.eggProvided) {
            this.killEntityStatistic = new qo("stat.killEntity." + this.name, (hh)new hp("stat.entityKill", new Object[]{new hp("entity." + this.name + ".name", new Object[0])}));
            this.entityKilledByStatistic = new qo("stat.entityKilledBy." + this.name, (hh)new hp("stat.entityKilledBy", new Object[]{new hp("entity." + this.name + ".name", new Object[0])}));
            entry.setEgg(new vi.a(this.id, this.primaryEggColor, this.secondaryEggColor, this.killEntityStatistic, this.entityKilledByStatistic));
        }
        return entry;
    }

    private void registerStatistics() {
        if (!this.statisticsRegistered && this.killEntityStatistic != null && this.entityKilledByStatistic != null) {
            this.killEntityStatistic.a();
            this.entityKilledByStatistic.a();
            this.statisticsRegistered = true;
        }
    }

    public final class Spawn {
        private final vr type;
        private final int weight;
        private final int min;
        private final int max;
        private final Iterable<anh> biomes;

        public Spawn(vr type, int weight, int min, int max, Iterable<anh> biomes) {
            this.type = type;
            this.weight = weight;
            this.min = min;
            this.max = max;
            this.biomes = biomes;
        }

        final void insert() {
            for (anh biome : this.biomes) {
                List entries = biome.a(this.type);
                boolean found = false;
                for (anh.c entry : entries) {
                    if (entry.b != EntityEntryBuilder.this.entity) continue;
                    entry.a = this.weight;
                    entry.c = this.min;
                    entry.d = this.max;
                    found = true;
                    break;
                }
                if (found) continue;
                entries.add(new anh.c(EntityEntryBuilder.this.entity, this.weight, this.min, this.max));
            }
        }
    }

    public final class BuiltEntityEntry
    extends EntityEntry {
        private boolean added;

        BuiltEntityEntry(Class<? extends vg> cls, String name) {
            super(cls, name);
        }

        @Override
        protected final void init() {
        }

        public final void addedToRegistry() {
            if (this.added) {
                return;
            }
            this.added = true;
            EntityEntryBuilder.this.registerStatistics();
            EntityRegistry.instance().insert(EntityEntryBuilder.this.entity, this.createRegistration());
            if (EntityEntryBuilder.this.spawns != null) {
                for (Spawn spawn : EntityEntryBuilder.this.spawns) {
                    spawn.insert();
                }
                EntityEntryBuilder.this.spawns = null;
            }
        }

        @Nonnull
        private EntityRegistry.EntityRegistration createRegistration() {
            EntityEntryBuilder builder = EntityEntryBuilder.this;
            EntityRegistry entityRegistry = EntityRegistry.instance();
            entityRegistry.getClass();
            return new EntityRegistry.EntityRegistration(entityRegistry, builder.mod, builder.id, builder.entity, builder.name, builder.network, builder.trackingRange, builder.trackingUpdateFrequency, builder.trackingVelocityUpdates, this.factory);
        }
    }

    static abstract class ConstructorFactory<E extends vg>
    implements Function<amu, E> {
        private final Constructor<? extends E> constructor;

        ConstructorFactory(Class<? extends E> entity) {
            this.constructor = ObfuscationReflectionHelper.findConstructor(entity, amu.class);
        }

        @Override
        public E apply(amu world) {
            try {
                return (E)((vg)this.constructor.newInstance(world));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                return null;
            }
        }

        protected abstract String describeEntity();
    }
}

