/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import com.mohistmc.util.i18n.Message;
import java.io.File;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.TracingPrintStream;
import net.minecraftforge.fml.common.launcher.FMLTweaker;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import org.apache.logging.log4j.LogManager;

public class FMLLaunchHandler {
    static Side side;
    private static FMLLaunchHandler INSTANCE;
    private final LaunchClassLoader classLoader;
    private final FMLTweaker tweaker;
    private final File minecraftHome;

    private FMLLaunchHandler(LaunchClassLoader launchLoader, FMLTweaker tweaker) {
        this.classLoader = launchLoader;
        this.tweaker = tweaker;
        this.minecraftHome = tweaker.getGameDir();
        this.classLoader.addClassLoaderExclusion("net.minecraftforge.fml.relauncher.");
        this.classLoader.addClassLoaderExclusion("net.minecraftforge.classloading.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.fml.common.asm.transformers.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.fml.common.patcher.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.fml.repackage.");
        this.classLoader.addClassLoaderExclusion("org.apache.commons.");
        this.classLoader.addClassLoaderExclusion("org.apache.http.");
        this.classLoader.addClassLoaderExclusion("org.apache.maven.");
        this.classLoader.addClassLoaderExclusion("com.google.common.");
        this.classLoader.addClassLoaderExclusion("org.objectweb.asm.");
        this.classLoader.addClassLoaderExclusion("LZMA.");
        this.classLoader.addClassLoaderExclusion("jdk.nashorn.");
    }

    public static void configureForClientLaunch(LaunchClassLoader loader, FMLTweaker tweaker) {
        FMLLaunchHandler.instance(loader, tweaker).setupClient();
    }

    public static void configureForServerLaunch(LaunchClassLoader loader, FMLTweaker tweaker) {
        FMLLaunchHandler.instance(loader, tweaker).setupServer();
    }

    private static FMLLaunchHandler instance(LaunchClassLoader launchLoader, FMLTweaker tweaker) {
        if (INSTANCE == null) {
            INSTANCE = new FMLLaunchHandler(launchLoader, tweaker);
        }
        return INSTANCE;
    }

    public static Side side() {
        return side;
    }

    public static void appendCoreMods() {
        INSTANCE.injectPostfixTransformers();
    }

    public static boolean isDeobfuscatedEnvironment() {
        return CoreModManager.deobfuscatedEnvironment;
    }

    private void setupClient() {
        side = Side.CLIENT;
        this.setupHome();
    }

    private void setupServer() {
        side = Side.SERVER;
        this.setupHome();
    }

    private void setupHome() {
        FMLInjectionData.build(this.minecraftHome, this.classLoader);
        this.redirectStdOutputToLog();
        FMLLog.log.info(Message.getFormatString("start.1", new Object[]{FMLInjectionData.major, FMLInjectionData.minor, FMLInjectionData.rev, FMLInjectionData.build, FMLInjectionData.mccversion}));
        FMLLog.log.info(Message.getFormatString("start.2", new Object[]{System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.home")}));
        FMLLog.log.debug(Message.getString("start.3"));
        for (String path : System.getProperty("java.class.path").split(File.pathSeparator)) {
            FMLLog.log.debug("    {}", (Object)path);
        }
        FMLLog.log.debug(Message.getString("start.4"));
        for (String path : System.getProperty("java.library.path").split(File.pathSeparator)) {
            FMLLog.log.debug("    {}", (Object)path);
        }
        try {
            LibraryManager.setup(this.minecraftHome);
            CoreModManager.handleLaunch(this.minecraftHome, this.classLoader, this.tweaker);
        }
        catch (Throwable t) {
            throw new RuntimeException("An error occurred trying to configure the Minecraft home at " + this.minecraftHome.getAbsolutePath() + " for Forge Mod Loader", t);
        }
    }

    private void redirectStdOutputToLog() {
        FMLLog.log.debug("Injecting tracing printstreams for STDOUT/STDERR.");
        System.setOut(new TracingPrintStream(LogManager.getLogger((String)"STDOUT"), System.out));
        System.setErr(new TracingPrintStream(LogManager.getLogger((String)"STDERR"), System.err));
    }

    private void injectPostfixTransformers() {
        CoreModManager.injectTransformers(this.classLoader);
    }
}

