/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Map;

public enum CropState {
    SEEDED(0),
    GERMINATED(1),
    VERY_SMALL(2),
    SMALL(3),
    MEDIUM(4),
    TALL(5),
    VERY_TALL(6),
    RIPE(7);

    private static final Map<Byte, CropState> BY_DATA;
    private final byte data;

    private CropState(int data) {
        this.data = (byte)data;
    }

    public static CropState getByData(byte data) {
        return BY_DATA.get(data);
    }

    public byte getData() {
        return this.data;
    }

    static {
        BY_DATA = Maps.newHashMap();
        for (CropState cropState : CropState.values()) {
            BY_DATA.put(cropState.getData(), cropState);
        }
    }
}

