/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;

public class TicksPerSecondCommand
extends Command {
    public TicksPerSecondCommand(String name) {
        super(name);
        this.description = "Gets the current ticks per second for the server";
        this.usageMessage = "/tps";
        this.setPermission("bukkit.command.tps");
    }

    public static String format(double tps) {
        return (tps > 18.0 ? ChatColor.GREEN : (tps > 16.0 ? ChatColor.YELLOW : ChatColor.RED)).toString() + (tps > 20.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0);
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        ChatColor colourTPS;
        if (!this.testPermission(sender)) {
            return true;
        }
        World currentWorld = null;
        if (sender instanceof CraftPlayer) {
            currentWorld = ((CraftPlayer)sender).getWorld();
        }
        sender.sendMessage((Object)((Object)ChatColor.DARK_RED) + "---------------------------------------");
        MinecraftServer server = MinecraftServer.getServerInst();
        for (World world : server.server.getWorlds()) {
            if (!(world instanceof CraftWorld)) continue;
            boolean current = currentWorld != null && currentWorld == world;
            oo mcWorld = ((CraftWorld)world).getHandle();
            String bukkitName = world.getName();
            int dimensionId = mcWorld.s.getDimension();
            String name = mcWorld.s.q().b();
            String displayName = name.equals(bukkitName) ? name : String.format("%s | %s", name, bukkitName);
            double worldTickTime = (double)TicksPerSecondCommand.mean((long[])server.worldTickTimes.get(dimensionId)) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
            colourTPS = worldTPS >= 18.0 ? ChatColor.GREEN : (worldTPS >= 15.0 ? ChatColor.YELLOW : ChatColor.RED);
            sender.sendMessage(String.format("%s[%d] %s%s %s- %s%.2fms / %s%.2ftps", new Object[]{ChatColor.GOLD, dimensionId, current ? ChatColor.GREEN : ChatColor.YELLOW, displayName, ChatColor.RESET, ChatColor.DARK_RED, worldTickTime, colourTPS, worldTPS}));
        }
        double meanTickTime = (double)TicksPerSecondCommand.mean(server.h) * 1.0E-6;
        double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
        colourTPS = meanTPS >= 18.0 ? ChatColor.GREEN : (meanTPS >= 15.0 ? ChatColor.YELLOW : ChatColor.RED);
        sender.sendMessage(String.format("%sOverall - %s%s%.2fms / %s%.2ftps", new Object[]{ChatColor.BLUE, ChatColor.RESET, ChatColor.DARK_RED, meanTickTime, colourTPS, meanTPS}));
        sender.sendMessage((Object)((Object)ChatColor.DARK_RED) + "---------------------------------------");
        double[] tps = Bukkit.getTPS();
        Object[] tpsAvg = new String[tps.length];
        for (int i2 = 0; i2 < tps.length; ++i2) {
            tpsAvg[i2] = TicksPerSecondCommand.format(tps[i2]);
        }
        sender.sendMessage((Object)((Object)ChatColor.GOLD) + "TPS from last 1m, 5m, 15m: " + StringUtils.join((Object[])tpsAvg, (String)", "));
        return true;
    }

    private static final long mean(long[] array) {
        if (array == null || array.length == 0) {
            return 0L;
        }
        long r2 = 0L;
        for (long i2 : array) {
            r2 += i2;
        }
        return r2 / (long)array.length;
    }
}

