/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.config.PaperConfig;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class PaperCommand
extends Command {
    private static final String BASE_PERM = "bukkit.command.paper.";
    private static final ImmutableSet<String> SUBCOMMANDS = ImmutableSet.builder().add((Object[])new String[]{"heap", "entity", "reload", "version", "debug", "chunkinfo"}).build();

    public PaperCommand(String name) {
        super(name);
        this.description = "Paper related commands";
        this.usageMessage = "/paper [" + Joiner.on((String)" | ").join(SUBCOMMANDS) + "]";
        this.setPermission("bukkit.command.paper;" + Joiner.on((char)';').join((Iterable)SUBCOMMANDS.stream().map(s -> BASE_PERM + s).collect(Collectors.toSet())));
    }

    private static boolean testPermission(CommandSender commandSender, String permission) {
        if (commandSender.hasPermission(BASE_PERM + permission) || commandSender.hasPermission("bukkit.command.paper")) {
            return true;
        }
        commandSender.sendMessage(Bukkit.getPermissionMessage());
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        if (args.length <= 1) {
            return PaperCommand.getListMatchingLast(sender, args, SUBCOMMANDS);
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "entity": {
                if (args.length == 2) {
                    return PaperCommand.getListMatchingLast(sender, args, "help", "list");
                }
                if (args.length != 3) break;
                return PaperCommand.getListMatchingLast(sender, args, (String[])EntityType.getEntityNameList().stream().map(ResourceLocation::toString).sorted().toArray(String[]::new));
            }
            case "debug": {
                if (args.length != 2) break;
                return PaperCommand.getListMatchingLast(sender, args, "help", "chunks");
            }
            case "chunkinfo": {
                ArrayList<String> worldNames = new ArrayList<String>();
                worldNames.add("*");
                for (World world : Bukkit.getWorlds()) {
                    worldNames.add(world.getName());
                }
                if (args.length != 2) break;
                return PaperCommand.getListMatchingLast(sender, args, worldNames);
            }
        }
        return Collections.emptyList();
    }

    public static List<String> getListMatchingLast(CommandSender sender, String[] args, String ... matches) {
        return PaperCommand.getListMatchingLast(sender, args, Arrays.asList(matches));
    }

    public static boolean matches(String s, String s1) {
        return s1.regionMatches(true, 0, s, 0, s.length());
    }

    public static List<String> getListMatchingLast(CommandSender sender, String[] strings, Collection<?> collection) {
        String last = strings[strings.length - 1];
        ArrayList results = Lists.newArrayList();
        if (!collection.isEmpty()) {
            for (String s1 : Iterables.transform(collection, (Function)Functions.toStringFunction())) {
                if (!PaperCommand.matches(last, s1) || !sender.hasPermission(BASE_PERM + s1) && !sender.hasPermission("bukkit.command.paper")) continue;
                results.add(s1);
            }
            if (results.isEmpty()) {
                for (Object object : collection) {
                    if (!(object instanceof ResourceLocation) || !PaperCommand.matches(last, ((ResourceLocation)object).func_110623_a())) continue;
                    results.add(String.valueOf(object));
                }
            }
        }
        return results;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if (SUBCOMMANDS.contains((Object)args[0].toLowerCase(Locale.ENGLISH)) && !PaperCommand.testPermission(sender, args[0].toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "heap": {
                this.dumpHeap(sender);
                break;
            }
            case "reload": {
                this.doReload(sender);
                break;
            }
            case "debug": {
                this.doDebug(sender, args);
                break;
            }
            case "ver": {
                if (!PaperCommand.testPermission(sender, "version")) break;
            }
            case "version": {
                Command ver = Bukkit.getServer().getCommandMap().getCommand("version");
                if (ver != null) {
                    ver.execute(sender, commandLabel, new String[0]);
                    break;
                }
            }
            default: {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }

    private void doDebug(CommandSender sender, String[] args) {
        String debugType;
        if (args.length < 2) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Use /paper debug [chunks] help for more information on a specific command");
            return;
        }
        switch (debugType = args[1].toLowerCase(Locale.ENGLISH)) {
            case "chunks": {
                if (args.length >= 3 && args[2].toLowerCase(Locale.ENGLISH).equals("help")) {
                    sender.sendMessage((Object)((Object)ChatColor.RED) + "Use /paper debug chunks to dump loaded chunk information to a file");
                    break;
                }
                File file = new File(new File(new File("."), "debug"), "chunks-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + ".txt");
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Writing chunk information dump to " + file.toString());
                try {
                    sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Successfully written chunk information!");
                }
                catch (Throwable thr) {
                    MinecraftServer.field_147145_h.warn("Failed to dump chunk information to file " + file.toString(), thr);
                    sender.sendMessage((Object)((Object)ChatColor.RED) + "Failed to dump chunk information, see console");
                }
                break;
            }
            default: {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Use /paper debug [chunks] help for more information on a specific command");
                return;
            }
        }
    }

    private void dumpHeap(CommandSender sender) {
    }

    private void doReload(CommandSender sender) {
        Command.broadcastCommandMessage(sender, (Object)((Object)ChatColor.RED) + "Please note that this command is not supported and may cause issues.");
        Command.broadcastCommandMessage(sender, (Object)((Object)ChatColor.RED) + "If you encounter any issues please use the /stop command to restart your server.");
        MinecraftServer console = MinecraftServer.getServer();
        PaperConfig.init((File)MinecraftServer.options.valueOf("paper-settings"));
        for (ServerWorld serverWorld : console.func_212370_w()) {
        }
        ++console.server.reloadCount;
        Command.broadcastCommandMessage(sender, (Object)((Object)ChatColor.GREEN) + "Paper config reload complete.");
    }
}

