/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.config;

import com.destroystokyo.paper.config.PaperConfig;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.spigotmc.SpigotWorldConfig;

public class PaperWorldConfig {
    private final String worldName;
    private final SpigotWorldConfig spigotConfig;
    private YamlConfiguration config;
    private boolean verbose;
    public boolean perPlayerMobSpawns = false;
    public short keepLoadedRange;
    public int autoSavePeriod = -1;
    public int maxAutoSaveChunksPerTick = 24;

    public PaperWorldConfig(String worldName, SpigotWorldConfig spigotConfig) {
        this.worldName = worldName;
        this.spigotConfig = spigotConfig;
        this.config = PaperConfig.config;
        this.init();
    }

    public void init() {
        this.config = PaperConfig.config;
        PaperConfig.log("-------- World Settings For [" + this.worldName + "] --------");
        PaperConfig.readConfig(PaperWorldConfig.class, this);
    }

    private void set(String path, Object val) {
        this.config.set("world-settings.default." + path, val);
        if (this.config.get("world-settings." + this.worldName + "." + path) != null) {
            this.config.set("world-settings." + this.worldName + "." + path, val);
        }
    }

    private void perPlayerMobSpawns() {
        this.perPlayerMobSpawns = this.getBoolean("per-player-mob-spawns", false);
    }

    private boolean getBoolean(String path, boolean def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getBoolean("world-settings." + this.worldName + "." + path, this.config.getBoolean("world-settings.default." + path));
    }

    private double getDouble(String path, double def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getDouble("world-settings." + this.worldName + "." + path, this.config.getDouble("world-settings.default." + path));
    }

    private int getInt(String path, int def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getInt("world-settings." + this.worldName + "." + path, this.config.getInt("world-settings.default." + path));
    }

    private float getFloat(String path, float def) {
        return (float)this.getDouble(path, def);
    }

    private <T> List<T> getList(String path, List<T> def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getList("world-settings." + this.worldName + "." + path, this.config.getList("world-settings.default." + path));
    }

    private String getString(String path, String def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getString("world-settings." + this.worldName + "." + path, this.config.getString("world-settings.default." + path));
    }

    private void keepLoadedRange() {
        this.keepLoadedRange = (short)(this.getInt("keep-spawn-loaded-range", Math.min(this.spigotConfig.viewDistance, 10)) * 16);
        PaperConfig.log("Keep Spawn Loaded Range: " + this.keepLoadedRange / 16);
    }

    private void autoSavePeriod() {
        this.autoSavePeriod = this.getInt("auto-save-interval", -1);
        if (this.autoSavePeriod > 0) {
            PaperConfig.log("Auto Save Interval: " + this.autoSavePeriod + " (" + this.autoSavePeriod / 20 + "s)");
        } else if (this.autoSavePeriod < 0) {
            this.autoSavePeriod = MinecraftServer.getServer().autosavePeriod;
        }
    }

    private void maxAutoSaveChunksPerTick() {
        this.maxAutoSaveChunksPerTick = this.getInt("max-auto-save-chunks-per-tick", 24);
    }
}

