/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.map;

import com.destroystokyo.paper.util.concurrent.WeakSeqLock;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueuedChangesMapLong2Object<V> {
    protected static final Object REMOVED = new Object();
    protected final Long2ObjectLinkedOpenHashMap<V> updatingMap;
    protected final Long2ObjectLinkedOpenHashMap<V> visibleMap;
    protected final Long2ObjectLinkedOpenHashMap<Object> queuedChanges;
    protected final WeakSeqLock updatingMapSeqLock = new WeakSeqLock();

    public QueuedChangesMapLong2Object() {
        this(16, 0.75f);
    }

    public QueuedChangesMapLong2Object(int capacity, float loadFactor) {
        this.updatingMap = new Long2ObjectLinkedOpenHashMap(capacity, loadFactor);
        this.visibleMap = new Long2ObjectLinkedOpenHashMap(capacity, loadFactor);
        this.queuedChanges = new Long2ObjectLinkedOpenHashMap();
    }

    public V queueUpdate(long k, V value) {
        this.queuedChanges.put(k, value);
        return (V)this.updatingMap.put(k, value);
    }

    public V queueRemove(long k) {
        this.queuedChanges.put(k, REMOVED);
        return (V)this.updatingMap.remove(k);
    }

    public V getUpdating(long k) {
        return (V)this.updatingMap.get(k);
    }

    public boolean updatingContainsKey(long k) {
        return this.updatingMap.containsKey(k);
    }

    public V getVisible(long k) {
        return (V)this.visibleMap.get(k);
    }

    public boolean visibleContainsKey(long k) {
        return this.visibleMap.containsKey(k);
    }

    public V getVisibleAsync(long k) {
        long readlock;
        Object ret = null;
        do {
            readlock = this.updatingMapSeqLock.acquireRead();
            try {
                ret = this.visibleMap.get(k);
            }
            catch (Throwable thr) {
                if (!(thr instanceof ThreadDeath)) continue;
                throw (ThreadDeath)thr;
            }
        } while (!this.updatingMapSeqLock.tryReleaseRead(readlock));
        return (V)ret;
    }

    public boolean visibleContainsKeyAsync(long k) {
        long readlock;
        boolean ret = false;
        do {
            readlock = this.updatingMapSeqLock.acquireRead();
            try {
                ret = this.visibleMap.containsKey(k);
            }
            catch (Throwable thr) {
                if (!(thr instanceof ThreadDeath)) continue;
                throw (ThreadDeath)thr;
            }
        } while (!this.updatingMapSeqLock.tryReleaseRead(readlock));
        return ret;
    }

    public Long2ObjectLinkedOpenHashMap<V> getVisibleMap() {
        return this.visibleMap;
    }

    public Long2ObjectLinkedOpenHashMap<V> getUpdatingMap() {
        return this.updatingMap;
    }

    public int getVisibleSize() {
        return this.visibleMap.size();
    }

    public int getVisibleSizeAsync() {
        int ret;
        long readlock;
        do {
            readlock = this.updatingMapSeqLock.acquireRead();
            ret = this.visibleMap.size();
        } while (!this.updatingMapSeqLock.tryReleaseRead(readlock));
        return ret;
    }

    public Collection<V> getUpdatingValues() {
        return this.updatingMap.values();
    }

    public List<V> getUpdatingValuesCopy() {
        return new ArrayList(this.updatingMap.values());
    }

    public Collection<V> getVisibleValues() {
        return this.visibleMap.values();
    }

    public List<V> getVisibleValuesCopy() {
        return new ArrayList(this.visibleMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performUpdates() {
        if (this.queuedChanges.isEmpty()) {
            return false;
        }
        ObjectBidirectionalIterator iterator = this.queuedChanges.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long key = entry.getLongKey();
            Object val = entry.getValue();
            this.updatingMapSeqLock.acquireWrite();
            try {
                if (val == REMOVED) {
                    this.visibleMap.remove(key);
                    continue;
                }
                this.visibleMap.put(key, val);
            }
            finally {
                this.updatingMapSeqLock.releaseWrite();
            }
        }
        this.queuedChanges.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performUpdatesLockMap() {
        if (this.queuedChanges.isEmpty()) {
            return false;
        }
        ObjectBidirectionalIterator iterator = this.queuedChanges.long2ObjectEntrySet().fastIterator();
        try {
            this.updatingMapSeqLock.acquireWrite();
            while (iterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
                long key = entry.getLongKey();
                Object val = entry.getValue();
                if (val == REMOVED) {
                    this.visibleMap.remove(key);
                    continue;
                }
                this.visibleMap.put(key, val);
            }
        }
        finally {
            this.updatingMapSeqLock.releaseWrite();
        }
        this.queuedChanges.clear();
        return true;
    }
}

