/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.set;

import java.util.Collection;

public final class OptimizedSmallEnumSet<E extends Enum<E>> {
    private final Class<E> enumClass;
    private long backingSet;

    public OptimizedSmallEnumSet(Class<E> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException("Class must be enum, not " + clazz.getCanonicalName());
        }
        this.enumClass = clazz;
    }

    public boolean addUnchecked(E element) {
        int ordinal = ((Enum)element).ordinal();
        long key = 1L << ordinal;
        long prev = this.backingSet;
        this.backingSet = prev | key;
        return (prev & key) == 0L;
    }

    public boolean removeUnchecked(E element) {
        int ordinal = ((Enum)element).ordinal();
        long key = 1L << ordinal;
        long prev = this.backingSet;
        this.backingSet = prev & (key ^ 0xFFFFFFFFFFFFFFFFL);
        return (prev & key) != 0L;
    }

    public void clear() {
        this.backingSet = 0L;
    }

    public int size() {
        return Long.bitCount(this.backingSet);
    }

    public void addAllUnchecked(Collection<E> enums) {
        for (Enum element : enums) {
            if (element == null) {
                throw new NullPointerException("Null element");
            }
            this.backingSet |= 1L << element.ordinal();
        }
    }

    public long getBackingSet() {
        return this.backingSet;
    }

    public boolean hasCommonElements(OptimizedSmallEnumSet<E> other) {
        return (other.backingSet & this.backingSet) != 0L;
    }
}

