/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.configuration;

import com.mohistmc.configuration.TickParams;
import java.io.File;
import java.util.HashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class TickConfig {
    private static final TickParams DEFAULT_TICK_PARAMS = new TickParams();
    private static final String DEFAULTS_SEC;
    private static final String OVERRIDES_SEC;
    private static final String SKIP_EVERY_KEY;
    private static final String DEFAULT_VAL;
    public static final TickConfig ENTITIES;
    public static final TickConfig TILES;
    private final File cfgfile;
    private final String typename;
    private final HashMap<Class<?>, TickParams> paramsMap;
    private YamlConfiguration cfg;
    private TickParams defaultLoadedParams;

    public boolean canTick(Class<?> clazz, long gametime) {
        TickParams params = this.paramsMap.get(clazz);
        if (params == null) {
            if (this.cfg == null) {
                this.reloadConfig();
            }
            params = new TickParams();
            params.skipEvery = this.defaultLoadedParams.skipEvery;
            this.paramsMap.put(clazz, params);
            this.cfg.set(OVERRIDES_SEC + "." + this.formatClazz(clazz) + "." + SKIP_EVERY_KEY, DEFAULT_VAL);
            this.saveConfig();
        }
        return params.skipEvery == 0 || gametime % (long)params.skipEvery != 0L;
    }

    public void reloadConfig() {
        this.paramsMap.clear();
        this.cfg = YamlConfiguration.loadConfiguration(this.cfgfile);
        if (this.cfgfile.exists()) {
            ConfigurationSection defaultsSec = this.cfg.getConfigurationSection(DEFAULTS_SEC);
            if (defaultsSec == null) {
                this.defaultLoadedParams = new TickParams();
                this.defaultLoadedParams.skipEvery = TickConfig.DEFAULT_TICK_PARAMS.skipEvery;
            } else {
                this.defaultLoadedParams = this.parseTickParams(defaultsSec);
            }
            ConfigurationSection overridesSec = this.cfg.getConfigurationSection(OVERRIDES_SEC);
            if (overridesSec != null) {
                for (String override : overridesSec.getKeys(false)) {
                    ConfigurationSection overrideSec = overridesSec.getConfigurationSection(override);
                    if (overrideSec == null) continue;
                    try {
                        Class<?> overrideCls = Class.forName(this.unformatClazz(override));
                        TickParams params = this.parseTickParams(overrideSec);
                        this.paramsMap.put(overrideCls, params);
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            this.cfg.options().header("Welcome to Mohist " + this.typename + " tick configuration!\nThis opens up good TPS savings if used wisely.\n'" + OVERRIDES_SEC + "' section populates itself over time.\n-=-=-=-=-\nSimple usage cases:\n'" + SKIP_EVERY_KEY + ": 50' - skips every 50th tick\n'" + SKIP_EVERY_KEY + ": 0' - tick limiter is not applied (vanilla behaviour)\n'" + SKIP_EVERY_KEY + ": 1' - " + this.typename + " will not tick at all (skips every 1st tick)\n'" + SKIP_EVERY_KEY + ": " + DEFAULT_VAL + "' - value is grabbed from '" + DEFAULTS_SEC + "' section\nValues in range of 0 up to 1000 can be used, you won't need more than that.\n-=-=-=-=-\n");
            this.defaultLoadedParams = new TickParams();
            this.defaultLoadedParams.skipEvery = TickConfig.DEFAULT_TICK_PARAMS.skipEvery;
            ConfigurationSection defaultsSec = this.cfg.createSection("defaults");
            defaultsSec.set(SKIP_EVERY_KEY, this.defaultLoadedParams.skipEvery);
            this.cfg.createSection("overrides");
            this.saveConfig();
        }
    }

    private TickParams parseTickParams(ConfigurationSection sec) {
        TickParams params = new TickParams();
        if (sec.isInt(SKIP_EVERY_KEY)) {
            int skipEvery = sec.getInt(SKIP_EVERY_KEY);
            if (skipEvery > 1000) {
                skipEvery = 1000;
            }
            if (skipEvery < 0) {
                skipEvery = 0;
            }
            params.skipEvery = skipEvery;
        } else {
            params.skipEvery = sec.getParent().getName().equals(OVERRIDES_SEC) ? this.defaultLoadedParams.skipEvery : TickConfig.DEFAULT_TICK_PARAMS.skipEvery;
        }
        return params;
    }

    private String formatClazz(Class<?> clazz) {
        return clazz.getName().replace('.', '-');
    }

    private String unformatClazz(String clazz) {
        return clazz.replace('-', '.');
    }

    private void saveConfig() {
        try {
            this.cfg.save(this.cfgfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TickConfig(String filename, String typename) {
        this.cfgfile = new File("mohist-config", filename);
        this.typename = typename;
        this.paramsMap = new HashMap();
    }

    static {
        TickConfig.DEFAULT_TICK_PARAMS.skipEvery = 0;
        DEFAULTS_SEC = "defaults";
        OVERRIDES_SEC = "overrides";
        SKIP_EVERY_KEY = "skip-every";
        DEFAULT_VAL = "default";
        ENTITIES = new TickConfig("entities.yml", "entity");
        TILES = new TickConfig("tiles.yml", "tile");
    }
}

