/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util.pluginmanager;

import com.mohistmc.util.i18n.i18n;
import com.mohistmc.util.pluginmanager.Control;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginManagers {
    public static String permission = "mohist.command.plugin";

    public static boolean loadPluginCommand(CommandSender sender, String label, String[] split) {
        PluginDescriptionFile desc;
        if (split.length < 2) {
            Object[] f = new Object[]{label};
            sender.sendMessage(i18n.get((String)"pluginscommand.load", (Object[])f));
            return true;
        }
        Object[] objects = new Object[]{split[1]};
        String jarName = split[1] + (split[1].endsWith(".jar") ? "" : ".jar");
        File toLoad = new File("plugins" + File.separator + jarName);
        if (!toLoad.exists()) {
            jarName = split[1] + (split[1].endsWith(".jar") ? ".unloaded" : ".jar.unloaded");
            toLoad = new File("plugins" + File.separator + jarName);
            if (!toLoad.exists()) {
                sender.sendMessage(i18n.get((String)"pluginscommand.nofile", (Object[])objects));
                return true;
            }
            String fileName = jarName.substring(0, jarName.length() - ".unloaded".length());
            toLoad = new File("plugins" + File.separator + fileName);
            File unloaded = new File("plugins" + File.separator + jarName);
            unloaded.renameTo(toLoad);
        }
        if ((desc = Control.getDescription(toLoad)) == null) {
            sender.sendMessage(i18n.get((String)"pluginscommand.noyml", (Object[])objects));
            return true;
        }
        Plugin[] pl = Bukkit.getPluginManager().getPlugins();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(Arrays.asList(pl));
        for (Plugin p : plugins) {
            if (!desc.getName().equals(p.getName())) continue;
            sender.sendMessage(i18n.get((String)"pluginscommand.alreadyloaded", (Object[])new Object[]{desc.getName()}));
            return true;
        }
        Plugin p = Control.loadPlugin(toLoad);
        if (p != null) {
            Bukkit.getServer().getPluginManager().enablePlugin(p);
            sender.sendMessage(i18n.get((String)"pluginscommand.loaded", (Object[])new Object[]{p.getDescription().getName(), p.getDescription().getVersion()}));
        } else {
            sender.sendMessage(i18n.get((String)"pluginscommand.notload", (Object[])objects));
        }
        return true;
    }

    public static boolean unloadPluginCommand(CommandSender sender, String label, String[] split) {
        if (split.length < 2) {
            sender.sendMessage(i18n.get((String)"pluginscommand.unload", (Object[])new Object[]{label}));
            return true;
        }
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin(split[1]);
        Object[] objects = new Object[]{split[1]};
        if (p == null) {
            sender.sendMessage(i18n.get((String)"pluginscommand.noplugin", (Object[])objects));
        } else if (Control.unloadPlugin(p)) {
            sender.sendMessage(i18n.get((String)"pluginscommand.unloaded", (Object[])new Object[]{p.getDescription().getName(), p.getDescription().getVersion()}));
        } else {
            sender.sendMessage(i18n.get((String)"pluginscommand.notunload", (Object[])objects));
        }
        return true;
    }

    public static boolean reloadPluginCommand(CommandSender sender, String label, String[] split) {
        if (split.length < 2) {
            sender.sendMessage(i18n.get((String)"pluginscommand.reload", (Object[])new Object[]{label}));
            return true;
        }
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin(split[1]);
        Object[] objects = new Object[]{split[1]};
        if (p == null) {
            sender.sendMessage(i18n.get((String)"pluginscommand.noplugin", (Object[])objects));
        } else {
            File file = Control.getFile((JavaPlugin)p);
            if (file == null) {
                sender.sendMessage(i18n.get((String)"pluginscommand.nojar", (Object[])new Object[]{p.getName()}));
                return true;
            }
            File name = new File("plugins" + File.separator + file.getName());
            JavaPlugin loaded = null;
            if (!Control.unloadPlugin(p)) {
                sender.sendMessage(i18n.get((String)"pluginscommand.unloaderror", (Object[])objects));
            } else {
                loaded = (JavaPlugin)Control.loadPlugin(name);
                if (loaded == null) {
                    sender.sendMessage(i18n.get((String)"pluginscommand.nojar", (Object[])objects));
                }
            }
            Bukkit.getPluginManager().enablePlugin(loaded);
            sender.sendMessage(i18n.get((String)"pluginscommand.reloaded", (Object[])new Object[]{split[1], loaded.getDescription().getVersion()}));
        }
        return true;
    }
}

