/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.addons.server;

import com.destroystokyo.paper.block.TargetBlockInfo;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.util.Waitable;
import org.bukkit.scheduler.BukkitTask;
import org.spigotmc.AsyncCatcher;

public final class MCUtil {
    public static final ThreadPoolExecutor asyncExecutor = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Async Task Handler Thread - %1$d").build());
    public static final ThreadPoolExecutor cleanerExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Object Cleaner").build());
    public static final long INVALID_CHUNK_KEY = MCUtil.getCoordinateKey(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final Executor MAIN_EXECUTOR = run -> {
        if (!MCUtil.isMainThread()) {
            MinecraftServer.getServer().execute(run);
        } else {
            run.run();
        }
    };

    public static Runnable once(Runnable run) {
        AtomicBoolean ran = new AtomicBoolean(false);
        return () -> {
            if (ran.compareAndSet(false, true)) {
                run.run();
            }
        };
    }

    public static <T> Runnable once(List<T> list, Consumer<T> cb) {
        return MCUtil.once(() -> list.forEach(cb));
    }

    public static int fastFloor(double x) {
        int truncated = (int)x;
        return x < (double)truncated ? truncated - 1 : truncated;
    }

    public static int fastFloor(float x) {
        int truncated = (int)x;
        return (double)x < (double)truncated ? truncated - 1 : truncated;
    }

    public static float normalizeYaw(float f) {
        float f1 = f % 360.0f;
        if (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        if (f1 < -180.0f) {
            f1 += 360.0f;
        }
        return f1;
    }

    public static String stack() {
        return ExceptionUtils.getFullStackTrace((Throwable)new Throwable());
    }

    public static String stack(String str) {
        return ExceptionUtils.getFullStackTrace((Throwable)new Throwable(str));
    }

    public static long getCoordinateKey(BlockPos blockPos) {
        return (long)(blockPos.func_177952_p() >> 4) << 32 | (long)(blockPos.func_177958_n() >> 4) & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(Entity entity) {
        return (long)(MCUtil.fastFloor(entity.func_226281_cx_()) >> 4) << 32 | (long)(MCUtil.fastFloor(entity.func_226277_ct_()) >> 4) & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(ChunkPos pair) {
        return (long)pair.field_77275_b << 32 | (long)pair.field_77276_a & 0xFFFFFFFFL;
    }

    public static long getCoordinateKey(int x, int z) {
        return (long)z << 32 | (long)x & 0xFFFFFFFFL;
    }

    public static int getCoordinateX(long key) {
        return (int)key;
    }

    public static int getCoordinateZ(long key) {
        return (int)(key >>> 32);
    }

    public static int getChunkCoordinate(double coordinate) {
        return MCUtil.fastFloor(coordinate) >> 4;
    }

    public static int getBlockCoordinate(double coordinate) {
        return MCUtil.fastFloor(coordinate);
    }

    public static long getBlockKey(int x, int y, int z) {
        return (long)x & 0x7FFFFFFL | ((long)z & 0x7FFFFFFL) << 27 | (long)y << 54;
    }

    public static long getBlockKey(BlockPos pos) {
        return (long)pos.func_177958_n() & 0x7FFFFFFL | ((long)pos.func_177952_p() & 0x7FFFFFFL) << 27 | (long)pos.func_177956_o() << 54;
    }

    public static long getBlockKey(Entity entity) {
        return MCUtil.getBlockKey(MCUtil.getBlockCoordinate(entity.func_226277_ct_()), MCUtil.getBlockCoordinate(entity.func_226278_cu_()), MCUtil.getBlockCoordinate(entity.func_226281_cx_()));
    }

    public static <T> void mergeSortedSets(Consumer<T> consumer, Comparator<? super T> comparator, SortedSet<T> ... sets) {
        ObjectRBTreeSet all = new ObjectRBTreeSet(comparator);
        for (SortedSet<T> set : sets) {
            if (set == null) continue;
            all.addAll(set);
        }
        all.forEach(consumer);
    }

    private MCUtil() {
    }

    public static <T> CompletableFuture<T> ensureMain(CompletableFuture<T> future) {
        return future.thenApplyAsync(r -> r, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, Consumer<T> consumer) {
        future.thenAcceptAsync((Consumer)consumer, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, BiConsumer<T, Throwable> consumer) {
        future.whenCompleteAsync((BiConsumer)consumer, MAIN_EXECUTOR);
    }

    public static boolean isMainThread() {
        return MinecraftServer.getServer().func_213162_bc();
    }

    public static BukkitTask scheduleTask(int ticks, Runnable runnable) {
        return MCUtil.scheduleTask(ticks, runnable, null);
    }

    public static BukkitTask scheduleTask(int ticks, Runnable runnable, String taskName) {
        return MinecraftServer.getServer().server.getScheduler().scheduleInternalTask(runnable, ticks, taskName);
    }

    public static void processQueue() {
        Runnable runnable;
        Queue<Runnable> processQueue = MCUtil.getProcessQueue();
        while ((runnable = processQueue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                MinecraftServer.field_147145_h.error("Error executing task", (Throwable)e);
            }
        }
    }

    public static <T> T processQueueWhileWaiting(CompletableFuture<T> future) {
        try {
            if (MCUtil.isMainThread()) {
                while (!future.isDone()) {
                    try {
                        return future.get(1L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException ignored) {
                        MCUtil.processQueue();
                    }
                }
            }
            return future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void ensureMain(Runnable run) {
        MCUtil.ensureMain(null, run);
    }

    public static void ensureMain(String reason, Runnable run) {
        if (AsyncCatcher.enabled && Thread.currentThread() != MinecraftServer.getServer().field_175590_aa) {
            if (reason != null) {
                new IllegalStateException("Asynchronous " + reason + "!").printStackTrace();
            }
            MCUtil.getProcessQueue().add(run);
            return;
        }
        run.run();
    }

    private static Queue<Runnable> getProcessQueue() {
        return MinecraftServer.getServer().processQueue;
    }

    public static <T> T ensureMain(Supplier<T> run) {
        return MCUtil.ensureMain(null, run);
    }

    public static <T> T ensureMain(String reason, final Supplier<T> run) {
        if (AsyncCatcher.enabled && Thread.currentThread() != MinecraftServer.getServer().field_175590_aa) {
            if (reason != null) {
                new IllegalStateException("Asynchronous " + reason + "! Blocking thread until it returns ").printStackTrace();
            }
            Waitable wait = new Waitable<T>(){

                @Override
                protected T evaluate() {
                    return run.get();
                }
            };
            MCUtil.getProcessQueue().add(wait);
            try {
                return wait.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        }
        return run.get();
    }

    public static double distance(Entity e1, Entity e2) {
        return Math.sqrt(MCUtil.distanceSq(e1, e2));
    }

    public static double distance(BlockPos e1, BlockPos e2) {
        return Math.sqrt(MCUtil.distanceSq(e1, e2));
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(MCUtil.distanceSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distanceSq(Entity e1, Entity e2) {
        return MCUtil.distanceSq(e1.func_226277_ct_(), e1.func_226278_cu_(), e1.func_226281_cx_(), e2.func_226277_ct_(), e2.func_226278_cu_(), e2.func_226281_cx_());
    }

    public static double distanceSq(BlockPos pos1, BlockPos pos2) {
        return MCUtil.distanceSq(pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
    }

    public static Location toLocation(World world, double x, double y, double z) {
        return new Location(world.getWorld(), x, y, z);
    }

    public static Location toLocation(World world, BlockPos pos) {
        return new Location(world.getWorld(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static Location toLocation(Entity entity) {
        return new Location(entity.func_130014_f_().getWorld(), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    public static Block toBukkitBlock(World world, BlockPos pos) {
        return world.getWorld().getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static BlockPos toBlockPosition(Location loc) {
        return new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static boolean isEdgeOfChunk(BlockPos pos) {
        int modX = pos.func_177958_n() & 0xF;
        int modZ = pos.func_177952_p() & 0xF;
        return modX == 0 || modX == 15 || modZ == 0 || modZ == 15;
    }

    public static void scheduleAsyncTask(Runnable run) {
        asyncExecutor.execute(run);
    }

    @Nonnull
    public static ServerWorld getNMSWorld(@Nonnull org.bukkit.World world) {
        return ((CraftWorld)world).getHandle();
    }

    public static ServerWorld getNMSWorld(@Nonnull org.bukkit.entity.Entity entity) {
        return MCUtil.getNMSWorld(entity.getWorld());
    }

    public static RayTraceContext.FluidMode getNMSFluidCollisionOption(TargetBlockInfo.FluidMode fluidMode) {
        if (fluidMode == TargetBlockInfo.FluidMode.NEVER) {
            return RayTraceContext.FluidMode.NONE;
        }
        if (fluidMode == TargetBlockInfo.FluidMode.SOURCE_ONLY) {
            return RayTraceContext.FluidMode.SOURCE_ONLY;
        }
        if (fluidMode == TargetBlockInfo.FluidMode.ALWAYS) {
            return RayTraceContext.FluidMode.ANY;
        }
        return null;
    }

    public static BlockFace toBukkitBlockFace(Direction enumDirection) {
        switch (enumDirection) {
            case DOWN: {
                return BlockFace.DOWN;
            }
            case UP: {
                return BlockFace.UP;
            }
            case NORTH: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.EAST;
            }
        }
        return null;
    }

    public static int getTicketLevelFor(ChunkStatus status) {
        return 33 + ChunkStatus.func_222599_a((ChunkStatus)status);
    }
}

