/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;

public enum ForgeRenderTypes {
    ITEM_LAYERED_SOLID(() -> ForgeRenderTypes.getItemLayeredSolid(AtlasTexture.field_110575_b)),
    ITEM_LAYERED_CUTOUT(() -> ForgeRenderTypes.getItemLayeredCutout(AtlasTexture.field_110575_b)),
    ITEM_LAYERED_CUTOUT_MIPPED(() -> ForgeRenderTypes.getItemLayeredCutoutMipped(AtlasTexture.field_110575_b)),
    ITEM_LAYERED_TRANSLUCENT(() -> ForgeRenderTypes.getItemLayeredTranslucent(AtlasTexture.field_110575_b)),
    ITEM_UNSORTED_TRANSLUCENT(() -> ForgeRenderTypes.getUnsortedTranslucent(AtlasTexture.field_110575_b)),
    ITEM_UNLIT_TRANSLUCENT(() -> ForgeRenderTypes.getUnlitTranslucent(AtlasTexture.field_110575_b)),
    ITEM_UNSORTED_UNLIT_TRANSLUCENT(() -> ForgeRenderTypes.getUnlitTranslucent(AtlasTexture.field_110575_b, false));

    public static boolean enableTextTextureLinearFiltering;
    private final NonNullSupplier<RenderType> renderTypeSupplier;

    public static RenderType getItemLayeredSolid(ResourceLocation textureLocation) {
        return Internal.layeredItemSolid(textureLocation);
    }

    public static RenderType getItemLayeredCutout(ResourceLocation textureLocation) {
        return Internal.layeredItemCutout(textureLocation);
    }

    public static RenderType getItemLayeredCutoutMipped(ResourceLocation textureLocation) {
        return Internal.layeredItemCutoutMipped(textureLocation);
    }

    public static RenderType getItemLayeredTranslucent(ResourceLocation textureLocation) {
        return Internal.layeredItemTranslucent(textureLocation);
    }

    public static RenderType getUnsortedTranslucent(ResourceLocation textureLocation) {
        return Internal.unsortedTranslucent(textureLocation);
    }

    public static RenderType getUnlitTranslucent(ResourceLocation textureLocation) {
        return ForgeRenderTypes.getUnlitTranslucent(textureLocation, true);
    }

    public static RenderType getUnlitTranslucent(ResourceLocation textureLocation, boolean sortingEnabled) {
        return Internal.unlitTranslucent(textureLocation, sortingEnabled);
    }

    public static RenderType getEntityCutoutMipped(ResourceLocation textureLocation) {
        return Internal.layeredItemCutoutMipped(textureLocation);
    }

    public static RenderType getText(ResourceLocation locationIn) {
        return Internal.getText(locationIn);
    }

    public static RenderType getTextSeeThrough(ResourceLocation locationIn) {
        return Internal.getTextSeeThrough(locationIn);
    }

    private ForgeRenderTypes(NonNullSupplier<RenderType> renderTypeSupplier) {
        this.renderTypeSupplier = NonNullLazy.of(renderTypeSupplier);
    }

    public RenderType get() {
        return this.renderTypeSupplier.get();
    }

    static {
        enableTextTextureLinearFiltering = false;
    }

    private static class CustomizableTextureState
    extends RenderState.TextureState {
        private CustomizableTextureState(ResourceLocation resLoc, Supplier<Boolean> blur, Supplier<Boolean> mipmap) {
            super(resLoc, blur.get().booleanValue(), mipmap.get().booleanValue());
            this.field_228507_Q_ = () -> {
                this.field_228603_R_ = (Boolean)blur.get();
                this.field_228604_S_ = (Boolean)mipmap.get();
                RenderSystem.enableTexture();
                TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
                texturemanager.func_110577_a(resLoc);
                texturemanager.func_229267_b_(resLoc).func_174937_a(this.field_228603_R_, this.field_228604_S_);
            };
        }
    }

    private static class Internal
    extends RenderType {
        private Internal(String name, VertexFormat fmt, int glMode, int size, boolean doCrumbling, boolean depthSorting, Runnable onEnable, Runnable onDisable) {
            super(name, fmt, glMode, size, doCrumbling, depthSorting, onEnable, onDisable);
            throw new IllegalStateException("This class must not be instantiated");
        }

        public static RenderType unsortedTranslucent(ResourceLocation textureLocation) {
            boolean sortingEnabled = false;
            RenderType.State renderState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(textureLocation, false, false)).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
            return Internal.func_228633_a_((String)"forge_entity_unsorted_translucent", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)renderState);
        }

        public static RenderType unlitTranslucent(ResourceLocation textureLocation, boolean sortingEnabled) {
            RenderType.State renderState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(textureLocation, false, false)).func_228726_a_(field_228515_g_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
            return Internal.func_228633_a_((String)"forge_entity_unlit_translucent", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)sortingEnabled, (RenderType.State)renderState);
        }

        public static RenderType layeredItemSolid(ResourceLocation locationIn) {
            RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228726_a_(field_228510_b_).func_228716_a_(field_228532_x_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
            return Internal.func_228633_a_((String)"forge_item_entity_solid", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
        }

        public static RenderType layeredItemCutout(ResourceLocation locationIn) {
            RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228726_a_(field_228510_b_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
            return Internal.func_228633_a_((String)"forge_item_entity_cutout", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
        }

        public static RenderType layeredItemCutoutMipped(ResourceLocation locationIn) {
            RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, true)).func_228726_a_(field_228510_b_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
            return Internal.func_228633_a_((String)"forge_item_entity_cutout_mipped", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
        }

        public static RenderType layeredItemTranslucent(ResourceLocation locationIn) {
            RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true);
            return Internal.func_228633_a_((String)"forge_item_entity_translucent_cull", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)true, (RenderType.State)rendertype$state);
        }

        public static RenderType getText(ResourceLocation locationIn) {
            RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_((RenderState.TextureState)new CustomizableTextureState(locationIn, () -> enableTextTextureLinearFiltering, () -> false)).func_228713_a_(field_228517_i_).func_228726_a_(field_228515_g_).func_228719_a_(field_228528_t_).func_228728_a_(false);
            return Internal.func_228633_a_((String)"forge_text", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)rendertype$state);
        }

        public static RenderType getTextSeeThrough(ResourceLocation locationIn) {
            RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_((RenderState.TextureState)new CustomizableTextureState(locationIn, () -> enableTextTextureLinearFiltering, () -> false)).func_228713_a_(field_228517_i_).func_228726_a_(field_228515_g_).func_228719_a_(field_228528_t_).func_228715_a_(field_228492_B_).func_228727_a_(field_228496_F_).func_228728_a_(false);
            return Internal.func_228633_a_((String)"forge_text_see_through", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)rendertype$state);
        }
    }
}

