/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.obj.LineReader;
import net.minecraftforge.client.model.obj.MaterialLibrary;
import net.minecraftforge.client.model.obj.OBJModel;

public class OBJLoader
implements IModelLoader<OBJModel> {
    public static OBJLoader INSTANCE = new OBJLoader();
    private final Map<OBJModel.ModelSettings, OBJModel> modelCache = Maps.newHashMap();
    private final Map<ResourceLocation, MaterialLibrary> materialCache = Maps.newHashMap();
    private IResourceManager manager = Minecraft.func_71410_x().func_195551_G();

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    @Override
    public OBJModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new RuntimeException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        boolean detectCullableFaces = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"detectCullableFaces", (boolean)true);
        boolean diffuseLighting = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"diffuseLighting", (boolean)false);
        boolean flipV = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"flip-v", (boolean)false);
        boolean ambientToFullbright = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"ambientToFullbright", (boolean)true);
        String materialLibraryOverrideLocation = modelContents.has("materialLibraryOverride") ? JSONUtils.func_151200_h((JsonObject)modelContents, (String)"materialLibraryOverride") : null;
        return this.loadModel(new OBJModel.ModelSettings(new ResourceLocation(modelLocation), detectCullableFaces, diffuseLighting, flipV, ambientToFullbright, materialLibraryOverrideLocation));
    }

    public OBJModel loadModel(OBJModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            try (IResource resource = this.manager.func_199002_a(settings.modelLocation);){
                OBJModel oBJModel;
                try (LineReader rdr = new LineReader(resource);){
                    oBJModel = new OBJModel(rdr, settings);
                }
                return oBJModel;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not find OBJ model", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ model", e);
            }
        });
    }

    public MaterialLibrary loadMaterialLibrary(ResourceLocation materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            try (IResource resource = this.manager.func_199002_a(location);){
                MaterialLibrary materialLibrary;
                try (LineReader rdr = new LineReader(resource);){
                    materialLibrary = new MaterialLibrary(rdr);
                }
                return materialLibrary;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not find OBJ material library", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ material library", e);
            }
        });
    }
}

