/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.mohistmc.util.i18n.i18n;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class VersionChecker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);
    private static Map<IModInfo, CheckResult> results = new ConcurrentHashMap<IModInfo, CheckResult>();
    private static final CheckResult PENDING_CHECK = new CheckResult(Status.PENDING, null, null, null);

    public static void startVersionCheck() {
        new Thread("Forge Version Check"){

            @Override
            public void run() {
                if (!FMLConfig.runVersionCheck()) {
                    LOGGER.info(i18n.get((String)"versionchecker.1"));
                    return;
                }
                VersionChecker.gatherMods().forEach(this::process);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private InputStream openUrlStream(URL url) throws IOException {
                URL currentUrl = url;
                for (int redirects = 0; redirects < MAX_HTTP_REDIRECTS; ++redirects) {
                    URLConnection c = currentUrl.openConnection();
                    if (c instanceof HttpURLConnection) {
                        HttpURLConnection huc = (HttpURLConnection)c;
                        huc.setInstanceFollowRedirects(false);
                        int responseCode = huc.getResponseCode();
                        if (responseCode >= 300 && responseCode <= 399) {
                            try {
                                String loc = huc.getHeaderField("Location");
                                currentUrl = new URL(currentUrl, loc);
                                continue;
                            }
                            finally {
                                huc.disconnect();
                            }
                        }
                    }
                    return c.getInputStream();
                }
                throw new IOException("Too many redirects while trying to fetch " + url);
            }

            private void process(IModInfo mod) {
                Status status = Status.PENDING;
                ComparableVersion target = null;
                LinkedHashMap<ComparableVersion, String> changes = null;
                String display_url = null;
                try {
                    URL url = mod.getUpdateURL();
                    LOGGER.info(i18n.get((String)"versionchecker.2", (Object[])new Object[]{mod.getModId(), url.toString()}));
                    InputStream con = this.openUrlStream(url);
                    String data = new String(ByteStreams.toByteArray((InputStream)con), StandardCharsets.UTF_8);
                    con.close();
                    LOGGER.debug(i18n.get((String)"versionchecker.3", (Object[])new Object[]{mod.getModId(), data}));
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    display_url = (String)json.get("homepage");
                    String mcVersion = MCPVersion.getMCVersion();
                    String rec = (String)promos.get(mcVersion + "-recommended");
                    String lat = (String)promos.get(mcVersion + "-latest");
                    ComparableVersion current = new ComparableVersion(mod.getVersion().toString());
                    if (rec != null) {
                        ComparableVersion recommended = new ComparableVersion(rec);
                        int diff = recommended.compareTo(current);
                        if (diff == 0) {
                            status = Status.UP_TO_DATE;
                        } else if (diff < 0) {
                            ComparableVersion latest;
                            status = Status.AHEAD;
                            if (lat != null && current.compareTo(latest = new ComparableVersion(lat)) < 0) {
                                status = Status.OUTDATED;
                                target = latest;
                            }
                        } else {
                            status = Status.OUTDATED;
                            target = recommended;
                        }
                    } else if (lat != null) {
                        ComparableVersion latest = new ComparableVersion(lat);
                        status = current.compareTo(latest) < 0 ? Status.BETA_OUTDATED : Status.BETA;
                        target = latest;
                    } else {
                        status = Status.BETA;
                    }
                    LOGGER.info(i18n.get((String)"versionchecker.4", (Object[])new Object[]{mod.getModId(), status, current, target}));
                    changes = new LinkedHashMap<ComparableVersion, String>();
                    Map tmp = (Map)json.get(mcVersion);
                    if (tmp != null) {
                        ArrayList<ComparableVersion> ordered = new ArrayList<ComparableVersion>();
                        for (String key : tmp.keySet()) {
                            ComparableVersion ver = new ComparableVersion(key);
                            if (ver.compareTo(current) <= 0 || target != null && ver.compareTo(target) >= 1) continue;
                            ordered.add(ver);
                        }
                        Collections.sort(ordered);
                        for (ComparableVersion ver : ordered) {
                            changes.put(ver, (String)tmp.get(ver.toString()));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn(i18n.get((String)"versionchecker.5"), (Throwable)e);
                    status = Status.FAILED;
                }
                results.put(mod, new CheckResult(status, target, changes, display_url));
            }
        }.start();
    }

    private static List<IModInfo> gatherMods() {
        LinkedList<IModInfo> ret = new LinkedList<IModInfo>();
        for (ModInfo info : ModList.get().getMods()) {
            URL url = info.getUpdateURL();
            if (url == null) continue;
            ret.add((IModInfo)info);
        }
        return ret;
    }

    public static CheckResult getResult(IModInfo mod) {
        return results.getOrDefault(mod, PENDING_CHECK);
    }

    public static class CheckResult {
        @Nonnull
        public final Status status;
        @Nullable
        public final ComparableVersion target;
        @Nullable
        public final Map<ComparableVersion, String> changes;
        @Nullable
        public final String url;

        private CheckResult(@Nonnull Status status, @Nullable ComparableVersion target, @Nullable Map<ComparableVersion, String> changes, @Nullable String url) {
            this.status = status;
            this.target = target;
            this.changes = changes == null ? Collections.emptyMap() : Collections.unmodifiableMap(changes);
            this.url = url;
        }
    }

    public static enum Status {
        PENDING,
        FAILED,
        UP_TO_DATE,
        OUTDATED(3, true),
        AHEAD,
        BETA,
        BETA_OUTDATED(6, true);

        final int sheetOffset;
        final boolean draw;
        final boolean animated;

        private Status() {
            this(0, false, false);
        }

        private Status(int sheetOffset) {
            this(sheetOffset, true, false);
        }

        private Status(int sheetOffset, boolean animated) {
            this(sheetOffset, true, animated);
        }

        private Status(int sheetOffset, boolean draw, boolean animated) {
            this.sheetOffset = sheetOffset;
            this.draw = draw;
            this.animated = animated;
        }

        public int getSheetOffset() {
            return this.sheetOffset;
        }

        public boolean shouldDraw() {
            return this.draw;
        }

        public boolean isAnimated() {
            return this.animated;
        }
    }
}

