/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.ExtendedServerListData;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ClientHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CLIENTHOOKS = MarkerManager.getMarker((String)"CLIENTHOOKS");
    private static final ResourceLocation iconSheet = new ResourceLocation("forge", "textures/gui/icons.png");
    private static SetMultimap<String, ResourceLocation> missingTextures = HashMultimap.create();
    private static Set<String> badTextureDomains = Sets.newHashSet();
    private static Table<String, String, Set<ResourceLocation>> brokenTextures = HashBasedTable.create();

    @Nullable
    public static void processForgeListPingData(ServerStatusResponse packet, ServerData target) {
        if (packet.getForgeData() != null) {
            Map<String, String> mods = packet.getForgeData().getRemoteModData();
            Map<ResourceLocation, Pair<String, Boolean>> remoteChannels = packet.getForgeData().getRemoteChannels();
            int fmlver = packet.getForgeData().getFMLNetworkVersion();
            boolean fmlNetMatches = fmlver == 2;
            boolean channelsMatch = NetworkRegistry.checkListPingCompatibilityForClient(remoteChannels);
            AtomicBoolean result = new AtomicBoolean(true);
            ArrayList extraClientMods = new ArrayList();
            ModList.get().forEachModContainer((modid, mc) -> mc.getCustomExtension(ExtensionPoint.DISPLAYTEST).ifPresent(ext -> {
                boolean foundModOnServer = ((BiPredicate)ext.getRight()).test((String)mods.get(modid), true);
                result.compareAndSet(true, foundModOnServer);
                if (!foundModOnServer) {
                    extraClientMods.add(modid);
                }
            }));
            boolean modsMatch = result.get();
            Map<String, String> extraServerMods = mods.entrySet().stream().filter(e -> !Objects.equals("OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", e.getValue())).filter(e -> !ModList.get().isLoaded((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            LOGGER.debug(CLIENTHOOKS, "Received FML ping data from server at {}: FMLNETVER={}, mod list is compatible : {}, channel list is compatible: {}, extra server mods: {}", (Object)target.field_78845_b, (Object)fmlver, (Object)modsMatch, (Object)channelsMatch, extraServerMods);
            String extraReason = null;
            if (!extraServerMods.isEmpty()) {
                extraReason = "fml.menu.multiplayer.extraservermods";
                LOGGER.info(CLIENTHOOKS, ForgeI18n.parseMessage(extraReason, new Object[0]) + ": {}", (Object)extraServerMods.entrySet().stream().map(e -> (String)e.getKey() + "@" + (String)e.getValue()).collect(Collectors.joining(", ")));
            }
            if (!modsMatch) {
                extraReason = "fml.menu.multiplayer.modsincompatible";
                LOGGER.info(CLIENTHOOKS, "Client has mods that are missing on server: {}", extraClientMods);
            }
            if (!channelsMatch) {
                extraReason = "fml.menu.multiplayer.networkincompatible";
            }
            if (fmlver < 2) {
                extraReason = "fml.menu.multiplayer.serveroutdated";
            }
            if (fmlver > 2) {
                extraReason = "fml.menu.multiplayer.clientoutdated";
            }
            target.forgeData = new ExtendedServerListData("FML", extraServerMods.isEmpty() && fmlNetMatches && channelsMatch && modsMatch, mods.size(), extraReason, packet.getForgeData().isTruncated());
        } else {
            target.forgeData = new ExtendedServerListData("VANILLA", NetworkRegistry.canConnectToVanillaServer(), 0, null);
        }
    }

    public static void drawForgePingInfo(MultiplayerScreen gui, ServerData target, MatrixStack mStack, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        String tooltip;
        int idx;
        if (target.forgeData == null) {
            return;
        }
        switch (target.forgeData.type) {
            case "FML": {
                if (target.forgeData.isCompatible) {
                    idx = 0;
                    tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.compatible", target.forgeData.numberOfMods);
                } else {
                    idx = 16;
                    if (target.forgeData.extraReason != null) {
                        String extraReason = ForgeI18n.parseMessage(target.forgeData.extraReason, new Object[0]);
                        tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.incompatible.extra", extraReason);
                    } else {
                        tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.incompatible", new Object[0]);
                    }
                }
                if (!target.forgeData.truncated) break;
                tooltip = tooltip + "\n" + ForgeI18n.parseMessage("fml.menu.multiplayer.truncated", new Object[0]);
                break;
            }
            case "VANILLA": {
                if (target.forgeData.isCompatible) {
                    idx = 48;
                    tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.vanilla", new Object[0]);
                    break;
                }
                idx = 80;
                tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.vanilla.incompatible", new Object[0]);
                break;
            }
            default: {
                idx = 64;
                tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.unknown", target.forgeData.type);
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(iconSheet);
        AbstractGui.func_238466_a_((MatrixStack)mStack, (int)(x + width - 18), (int)(y + 10), (int)16, (int)16, (float)0.0f, (float)idx, (int)16, (int)16, (int)256, (int)256);
        if (relativeMouseX > width - 15 && relativeMouseX < width && relativeMouseY > 10 && relativeMouseY < 26) {
            gui.func_238854_b_(Arrays.stream(tooltip.split("\n")).map(StringTextComponent::new).collect(Collectors.toList()));
        }
    }

    public static String fixDescription(String description) {
        return description.endsWith(":NOFML\ufffd\ufffdr") ? description.substring(0, description.length() - 8) + "\ufffd\ufffdr" : description;
    }

    static File getSavesDir() {
        return new File(Minecraft.func_71410_x().field_71412_D, "saves");
    }

    private static NetworkManager getClientToServerNetworkManager() {
        return Minecraft.func_71410_x().func_147114_u() != null ? Minecraft.func_71410_x().func_147114_u().func_147298_b() : null;
    }

    public static void handleClientWorldClosing(ClientWorld world) {
        NetworkManager client = ClientHooks.getClientToServerNetworkManager();
        if (client != null && !client.func_150731_c()) {
            GameData.revertToFrozen();
        }
    }

    public static void trackMissingTexture(ResourceLocation resourceLocation) {
        badTextureDomains.add(resourceLocation.func_110624_b());
        missingTextures.put((Object)resourceLocation.func_110624_b(), (Object)resourceLocation);
    }

    public static void trackBrokenTexture(ResourceLocation resourceLocation, String error) {
        badTextureDomains.add(resourceLocation.func_110624_b());
        Set badType = (Set)brokenTextures.get((Object)resourceLocation.func_110624_b(), (Object)error);
        if (badType == null) {
            badType = Sets.newHashSet();
            brokenTextures.put((Object)resourceLocation.func_110624_b(), (Object)((String)MoreObjects.firstNonNull((Object)error, (Object)"Unknown error")), (Object)badType);
        }
        badType.add(resourceLocation);
    }

    public static void logMissingTextureErrors() {
        if (missingTextures.isEmpty() && brokenTextures.isEmpty()) {
            return;
        }
        Logger logger = LogManager.getLogger((String)"FML.TEXTURE_ERRORS");
        logger.error(Strings.repeat((String)"+=", (int)25));
        logger.error("The following texture errors were found.");
        Map resManagers = (Map)ObfuscationReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G(), "field_199014_c");
        for (String resourceDomain : badTextureDomains) {
            Set missing = missingTextures.get((Object)resourceDomain);
            logger.error(Strings.repeat((String)"=", (int)50));
            logger.error("  DOMAIN {}", (Object)resourceDomain);
            logger.error(Strings.repeat((String)"-", (int)50));
            logger.error("  domain {} is missing {} texture{}", (Object)resourceDomain, (Object)missing.size(), (Object)(missing.size() != 1 ? "s" : ""));
            FallbackResourceManager fallbackResourceManager = (FallbackResourceManager)resManagers.get(resourceDomain);
            if (fallbackResourceManager == null) {
                logger.error("    domain {} is missing a resource manager - it is probably a side-effect of automatic texture processing", (Object)resourceDomain);
            } else {
                List resPacks = fallbackResourceManager.field_199023_a;
                logger.error("    domain {} has {} location{}:", (Object)resourceDomain, (Object)resPacks.size(), (Object)(resPacks.size() != 1 ? "s" : ""));
                Iterator<Object> iterator = resPacks.iterator();
                while (iterator.hasNext()) {
                    IResourcePack resPack = (IResourcePack)iterator.next();
                    if (resPack instanceof ModFileResourcePack) {
                        ModFileResourcePack modRP = (ModFileResourcePack)resPack;
                        List mods = modRP.getModFile().getModInfos();
                        logger.error("      mod(s) {} resources at {}", mods.stream().map(IModInfo::getDisplayName).collect(Collectors.toList()), (Object)modRP.getModFile().getFilePath());
                        continue;
                    }
                    if (resPack instanceof ResourcePack) {
                        logger.error("      resource pack at path {}", (Object)((ResourcePack)resPack).field_195771_a.getPath());
                        continue;
                    }
                    logger.error("      unknown resourcepack type {} : {}", (Object)resPack.getClass().getName(), (Object)resPack.func_195762_a());
                }
            }
            logger.error(Strings.repeat((String)"-", (int)25));
            if (missingTextures.containsKey((Object)resourceDomain)) {
                logger.error("    The missing resources for domain {} are:", (Object)resourceDomain);
                for (ResourceLocation rl : missing) {
                    logger.error("      {}", (Object)rl.func_110623_a());
                }
                logger.error(Strings.repeat((String)"-", (int)25));
            }
            if (!brokenTextures.containsRow((Object)resourceDomain)) {
                logger.error("    No other errors exist for domain {}", (Object)resourceDomain);
            } else {
                logger.error("    The following other errors were reported for domain {}:", (Object)resourceDomain);
                Map resourceErrs = brokenTextures.row((Object)resourceDomain);
                for (String error : resourceErrs.keySet()) {
                    logger.error(Strings.repeat((String)"-", (int)25));
                    logger.error("    Problem: {}", (Object)error);
                    for (ResourceLocation rl : (Set)resourceErrs.get(error)) {
                        logger.error("      {}", (Object)rl.func_110623_a());
                    }
                }
            }
            logger.error(Strings.repeat((String)"=", (int)50));
        }
        logger.error(Strings.repeat((String)"+=", (int)25));
    }

    public static void firePlayerLogin(PlayerController pc, ClientPlayerEntity player, NetworkManager networkManager) {
        MinecraftForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.LoggedInEvent(pc, player, networkManager));
    }

    public static void firePlayerLogout(PlayerController pc, ClientPlayerEntity player) {
        MinecraftForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.LoggedOutEvent(pc, player, player != null ? (player.field_71174_a != null ? player.field_71174_a.func_147298_b() : null) : null));
    }

    public static void firePlayerRespawn(PlayerController pc, ClientPlayerEntity oldPlayer, ClientPlayerEntity newPlayer, NetworkManager networkManager) {
        MinecraftForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.RespawnEvent(pc, oldPlayer, newPlayer, networkManager));
    }
}

