/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.util.TablePrinter;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.loading.AdvancedLogMessageAdapter;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryDelegate;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ForgeRegistry<V extends IForgeRegistryEntry<V>>
implements IForgeRegistryInternal<V>,
IForgeRegistryModifiable<V> {
    public static Marker REGISTRIES = MarkerManager.getMarker((String)"REGISTRIES");
    private static Marker REGISTRYDUMP = MarkerManager.getMarker((String)"REGISTRYDUMP");
    private static Logger LOGGER = LogManager.getLogger();
    private final RegistryManager stage;
    private final BiMap<Integer, V> ids = HashBiMap.create();
    private final BiMap<ResourceLocation, V> names = HashBiMap.create();
    private final BiMap<RegistryKey<V>, V> keys = HashBiMap.create();
    private final Class<V> superType;
    private final Map<ResourceLocation, ResourceLocation> aliases = Maps.newHashMap();
    final Map<ResourceLocation, ?> slaves = Maps.newHashMap();
    private final ResourceLocation defaultKey;
    private final IForgeRegistry.CreateCallback<V> create;
    private final IForgeRegistry.AddCallback<V> add;
    private final IForgeRegistry.ClearCallback<V> clear;
    private final IForgeRegistry.ValidateCallback<V> validate;
    private final IForgeRegistry.BakeCallback<V> bake;
    private final IForgeRegistry.MissingFactory<V> missing;
    private final BitSet availabilityMap;
    private final Set<ResourceLocation> dummies = Sets.newHashSet();
    private final Set<Integer> blocked = Sets.newHashSet();
    private final Multimap<ResourceLocation, V> overrides = ArrayListMultimap.create();
    private final BiMap<OverrideOwner, V> owners = HashBiMap.create();
    private final IForgeRegistry.DummyFactory<V> dummyFactory;
    private final boolean isDelegated;
    private final int min;
    private final int max;
    private final boolean allowOverrides;
    private final boolean isModifiable;
    @Nullable
    private final String tagFolder;
    private V defaultValue = null;
    boolean isFrozen = false;
    private final ResourceLocation name;
    private final RegistryKey<Registry<V>> key;
    private final RegistryBuilder<V> builder;

    ForgeRegistry(RegistryManager stage, ResourceLocation name, RegistryBuilder<V> builder) {
        this.name = name;
        this.key = RegistryKey.func_240904_a_((ResourceLocation)name);
        this.builder = builder;
        this.stage = stage;
        this.superType = builder.getType();
        this.defaultKey = builder.getDefault();
        this.min = builder.getMinId();
        this.max = builder.getMaxId();
        this.availabilityMap = new BitSet(Math.min(this.max + 1, 4095));
        this.create = builder.getCreate();
        this.add = builder.getAdd();
        this.clear = builder.getClear();
        this.validate = builder.getValidate();
        this.bake = builder.getBake();
        this.missing = builder.getMissingFactory();
        this.dummyFactory = builder.getDummyFactory();
        this.isDelegated = ForgeRegistryEntry.class.isAssignableFrom(this.superType);
        this.allowOverrides = builder.getAllowOverrides();
        this.isModifiable = builder.getAllowModifications();
        this.tagFolder = builder.getTagFolder();
        if (this.create != null) {
            this.create.onCreate(this, stage);
        }
    }

    @Override
    public void register(V value) {
        this.add(-1, value);
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            int cur = -1;
            V next = null;
            {
                this.next();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public V next() {
                Object ret = this.next;
                do {
                    this.cur = ForgeRegistry.this.availabilityMap.nextSetBit(this.cur + 1);
                    this.next = (IForgeRegistryEntry)ForgeRegistry.this.ids.get((Object)this.cur);
                } while (this.next == null && this.cur != -1);
                return ret;
            }
        };
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public RegistryKey<Registry<V>> getRegistryKey() {
        return this.key;
    }

    @Override
    public Class<V> getRegistrySuperType() {
        return this.superType;
    }

    @Nullable
    public String getTagFolder() {
        return this.tagFolder;
    }

    @Override
    public void registerAll(V ... values) {
        for (V value : values) {
            this.register(value);
        }
    }

    @Override
    public boolean containsKey(ResourceLocation key) {
        while (key != null) {
            if (this.names.containsKey((Object)key)) {
                return true;
            }
            key = this.aliases.get(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(V value) {
        return this.names.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    @Override
    public V getValue(ResourceLocation key) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)this.names.get((Object)key);
        key = this.aliases.get(key);
        while (ret == null && key != null) {
            ret = (IForgeRegistryEntry)this.names.get((Object)key);
            key = this.aliases.get(key);
        }
        return (V)(ret == null ? this.defaultValue : ret);
    }

    @Override
    public ResourceLocation getKey(V value) {
        ResourceLocation ret = (ResourceLocation)this.names.inverse().get(value);
        return ret == null ? this.defaultKey : ret;
    }

    @Override
    public Set<ResourceLocation> getKeys() {
        return Collections.unmodifiableSet(this.names.keySet());
    }

    @Override
    @Nonnull
    public Collection<V> getValues() {
        return Collections.unmodifiableSet(this.names.values());
    }

    @Override
    public Set<Map.Entry<RegistryKey<V>, V>> getEntries() {
        return Collections.unmodifiableSet(this.keys.entrySet());
    }

    @Override
    public <T> T getSlaveMap(ResourceLocation name, Class<T> type) {
        return (T)this.slaves.get(name);
    }

    @Override
    public void setSlaveMap(ResourceLocation name, Object obj) {
        this.slaves.put(name, obj);
    }

    public int getID(V value) {
        Integer ret = (Integer)this.ids.inverse().get(value);
        if (ret == null && this.defaultValue != null) {
            ret = (Integer)this.ids.inverse().get(this.defaultValue);
        }
        return ret == null ? -1 : ret;
    }

    public int getID(ResourceLocation name) {
        return this.getID((IForgeRegistryEntry)this.names.get((Object)name));
    }

    private int getIDRaw(V value) {
        Integer ret = (Integer)this.ids.inverse().get(value);
        return ret == null ? -1 : ret;
    }

    private int getIDRaw(ResourceLocation name) {
        return this.getIDRaw((IForgeRegistryEntry)this.names.get((Object)name));
    }

    public V getValue(int id) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)this.ids.get((Object)id);
        return (V)(ret == null ? this.defaultValue : ret);
    }

    @Nullable
    public RegistryKey<V> getKey(int id) {
        V value = this.getValue(id);
        return (RegistryKey)this.keys.inverse().get(value);
    }

    void validateKey() {
        if (this.defaultKey != null) {
            Validate.notNull(this.defaultValue, (String)("Missing default of ForgeRegistry: " + this.defaultKey + " Type: " + this.superType), (Object[])new Object[0]);
        }
    }

    @Override
    @Nullable
    public ResourceLocation getDefaultKey() {
        return this.defaultKey;
    }

    ForgeRegistry<V> copy(RegistryManager stage) {
        return new ForgeRegistry<V>(stage, this.name, this.builder);
    }

    int add(int id, V value) {
        String owner = ModLoadingContext.get().getActiveNamespace();
        return this.add(id, value, owner);
    }

    int add(int id, V value, String owner) {
        Integer foundId;
        ResourceLocation key = value == null ? null : value.getRegistryName();
        Preconditions.checkNotNull((Object)key, (String)"Can't use a null-name for the registry, object %s.", value);
        Preconditions.checkNotNull(value, (String)"Can't add null-object to the registry, name %s.", (Object)key);
        int idToUse = id;
        if (idToUse < 0 || this.availabilityMap.get(idToUse)) {
            idToUse = this.availabilityMap.nextClearBit(this.min);
        }
        if (idToUse > this.max) {
            throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", idToUse));
        }
        V oldEntry = this.getRaw(key);
        if (oldEntry == value) {
            LOGGER.warn(REGISTRIES, "Registry {}: The object {} has been registered twice for the same name {}.", (Object)this.name, value, (Object)key);
            return this.getID(value);
        }
        if (oldEntry != null) {
            if (!this.allowOverrides) {
                throw new IllegalArgumentException(String.format("The name %s has been registered twice, for %s and %s.", key, this.getRaw(key), value));
            }
            if (owner == null) {
                throw new IllegalStateException(String.format("Could not determine owner for the override on %s. Value: %s", key, value));
            }
            LOGGER.debug(REGISTRIES, "Registry {} Override: {} {} -> {}", (Object)this.name, (Object)key, oldEntry, value);
            idToUse = this.getID(oldEntry);
        }
        if ((foundId = (Integer)this.ids.inverse().get(value)) != null) {
            IForgeRegistryEntry otherThing = (IForgeRegistryEntry)this.ids.get((Object)foundId);
            throw new IllegalArgumentException(String.format("The object %s{%x} has been registered twice, using the names %s and %s. (Other object at this id is %s{%x})", value, System.identityHashCode(value), this.getKey(value), key, otherThing, System.identityHashCode(otherThing)));
        }
        if (this.isLocked()) {
            throw new IllegalStateException(String.format("The object %s (name %s) is being added too late.", value, key));
        }
        if (this.defaultKey != null && this.defaultKey.equals((Object)key)) {
            if (this.defaultValue != null) {
                throw new IllegalStateException(String.format("Attemped to override already set default value. This is not allowed: The object %s (name %s)", value, key));
            }
            this.defaultValue = value;
        }
        this.names.put((Object)key, value);
        this.keys.put((Object)RegistryKey.func_240903_a_(this.key, (ResourceLocation)key), value);
        this.ids.put((Object)idToUse, value);
        this.availabilityMap.set(idToUse);
        this.owners.put((Object)new OverrideOwner(owner == null ? key.func_110623_a() : owner, key), value);
        if (this.isDelegated) {
            this.getDelegate(value).setName(key);
            if (oldEntry != null) {
                if (!this.overrides.get((Object)key).contains(oldEntry)) {
                    this.overrides.put((Object)key, oldEntry);
                }
                this.overrides.get((Object)key).remove(value);
                if (this.stage == RegistryManager.ACTIVE) {
                    this.getDelegate(oldEntry).changeReference(value);
                }
            }
        }
        if (this.add != null) {
            this.add.onAdd(this, this.stage, idToUse, value, oldEntry);
        }
        if (this.dummies.remove(key)) {
            LOGGER.debug(REGISTRIES, "Registry {} Dummy Remove: {}", (Object)this.name, (Object)key);
        }
        LOGGER.trace(REGISTRIES, "Registry {} add: {} {} {} (req. id {})", (Object)this.name, (Object)key, (Object)idToUse, value, (Object)id);
        return idToUse;
    }

    public V getRaw(ResourceLocation key) {
        IForgeRegistryEntry ret = (IForgeRegistryEntry)this.names.get((Object)key);
        key = this.aliases.get(key);
        while (ret == null && key != null) {
            ret = (IForgeRegistryEntry)this.names.get((Object)key);
            key = this.aliases.get(key);
        }
        return (V)ret;
    }

    void addAlias(ResourceLocation from, ResourceLocation to) {
        if (this.isLocked()) {
            throw new IllegalStateException(String.format("Attempted to register the alias %s -> %s to late", from, to));
        }
        if (from.equals((Object)to)) {
            LOGGER.warn(REGISTRIES, "Registry {} Ignoring invalid alias: {} -> {}", (Object)this.name, (Object)from, (Object)to);
            return;
        }
        this.aliases.put(from, to);
        LOGGER.trace(REGISTRIES, "Registry {} alias: {} -> {}", (Object)this.name, (Object)from, (Object)to);
    }

    void addDummy(ResourceLocation key) {
        if (this.isLocked()) {
            throw new IllegalStateException(String.format("Attempted to register the dummy %s to late", key));
        }
        this.dummies.add(key);
        LOGGER.trace(REGISTRIES, "Registry {} dummy: {}", (Object)this.name, (Object)key);
    }

    private RegistryDelegate<V> getDelegate(V thing) {
        if (this.isDelegated) {
            return (RegistryDelegate)((ForgeRegistryEntry)thing).delegate;
        }
        throw new IllegalStateException("Tried to get existing delegate from registry that is not delegated.");
    }

    void resetDelegates() {
        if (!this.isDelegated) {
            return;
        }
        for (IForgeRegistryEntry value : this) {
            this.getDelegate(value).changeReference(value);
        }
        for (IForgeRegistryEntry value : this.overrides.values()) {
            this.getDelegate(value).changeReference(value);
        }
    }

    V getDefault() {
        return this.defaultValue;
    }

    boolean isDummied(ResourceLocation key) {
        return this.dummies.contains(key);
    }

    void validateContent(ResourceLocation registryName) {
        try {
            ObfuscationReflectionHelper.findMethod(BitSet.class, "trimToSize", new Class[0]).invoke((Object)this.availabilityMap, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (IForgeRegistryEntry obj : this) {
            int id = this.getID(obj);
            ResourceLocation name = this.getKey(obj);
            if (name == null) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, doesn't yield a name.", registryName, obj, id));
            }
            if (id > this.max) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s uses the too large id %d.", registryName, obj, name, id));
            }
            if (this.getValue(id) != obj) {
                throw new IllegalStateException(String.format("Registry entry for id %d, name %s, doesn't yield the expected %s %s.", id, name, registryName, obj));
            }
            if (this.getValue(name) != obj) {
                throw new IllegalStateException(String.format("Registry entry for name %s, id %d, doesn't yield the expected %s %s.", name, id, registryName, obj));
            }
            if (this.getID(name) != id) {
                throw new IllegalStateException(String.format("Registry entry for name %s doesn't yield the expected id %d.", name, id));
            }
            if (this.validate == null) continue;
            this.validate.onValidate(this, this.stage, id, name, obj);
        }
    }

    public void bake() {
        if (this.bake != null) {
            this.bake.onBake(this, this.stage);
        }
    }

    void sync(ResourceLocation name, ForgeRegistry<V> from) {
        LOGGER.debug(REGISTRIES, "Registry {} Sync: {} -> {}", (Object)this.name, (Object)this.stage.getName(), (Object)from.stage.getName());
        if (this == from) {
            throw new IllegalArgumentException("WTF We are the same!?!?!");
        }
        if (from.superType != this.superType) {
            throw new IllegalArgumentException("Attempted to copy to incompatible registry: " + name + " " + from.superType + " -> " + this.superType);
        }
        this.isFrozen = false;
        if (this.clear != null) {
            this.clear.onClear(this, this.stage);
        }
        this.aliases.clear();
        from.aliases.forEach(this::addAlias);
        this.ids.clear();
        this.names.clear();
        this.keys.clear();
        this.availabilityMap.clear(0, this.availabilityMap.length());
        this.defaultValue = null;
        this.overrides.clear();
        this.owners.clear();
        boolean errored = false;
        for (Map.Entry entry : from.names.entrySet()) {
            ArrayList overrides = Lists.newArrayList((Iterable)from.overrides.get((Object)((ResourceLocation)entry.getKey())));
            int id = from.getID((ResourceLocation)entry.getKey());
            if (overrides.isEmpty()) {
                int realId = this.add(id, (IForgeRegistryEntry)entry.getValue());
                if (id == realId || id == -1) continue;
                LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, entry.getKey(), (Object)id, (Object)realId);
                errored = true;
                continue;
            }
            overrides.add((IForgeRegistryEntry)entry.getValue());
            for (IForgeRegistryEntry value : overrides) {
                OverrideOwner owner = (OverrideOwner)from.owners.inverse().get((Object)value);
                if (owner == null) {
                    LOGGER.warn(REGISTRIES, "Registry {}: Override did not have an associated owner object. Name: {} Value: {}", (Object)this.name, entry.getKey(), (Object)value);
                    errored = true;
                    continue;
                }
                int realId = this.add(id, value, owner.owner);
                if (id == realId || id == -1) continue;
                LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, entry.getKey(), (Object)id, (Object)realId);
                errored = true;
            }
        }
        this.dummies.clear();
        from.dummies.forEach(this::addDummy);
        if (errored) {
            throw new RuntimeException("One of more entry values did not copy to the correct id. Check log for details!");
        }
    }

    @Override
    public void clear() {
        if (!this.isModifiable) {
            throw new UnsupportedOperationException("Attempted to clear a non-modifiable Forge Registry");
        }
        if (this.isLocked()) {
            throw new IllegalStateException("Attempted to clear the registry to late.");
        }
        if (this.clear != null) {
            this.clear.onClear(this, this.stage);
        }
        this.aliases.clear();
        this.dummies.clear();
        this.ids.clear();
        this.names.clear();
        this.keys.clear();
        this.availabilityMap.clear(0, this.availabilityMap.length());
    }

    @Override
    public V remove(ResourceLocation key) {
        if (!this.isModifiable) {
            throw new UnsupportedOperationException("Attempted to remove from a non-modifiable Forge Registry");
        }
        if (this.isLocked()) {
            throw new IllegalStateException("Attempted to remove from the registry to late.");
        }
        IForgeRegistryEntry value = (IForgeRegistryEntry)this.names.remove((Object)key);
        if (value != null) {
            RegistryKey rkey = (RegistryKey)this.keys.inverse().remove((Object)value);
            if (rkey == null) {
                throw new IllegalStateException("Removed a entry that did not have an associated RegistryKey: " + key + " " + value.toString() + " This should never happen unless hackery!");
            }
            Integer id = (Integer)this.ids.inverse().remove((Object)value);
            if (id == null) {
                throw new IllegalStateException("Removed a entry that did not have an associated id: " + key + " " + value.toString() + " This should never happen unless hackery!");
            }
            LOGGER.trace(REGISTRIES, "Registry {} remove: {} {}", (Object)this.name, (Object)key, (Object)id);
        }
        return (V)value;
    }

    void block(int id) {
        this.blocked.add(id);
        this.availabilityMap.set(id);
    }

    @Override
    public boolean isLocked() {
        return this.isFrozen;
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public void unfreeze() {
        this.isFrozen = false;
    }

    RegistryEvent.Register<V> getRegisterEvent(ResourceLocation name) {
        return new RegistryEvent.Register(name, this);
    }

    void dump(ResourceLocation name) {
        if (LOGGER.isDebugEnabled(REGISTRYDUMP)) {
            TablePrinter<DumpRow> tab = new TablePrinter<DumpRow>().header("ID", r -> r.id).header("Dummy", r -> r.dummied).header("Key", r -> r.key).header("Value", r -> r.value);
            LOGGER.debug(REGISTRYDUMP, () -> new AdvancedLogMessageAdapter(sb -> {
                sb.append("Registry Name: ").append(name).append('\n');
                tab.clearRows();
                this.getKeys().stream().map(this::getID).sorted().map(id -> {
                    V val = this.getValue((int)id);
                    ResourceLocation key = this.getKey(val);
                    return new DumpRow(Integer.toString(id), this.getKey(val).toString(), val.toString(), Boolean.toString(this.dummies.contains(key)));
                }).forEach(tab::add);
                tab.build((StringBuilder)sb);
            }));
        }
    }

    public void loadIds(Map<ResourceLocation, Integer> ids, Map<ResourceLocation, String> overrides, Map<ResourceLocation, Integer> missing, Map<ResourceLocation, Integer[]> remapped, ForgeRegistry<V> old, ResourceLocation name) {
        ResourceLocation itemName;
        HashMap ovs = Maps.newHashMap(overrides);
        for (Map.Entry<ResourceLocation, Integer> entry : ids.entrySet()) {
            Object obj;
            itemName = entry.getKey();
            if (old.isDummied(itemName)) {
                LOGGER.info(REGISTRIES, "Registry {}: Skipping injection of dummied object {}", (Object)this.name, (Object)itemName);
                continue;
            }
            int newId = entry.getValue();
            int currId = super.getIDRaw(itemName);
            if (currId == -1) {
                LOGGER.info(REGISTRIES, "Registry {}: Found a missing id from the world {}", (Object)this.name, (Object)itemName);
                missing.put(itemName, newId);
                continue;
            }
            if (currId != newId) {
                LOGGER.debug(REGISTRIES, "Registry {}: Fixed {} id mismatch {}: {} (init) -> {} (map).", (Object)this.name, (Object)name, (Object)itemName, (Object)currId, (Object)newId);
                remapped.put(itemName, new Integer[]{currId, newId});
            }
            Preconditions.checkState(((obj = old.getRaw(itemName)) != null ? 1 : 0) != 0, (Object)"objectKey has an ID but no object. Reflection/ASM hackery? Registry bug?");
            ArrayList lst = Lists.newArrayList((Iterable)old.overrides.get((Object)itemName));
            String primaryName = null;
            if (old.overrides.containsKey((Object)itemName)) {
                if (!overrides.containsKey(itemName)) {
                    lst.add(obj);
                    obj = (IForgeRegistryEntry)old.overrides.get((Object)itemName).iterator().next();
                    primaryName = ((OverrideOwner)old.owners.inverse().get(obj)).owner;
                } else {
                    primaryName = overrides.get(itemName);
                }
            }
            for (IForgeRegistryEntry value : lst) {
                int realId;
                OverrideOwner owner = (OverrideOwner)old.owners.inverse().get((Object)value);
                if (owner == null) {
                    LOGGER.warn(REGISTRIES, "Registry {}: Override did not have an associated owner object. Name: {} Value: {}", (Object)this.name, (Object)entry.getKey(), (Object)value);
                    continue;
                }
                if (primaryName.equals(owner.owner) || newId == (realId = this.add(newId, value, owner.owner))) continue;
                LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, (Object)entry.getKey(), (Object)newId, (Object)realId);
            }
            int realId = this.add(newId, obj, primaryName == null ? itemName.func_110623_a() : primaryName);
            if (realId != newId) {
                LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, (Object)entry.getKey(), (Object)newId, (Object)realId);
            }
            ovs.remove(itemName);
        }
        for (Map.Entry<Object, Integer> entry : ovs.entrySet()) {
            int realId;
            String current;
            itemName = (ResourceLocation)entry.getKey();
            String owner = (String)((Object)entry.getValue());
            if (owner.equals(current = ((OverrideOwner)this.owners.inverse().get(this.getRaw((ResourceLocation)itemName))).owner)) continue;
            IForgeRegistryEntry _new = (IForgeRegistryEntry)this.owners.get((Object)new OverrideOwner(owner, itemName));
            if (_new == null) {
                LOGGER.warn(REGISTRIES, "Registry {}: Skipping override for {}, Unknown owner {}", (Object)this.name, (Object)itemName, (Object)owner);
                continue;
            }
            LOGGER.info(REGISTRIES, "Registry {}: Activating override {} for {}", (Object)this.name, (Object)owner, (Object)itemName);
            int newId = this.getID(itemName);
            if (newId == (realId = this.add(newId, _new, owner))) continue;
            LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, entry.getKey(), (Object)newId, (Object)realId);
        }
    }

    boolean markDummy(ResourceLocation key, int id) {
        int realId;
        if (this.dummyFactory == null) {
            return false;
        }
        V dummy = this.dummyFactory.createDummy(key);
        LOGGER.debug(REGISTRIES, "Registry Dummy Add: {} {} -> {}", (Object)key, (Object)id, dummy);
        this.availabilityMap.clear(id);
        if (this.containsKey(key)) {
            IForgeRegistryEntry value = (IForgeRegistryEntry)this.names.remove((Object)key);
            if (value == null) {
                throw new IllegalStateException("ContainsKey for " + key + " was true, but removing by name returned no value.. This should never happen unless hackery!");
            }
            RegistryKey rkey = (RegistryKey)this.keys.inverse().remove((Object)value);
            if (rkey == null) {
                throw new IllegalStateException("Removed a entry that did not have an associated RegistryKey: " + key + " " + value.toString() + " This should never happen unless hackery!");
            }
            Integer oldid = (Integer)this.ids.inverse().remove((Object)value);
            if (oldid == null) {
                throw new IllegalStateException("Removed a entry that did not have an associated id: " + key + " " + value.toString() + " This should never happen unless hackery!");
            }
            if (oldid != id) {
                LOGGER.debug(REGISTRIES, "Registry {}: Dummy ID mismatch {} {} -> {}", (Object)this.name, (Object)key, (Object)oldid, (Object)id);
            }
            LOGGER.debug(REGISTRIES, "Registry {} remove: {} {}", (Object)this.name, (Object)key, (Object)oldid);
        }
        if ((realId = this.add(id, dummy)) != id) {
            LOGGER.warn(REGISTRIES, "Registry {}: Object did not get ID it asked for. Name: {} Expected: {} Got: {}", (Object)this.name, (Object)key, (Object)id, (Object)realId);
        }
        this.dummies.add(key);
        return true;
    }

    public Snapshot makeSnapshot() {
        Snapshot ret = new Snapshot();
        this.ids.forEach((id, value) -> ret.ids.put(this.getKey(value), (Integer)id));
        ret.aliases.putAll(this.aliases);
        ret.blocked.addAll(this.blocked);
        ret.dummied.addAll(this.dummies);
        ret.overrides.putAll(this.getOverrideOwners());
        return ret;
    }

    Map<ResourceLocation, String> getOverrideOwners() {
        HashMap ret = Maps.newHashMap();
        for (ResourceLocation key : this.overrides.keySet()) {
            IForgeRegistryEntry obj = (IForgeRegistryEntry)this.names.get((Object)key);
            OverrideOwner owner = (OverrideOwner)this.owners.inverse().get((Object)obj);
            if (owner == null) {
                LOGGER.debug(REGISTRIES, "Registry {} {}: Invalid override {} {}", (Object)this.name, (Object)this.stage.getName(), (Object)key, (Object)obj);
            }
            ret.put(key, owner.owner);
        }
        return ret;
    }

    public RegistryEvent.MissingMappings<?> getMissingEvent(ResourceLocation name, Map<ResourceLocation, Integer> map) {
        ArrayList lst = Lists.newArrayList();
        ForgeRegistry pool = RegistryManager.ACTIVE.getRegistry(name);
        map.forEach((? super K rl, ? super V id) -> lst.add(new RegistryEvent.MissingMappings.Mapping(this, pool, (ResourceLocation)rl, (int)id)));
        return new RegistryEvent.MissingMappings(name, this, lst);
    }

    void processMissingEvent(ResourceLocation name, ForgeRegistry<V> pool, List<RegistryEvent.MissingMappings.Mapping<V>> mappings, Map<ResourceLocation, Integer> missing, Map<ResourceLocation, Integer[]> remaps, Collection<ResourceLocation> defaulted, Collection<ResourceLocation> failed, boolean injectNetworkDummies) {
        LOGGER.debug(REGISTRIES, "Processing missing event for {}:", (Object)name);
        int ignored = 0;
        for (RegistryEvent.MissingMappings.Mapping<V> remap : mappings) {
            RegistryEvent.MissingMappings.Action action = remap.getAction();
            if (action == RegistryEvent.MissingMappings.Action.REMAP) {
                int currId = this.getID(remap.getTarget());
                ResourceLocation newName = pool.getKey(remap.getTarget());
                LOGGER.debug(REGISTRIES, "  Remapping {} -> {}.", (Object)remap.key, (Object)newName);
                missing.remove(remap.key);
                int realId = this.add(remap.id, remap.getTarget());
                if (realId != remap.id) {
                    LOGGER.warn(REGISTRIES, "Registered object did not get ID it asked for. Name: {} Type: {} Expected: {} Got: {}", (Object)newName, this.getRegistrySuperType(), (Object)remap.id, (Object)realId);
                }
                this.addAlias(remap.key, newName);
                if (currId == realId) continue;
                LOGGER.info(REGISTRIES, "Fixed id mismatch {}: {} (init) -> {} (map).", (Object)newName, (Object)currId, (Object)realId);
                remaps.put(newName, new Integer[]{currId, realId});
                continue;
            }
            if (action == RegistryEvent.MissingMappings.Action.DEFAULT) {
                V m;
                V v = m = this.missing == null ? null : (V)this.missing.createMissing(remap.key, injectNetworkDummies);
                if (m == null) {
                    defaulted.add(remap.key);
                } else {
                    this.add(remap.id, m, remap.key.func_110623_a());
                }
            } else if (action == RegistryEvent.MissingMappings.Action.IGNORE) {
                LOGGER.debug(REGISTRIES, "Ignoring {}", (Object)remap.key);
                ++ignored;
            } else if (action == RegistryEvent.MissingMappings.Action.FAIL) {
                LOGGER.debug(REGISTRIES, "Failing {}!", (Object)remap.key);
                failed.add(remap.key);
            } else if (action == RegistryEvent.MissingMappings.Action.WARN) {
                LOGGER.warn(REGISTRIES, "{} may cause world breakage!", (Object)remap.key);
            }
            this.block(remap.id);
        }
        if (failed.isEmpty() && ignored > 0) {
            LOGGER.debug(REGISTRIES, "There were {} missing mappings that have been ignored", (Object)ignored);
        }
    }

    private static class OverrideOwner {
        final String owner;
        final ResourceLocation key;

        private OverrideOwner(String owner, ResourceLocation key) {
            this.owner = owner;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OverrideOwner)) {
                return false;
            }
            OverrideOwner oo = (OverrideOwner)o;
            return this.owner.equals(oo.owner) && this.key.equals((Object)oo.key);
        }

        public int hashCode() {
            return 31 * this.key.hashCode() + this.owner.hashCode();
        }
    }

    public static class Snapshot {
        private static final Comparator<ResourceLocation> sorter = (a, b) -> a.compareNamespaced(b);
        public final Map<ResourceLocation, Integer> ids = Maps.newTreeMap(sorter);
        public final Map<ResourceLocation, ResourceLocation> aliases = Maps.newTreeMap(sorter);
        public final Set<Integer> blocked = Sets.newTreeSet();
        public final Set<ResourceLocation> dummied = Sets.newTreeSet(sorter);
        public final Map<ResourceLocation, String> overrides = Maps.newTreeMap(sorter);
        private PacketBuffer binary = null;

        public CompoundNBT write() {
            CompoundNBT data = new CompoundNBT();
            ListNBT ids = new ListNBT();
            this.ids.entrySet().stream().forEach(e -> {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("K", ((ResourceLocation)e.getKey()).toString());
                tag.func_74768_a("V", ((Integer)e.getValue()).intValue());
                ids.add((Object)tag);
            });
            data.func_218657_a("ids", (INBT)ids);
            ListNBT aliases = new ListNBT();
            this.aliases.entrySet().stream().forEach(e -> {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("K", ((ResourceLocation)e.getKey()).toString());
                tag.func_74778_a("V", ((ResourceLocation)e.getValue()).toString());
                aliases.add((Object)tag);
            });
            data.func_218657_a("aliases", (INBT)aliases);
            ListNBT overrides = new ListNBT();
            this.overrides.entrySet().stream().forEach(e -> {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("K", ((ResourceLocation)e.getKey()).toString());
                tag.func_74778_a("V", (String)e.getValue());
                overrides.add((Object)tag);
            });
            data.func_218657_a("overrides", (INBT)overrides);
            int[] blocked = this.blocked.stream().mapToInt(x -> x).sorted().toArray();
            data.func_74783_a("blocked", blocked);
            ListNBT dummied = new ListNBT();
            this.dummied.stream().sorted().forEach(e -> dummied.add((Object)StringNBT.func_229705_a_((String)e.toString())));
            data.func_218657_a("dummied", (INBT)dummied);
            return data;
        }

        public static Snapshot read(CompoundNBT nbt) {
            int[] blocked;
            Snapshot ret = new Snapshot();
            if (nbt == null) {
                return ret;
            }
            ListNBT list = nbt.func_150295_c("ids", 10);
            list.forEach(e -> {
                CompoundNBT comp = (CompoundNBT)e;
                ret.ids.put(new ResourceLocation(comp.func_74779_i("K")), comp.func_74762_e("V"));
            });
            list = nbt.func_150295_c("aliases", 10);
            list.forEach(e -> {
                CompoundNBT comp = (CompoundNBT)e;
                ret.aliases.put(new ResourceLocation(comp.func_74779_i("K")), new ResourceLocation(comp.func_74779_i("V")));
            });
            list = nbt.func_150295_c("overrides", 10);
            list.forEach(e -> {
                CompoundNBT comp = (CompoundNBT)e;
                ret.overrides.put(new ResourceLocation(comp.func_74779_i("K")), comp.func_74779_i("V"));
            });
            for (int i : blocked = nbt.func_74759_k("blocked")) {
                ret.blocked.add(i);
            }
            list = nbt.func_150295_c("dummied", 8);
            list.forEach(e -> ret.dummied.add(new ResourceLocation(((StringNBT)e).func_150285_a_())));
            return ret;
        }

        public synchronized PacketBuffer getPacketData() {
            if (this.binary == null) {
                PacketBuffer pkt = new PacketBuffer(Unpooled.buffer());
                pkt.func_150787_b(this.ids.size());
                this.ids.forEach((k, v) -> {
                    pkt.func_192572_a(k);
                    pkt.func_150787_b(v.intValue());
                });
                pkt.func_150787_b(this.aliases.size());
                this.aliases.forEach((k, v) -> {
                    pkt.func_192572_a(k);
                    pkt.func_192572_a(v);
                });
                pkt.func_150787_b(this.overrides.size());
                this.overrides.forEach((k, v) -> {
                    pkt.func_192572_a(k);
                    pkt.func_211400_a(v, 256);
                });
                pkt.func_150787_b(this.blocked.size());
                this.blocked.forEach(arg_0 -> ((PacketBuffer)pkt).func_150787_b(arg_0));
                pkt.func_150787_b(this.dummied.size());
                this.dummied.forEach(arg_0 -> ((PacketBuffer)pkt).func_192572_a(arg_0));
                this.binary = pkt;
            }
            return new PacketBuffer(this.binary.slice());
        }

        public static Snapshot read(PacketBuffer buff) {
            int x;
            if (buff == null) {
                return new Snapshot();
            }
            Snapshot ret = new Snapshot();
            int len = buff.func_150792_a();
            for (x = 0; x < len; ++x) {
                ret.ids.put(buff.func_192575_l(), buff.func_150792_a());
            }
            len = buff.func_150792_a();
            for (x = 0; x < len; ++x) {
                ret.aliases.put(buff.func_192575_l(), buff.func_192575_l());
            }
            len = buff.func_150792_a();
            for (x = 0; x < len; ++x) {
                ret.overrides.put(buff.func_192575_l(), buff.func_150789_c(256));
            }
            len = buff.func_150792_a();
            for (x = 0; x < len; ++x) {
                ret.blocked.add(buff.func_150792_a());
            }
            len = buff.func_150792_a();
            for (x = 0; x < len; ++x) {
                ret.dummied.add(buff.func_192575_l());
            }
            return ret;
        }
    }

    private static class DumpRow {
        final String id;
        final String key;
        final String value;
        final String dummied;

        private DumpRow(String id, String key, String value, String dummied) {
            this.id = id;
            this.key = key;
            this.value = value;
            this.dummied = dummied;
        }
    }
}

