/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.command.CommandSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.WorldWorkerManager;

public class ChunkGenWorker
implements WorldWorkerManager.IWorker {
    private final CommandSource listener;
    protected final BlockPos start;
    protected final int total;
    private final ServerWorld dim;
    private final Queue<BlockPos> queue;
    private final int notificationFrequency;
    private int lastNotification = 0;
    private long lastNotifcationTime = 0L;
    private int genned = 0;
    private Boolean keepingLoaded;

    public ChunkGenWorker(CommandSource listener, BlockPos start, int total, ServerWorld dim, int interval) {
        this.listener = listener;
        this.start = start;
        this.total = total;
        this.dim = dim;
        this.queue = this.buildQueue();
        this.notificationFrequency = interval != -1 ? interval : Math.max(total / 20, 100);
        this.lastNotifcationTime = System.currentTimeMillis();
    }

    protected Queue<BlockPos> buildQueue() {
        ArrayDeque<BlockPos> ret = new ArrayDeque<BlockPos>();
        ret.add(this.start);
        int radius = 1;
        while (ret.size() < this.total) {
            int q;
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.func_177982_a(radius, 0, q));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.func_177982_a(q, 0, radius));
            }
            for (q = radius - 1; q >= -radius && ret.size() < this.total; --q) {
                ret.add(this.start.func_177982_a(-radius, 0, q));
            }
            for (q = -radius + 1; q <= radius && ret.size() < this.total; ++q) {
                ret.add(this.start.func_177982_a(q, 0, -radius));
            }
            ++radius;
        }
        return ret;
    }

    public TextComponent getStartMessage(CommandSource sender) {
        return new TranslationTextComponent("commands.forge.gen.start", new Object[]{this.total, this.start.func_177958_n(), this.start.func_177952_p(), this.dim});
    }

    @Override
    public boolean hasWork() {
        return this.queue.size() > 0;
    }

    @Override
    public boolean doWork() {
        BlockPos next = this.queue.poll();
        if (next != null) {
            IChunk chunk;
            int z;
            int x;
            if (++this.lastNotification >= this.notificationFrequency || this.lastNotifcationTime < System.currentTimeMillis() - 60000L) {
                this.listener.func_197030_a((ITextComponent)new TranslationTextComponent("commands.forge.gen.progress", new Object[]{this.total - this.queue.size(), this.total}), true);
                this.lastNotification = 0;
                this.lastNotifcationTime = System.currentTimeMillis();
            }
            if (!this.dim.func_217354_b(x = next.func_177958_n(), z = next.func_177952_p()) && !(chunk = this.dim.func_217353_a(x, z, ChunkStatus.field_223226_a_, true)).func_201589_g().func_209003_a(ChunkStatus.field_222617_m)) {
                chunk = this.dim.func_217348_a(x, z, ChunkStatus.field_222617_m);
                ++this.genned;
            }
        }
        if (this.queue.size() == 0) {
            this.listener.func_197030_a((ITextComponent)new TranslationTextComponent("commands.forge.gen.complete", new Object[]{this.genned, this.total, this.dim.func_234923_W_().func_240901_a_()}), true);
            return false;
        }
        return true;
    }
}

