/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.potion.Potion;

public class CraftEffect {
    public static <T> int getDataValue(Effect effect, T data) {
        int datavalue;
        block0 : switch (effect) {
            case VILLAGER_PLANT_GROW: {
                datavalue = (Integer)data;
                break;
            }
            case POTION_BREAK: {
                datavalue = ((Potion)data).toDamageValue() & 0x3F;
                break;
            }
            case INSTANT_POTION_BREAK: {
                datavalue = ((Color)data).asRGB();
                break;
            }
            case RECORD_PLAY: {
                Validate.isTrue((data == Material.AIR || ((Material)data).isRecord() ? 1 : 0) != 0, (String)"Invalid record type!");
                datavalue = Item.func_150891_b((Item)CraftMagicNumbers.getItem((Material)data));
                break;
            }
            case SMOKE: {
                switch ((BlockFace)((Object)data)) {
                    case DOWN: 
                    case NORTH_EAST: 
                    case NORTH_WEST: 
                    case SOUTH_EAST: 
                    case SOUTH_WEST: 
                    case SELF: {
                        datavalue = 0;
                        break block0;
                    }
                    case UP: {
                        datavalue = 1;
                        break block0;
                    }
                    case NORTH: {
                        datavalue = 2;
                        break block0;
                    }
                    case SOUTH: {
                        datavalue = 3;
                        break block0;
                    }
                    case WEST: {
                        datavalue = 4;
                        break block0;
                    }
                    case EAST: {
                        datavalue = 5;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Bad smoke direction!");
            }
            case STEP_SOUND: {
                Validate.isTrue((boolean)((Material)data).isBlock(), (String)"Material is not a block!");
                datavalue = Block.func_196246_j((BlockState)CraftMagicNumbers.getBlock((Material)data).func_176223_P());
                break;
            }
            default: {
                datavalue = 0;
            }
        }
        return datavalue;
    }
}

