/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.block;

import com.google.common.base.Preconditions;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockState;
import org.bukkit.persistence.PersistentDataContainer;

public class CraftBlockEntityState<T extends TileEntity>
extends CraftBlockState
implements TileState {
    private final Class<T> tileEntityClass;
    private final T tileEntity;
    private final T snapshot;
    public final boolean snapshotDisabled;
    public static boolean DISABLE_SNAPSHOT = false;

    public CraftBlockEntityState(Block block, Class<T> tileEntityClass) {
        super(block);
        this.tileEntityClass = tileEntityClass;
        CraftWorld world = (CraftWorld)this.getWorld();
        this.tileEntity = (TileEntity)tileEntityClass.cast(world.getHandle().func_175625_s(this.getPosition()));
        Preconditions.checkState((this.tileEntity != null ? 1 : 0) != 0, (Object)("Tile is null, asynchronous access? %s" + block));
        this.snapshotDisabled = DISABLE_SNAPSHOT;
        this.snapshot = DISABLE_SNAPSHOT ? this.tileEntity : this.createSnapshot(this.tileEntity);
        if (this.snapshot != null) {
            this.load(this.snapshot);
        }
    }

    public CraftBlockEntityState(Material material, T tileEntity) {
        super(material);
        this.tileEntityClass = tileEntity.getClass();
        this.tileEntity = tileEntity;
        this.snapshotDisabled = DISABLE_SNAPSHOT;
        this.snapshot = DISABLE_SNAPSHOT ? this.tileEntity : this.createSnapshot(this.tileEntity);
        if (this.snapshot != null) {
            this.load(this.snapshot);
        }
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        CompoundNBT nbtTagCompound = tileEntity.func_189515_b(new CompoundNBT());
        TileEntity snapshot = TileEntity.func_235657_b_((BlockState)this.getHandle(), (CompoundNBT)nbtTagCompound);
        return (T)snapshot;
    }

    private void copyData(T from, T to) {
        BlockPos pos = to.func_174877_v();
        CompoundNBT nbtTagCompound = from.func_189515_b(new CompoundNBT());
        to.func_230337_a_(this.getHandle(), nbtTagCompound);
        to.func_174878_a(pos);
    }

    public T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected TileEntity getTileEntityFromWorld() {
        this.requirePlaced();
        return ((CraftWorld)this.getWorld()).getHandle().func_175625_s(this.getPosition());
    }

    public CompoundNBT getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return this.snapshot.func_189515_b(new CompoundNBT());
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(TileEntity tileEntity) {
        return this.tileEntityClass.isInstance(tileEntity);
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        TileEntity tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo((TileEntity)this.tileEntityClass.cast(tile));
            tile.func_70296_d();
        }
        return result;
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return ((TileEntity)this.getSnapshot()).persistentDataContainer;
    }
}

