/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.block.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BeetrootBlock;
import net.minecraft.block.BellBlock;
import net.minecraft.block.BlastFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BrewingStandBlock;
import net.minecraft.block.BubbleColumnBlock;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CarrotBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.ChainBlock;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.ChorusFlowerBlock;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.ConduitBlock;
import net.minecraft.block.CoralFanBlock;
import net.minecraft.block.CoralFinBlock;
import net.minecraft.block.CoralPlantBlock;
import net.minecraft.block.CoralWallFanBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DaylightDetectorBlock;
import net.minecraft.block.DeadCoralPlantBlock;
import net.minecraft.block.DeadCoralWallFanBlock;
import net.minecraft.block.DetectorRailBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.DropperBlock;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.EndRodBlock;
import net.minecraft.block.EnderChestBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.FrostedIceBlock;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.block.GlazedTerracottaBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.GrindstoneBlock;
import net.minecraft.block.HayBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.block.KelpBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LecternBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.LoomBlock;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.MyceliumBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.NoteBlock;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.PotatoBlock;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.RedstoneWallTorchBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.RespawnAnchorBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.ScaffoldingBlock;
import net.minecraft.block.SeaPickleBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.SkullPlayerBlock;
import net.minecraft.block.SkullWallPlayerBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SmokerBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.StoneButtonBlock;
import net.minecraft.block.StonecutterBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.block.TallSeaGrassBlock;
import net.minecraft.block.TargetBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.TrappedChestBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.block.TripWireHookBlock;
import net.minecraft.block.TurtleEggBlock;
import net.minecraft.block.TwistingVinesTopBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallBannerBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.WeepingVinesTopBlock;
import net.minecraft.block.WeightedPressurePlateBlock;
import net.minecraft.block.WitherSkeletonSkullBlock;
import net.minecraft.block.WitherSkeletonWallSkullBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateHolder;
import net.minecraft.util.Direction;
import net.minecraft.util.registry.Registry;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.CraftSoundGroup;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftAnvil;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBamboo;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBanner;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBannerWall;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBarrel;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBed;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBeehive;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBeetroot;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBell;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftBubbleColumn;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCactus;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCake;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCampfire;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCarrots;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCauldron;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftChain;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftChest;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftChestTrapped;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftChorusFlower;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftChorusFruit;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCobbleWall;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCocoa;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCommand;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftComposter;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftConduit;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCoralDead;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCoralFan;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCoralFanAbstract;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCoralFanWall;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCoralFanWallAbstract;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCoralPlant;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftCrops;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftDirtSnow;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftDispenser;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftDoor;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftDropper;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftEndRod;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftEnderChest;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftEnderPortalFrame;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftFence;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftFenceGate;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftFire;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftFloorSign;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftFluids;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftFurnaceFurace;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftGlazedTerracotta;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftGrass;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftGrindstone;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftHay;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftHopper;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftHugeMushroom;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftIceFrost;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftIronBars;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftJigsaw;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftJukeBox;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftKelp;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftLadder;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftLantern;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftLeaves;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftLectern;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftLever;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftLoom;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftMinecartDetector;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftMinecartTrack;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftMycel;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftNetherWart;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftNote;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftObserver;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftPiston;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftPistonExtension;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftPistonMoving;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftPortal;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftPotatoes;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftPoweredRail;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftPressurePlateBinary;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftPressurePlateWeighted;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftPumpkinCarved;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftRedstoneComparator;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftRedstoneLamp;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftRedstoneOre;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftRedstoneTorch;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftRedstoneTorchWall;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftRedstoneWire;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftReed;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftRepeater;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftRespawnAnchor;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftRotatable;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftSapling;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftScaffolding;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftSeaPickle;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftSkull;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftSkullPlayer;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftSkullPlayerWall;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftSkullWall;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftSmoker;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftSnow;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftSoil;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftStainedGlassPane;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftStairs;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftStem;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftStemAttached;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftStepAbstract;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftStoneButton;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftStonecutter;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftStructure;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftSweetBerryBush;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTNT;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTallPlant;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTallPlantFlower;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTallSeaGrass;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTarget;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTorchWall;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTrapdoor;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTripwire;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTripwireHook;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTurtleEgg;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftTwistingVines;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftVine;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftWallSign;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftWeepingVines;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftWitherSkullWall;
import org.bukkit.craftbukkit.v1_16_R3.block.impl.CraftWoodButton;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.jetbrains.annotations.NotNull;

public class CraftBlockData
implements BlockData {
    private BlockState state;
    private Map<Property<?>, Comparable<?>> parsedStates;
    private static final Map<Class<? extends Enum<?>>, Enum<?>[]> ENUM_VALUES = new HashMap();
    private static final Map<Class<? extends Block>, Function<BlockState, CraftBlockData>> MAP = new HashMap<Class<? extends Block>, Function<BlockState, CraftBlockData>>();

    protected CraftBlockData() {
        throw new AssertionError((Object)"Template Constructor");
    }

    protected CraftBlockData(BlockState state) {
        this.state = state;
    }

    @Override
    public Material getMaterial() {
        return CraftMagicNumbers.getMaterial(this.state.func_177230_c());
    }

    public BlockState getState() {
        return this.state;
    }

    protected <B extends Enum<B>> B get(EnumProperty<?> nms, Class<B> bukkit) {
        return CraftBlockData.toBukkit((Enum)((Object)this.state.func_177229_b(nms)), bukkit);
    }

    protected <B extends Enum<B>> Set<B> getValues(EnumProperty<?> nms, Class<B> bukkit) {
        ImmutableSet.Builder values = ImmutableSet.builder();
        for (Enum e : nms.func_177700_c()) {
            values.add(CraftBlockData.toBukkit(e, bukkit));
        }
        return values.build();
    }

    protected <B extends Enum<B>, N extends Enum<N>> void set(EnumProperty<N> nms, Enum<B> bukkit) {
        this.parsedStates = null;
        this.state = (BlockState)this.state.func_206870_a(nms, CraftBlockData.toNMS(bukkit, nms.func_177699_b()));
    }

    @Override
    public BlockData merge(BlockData data) {
        CraftBlockData craft = (CraftBlockData)data;
        Preconditions.checkArgument((craft.parsedStates != null ? 1 : 0) != 0, (Object)"Data not created via string parsing");
        Preconditions.checkArgument((this.state.func_177230_c() == craft.state.func_177230_c() ? 1 : 0) != 0, (String)"States have different types (got %s, expected %s)", (Object)data, (Object)this);
        CraftBlockData clone = (CraftBlockData)this.clone();
        clone.parsedStates = null;
        for (Property<?> parsed : craft.parsedStates.keySet()) {
            clone.state = (BlockState)clone.state.func_206870_a(parsed, craft.state.func_177229_b(parsed));
        }
        return clone;
    }

    @Override
    public boolean matches(BlockData data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof CraftBlockData)) {
            return false;
        }
        CraftBlockData craft = (CraftBlockData)data;
        if (this.state.func_177230_c() != craft.state.func_177230_c()) {
            return false;
        }
        boolean exactMatch = this.equals(data);
        if (!exactMatch && craft.parsedStates != null) {
            return this.merge(data).equals(this);
        }
        return exactMatch;
    }

    private static <B extends Enum<B>> B toBukkit(Enum<?> nms, Class<B> bukkit) {
        if (nms instanceof Direction) {
            return (B)((Object)CraftBlock.notchToBlockFace((Direction)nms));
        }
        return (B)ENUM_VALUES.computeIfAbsent(bukkit, Class::getEnumConstants)[nms.ordinal()];
    }

    private static <N extends Enum<N>> N toNMS(Enum<?> bukkit, Class<N> nms) {
        if (bukkit instanceof BlockFace) {
            return (N)CraftBlock.blockFaceToNotch((BlockFace)bukkit);
        }
        return (N)ENUM_VALUES.computeIfAbsent(nms, Class::getEnumConstants)[bukkit.ordinal()];
    }

    protected <T extends Comparable<T>> T get(Property<T> ibs) {
        return (T)this.state.func_177229_b(ibs);
    }

    public <T extends Comparable<T>, V extends T> void set(Property<T> ibs, V v) {
        this.parsedStates = null;
        this.state = (BlockState)this.state.func_206870_a(ibs, v);
    }

    @Override
    public String getAsString() {
        return this.toString((Map<Property<?>, Comparable<?>>)this.state.func_206871_b());
    }

    @Override
    public String getAsString(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? this.toString(this.parsedStates) : this.getAsString();
    }

    @Override
    @NotNull
    public String getAsStringFix() {
        return this.getAsString().replaceAll("/", "");
    }

    @Override
    public BlockData clone() {
        try {
            return (BlockData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError("Clone not supported", ex);
        }
    }

    public String toString() {
        return "CraftBlockData{" + this.getAsString() + "}";
    }

    public String toString(Map<Property<?>, Comparable<?>> states) {
        StringBuilder stateString = new StringBuilder(Registry.field_212618_g.func_177774_c((Object)this.state.func_177230_c()).toString());
        if (!states.isEmpty()) {
            stateString.append('[');
            stateString.append(states.entrySet().stream().map(StateHolder.field_235890_a_).collect(Collectors.joining(",")));
            stateString.append(']');
        }
        return stateString.toString();
    }

    public CompoundNBT toStates() {
        CompoundNBT compound = new CompoundNBT();
        for (Map.Entry entry : this.state.func_206871_b().entrySet()) {
            Property iblockstate = (Property)entry.getKey();
            compound.func_74778_a(iblockstate.func_177701_a(), iblockstate.func_177702_a((Comparable)entry.getValue()));
        }
        return compound;
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftBlockData && this.state.equals(((CraftBlockData)obj).state);
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    protected static BooleanProperty getBoolean(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BooleanProperty getBoolean(String name, boolean optional) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static EnumProperty<?> getEnum(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static IntegerProperty getInteger(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BooleanProperty getBoolean(Class<? extends Block> block, String name) {
        return (BooleanProperty)CraftBlockData.getState(block, name, false);
    }

    protected static BooleanProperty getBoolean(Class<? extends Block> block, String name, boolean optional) {
        return (BooleanProperty)CraftBlockData.getState(block, name, optional);
    }

    protected static EnumProperty<?> getEnum(Class<? extends Block> block, String name) {
        return (EnumProperty)CraftBlockData.getState(block, name, false);
    }

    protected static IntegerProperty getInteger(Class<? extends Block> block, String name) {
        return (IntegerProperty)CraftBlockData.getState(block, name, false);
    }

    private static Property<?> getState(Class<? extends Block> block, String name, boolean optional) {
        Property state = null;
        for (Block instance : Registry.field_212618_g) {
            if (instance.getClass() != block) continue;
            if (state == null) {
                state = instance.func_176194_O().func_185920_a(name);
                continue;
            }
            Property newState = instance.func_176194_O().func_185920_a(name);
            Preconditions.checkState((state == newState ? 1 : 0) != 0, (String)"State mistmatch %s,%s", (Object)state, (Object)newState);
        }
        Preconditions.checkState((optional || state != null ? 1 : 0) != 0, (String)"Null state for %s,%s", block, (Object)name);
        return state;
    }

    protected static int getMin(IntegerProperty state) {
        return state.min;
    }

    protected static int getMax(IntegerProperty state) {
        return state.max;
    }

    private static void register(Class<? extends Block> nms, Function<BlockState, CraftBlockData> bukkit) {
        Preconditions.checkState((MAP.put(nms, bukkit) == null ? 1 : 0) != 0, (String)"Duplicate mapping %s->%s", nms, bukkit);
    }

    public static CraftBlockData newData(Material material, String data) {
        BlockState blockData;
        Preconditions.checkArgument((material == null || material.isBlock() ? 1 : 0) != 0, (String)"Cannot get data for not block %s", (Object)material);
        Block block = CraftMagicNumbers.getBlock(material);
        Map parsed = null;
        if (data != null) {
            try {
                if (block != null) {
                    data = Registry.field_212618_g.func_177774_c((Object)block) + data;
                }
                StringReader reader = new StringReader(data);
                BlockStateParser arg = new BlockStateParser(reader, false).func_197243_a(false);
                Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data: " + data));
                blockData = arg.func_197249_b();
                parsed = arg.func_197254_a();
            }
            catch (CommandSyntaxException ex) {
                try {
                    data = CraftBlockData.getGoodData(data);
                    if (block != null) {
                        data = Registry.field_212618_g.func_177774_c((Object)block) + data;
                    }
                    StringReader reader = new StringReader(data);
                    BlockStateParser arg = new BlockStateParser(reader, false).func_197243_a(false);
                    Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data: " + data));
                    blockData = arg.func_197249_b();
                    parsed = arg.func_197254_a();
                }
                catch (CommandSyntaxException ex2) {
                    throw new IllegalArgumentException("Could not parse data: " + data, ex2);
                }
            }
        } else {
            blockData = block.func_176223_P();
        }
        CraftBlockData craft = CraftBlockData.fromData(blockData);
        craft.parsedStates = parsed;
        return craft;
    }

    public static String getGoodData(String data) {
        for (Block block_search : Registry.field_212618_g) {
            if (!block_search.getRegistryName().toString().replaceAll("/", "").equals(data)) continue;
            return block_search.getRegistryName().toString();
        }
        return data;
    }

    public static CraftBlockData fromData(BlockState data) {
        return (CraftBlockData)MAP.getOrDefault(data.func_177230_c().getClass(), (Function<BlockState, CraftBlockData>)((Function)CraftBlockData::new)).apply((Object)data);
    }

    @Override
    public SoundGroup getSoundGroup() {
        return CraftSoundGroup.getSoundGroup(this.state.func_215695_r());
    }

    static {
        CraftBlockData.register(AnvilBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftAnvil::new));
        CraftBlockData.register(BambooBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBamboo::new));
        CraftBlockData.register(BannerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBanner::new));
        CraftBlockData.register(WallBannerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBannerWall::new));
        CraftBlockData.register(BarrelBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBarrel::new));
        CraftBlockData.register(BedBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBed::new));
        CraftBlockData.register(BeehiveBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBeehive::new));
        CraftBlockData.register(BeetrootBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBeetroot::new));
        CraftBlockData.register(BellBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBell::new));
        CraftBlockData.register(BlastFurnaceBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBlastFurnace::new));
        CraftBlockData.register(BrewingStandBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBrewingStand::new));
        CraftBlockData.register(BubbleColumnBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBubbleColumn::new));
        CraftBlockData.register(CactusBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCactus::new));
        CraftBlockData.register(CakeBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCake::new));
        CraftBlockData.register(CampfireBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCampfire::new));
        CraftBlockData.register(CarrotBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCarrots::new));
        CraftBlockData.register(CauldronBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCauldron::new));
        CraftBlockData.register(ChainBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChain::new));
        CraftBlockData.register(ChestBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChest::new));
        CraftBlockData.register(TrappedChestBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChestTrapped::new));
        CraftBlockData.register(ChorusFlowerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChorusFlower::new));
        CraftBlockData.register(ChorusPlantBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChorusFruit::new));
        CraftBlockData.register(WallBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCobbleWall::new));
        CraftBlockData.register(CocoaBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCocoa::new));
        CraftBlockData.register(CommandBlockBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCommand::new));
        CraftBlockData.register(ComposterBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftComposter::new));
        CraftBlockData.register(ConduitBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftConduit::new));
        CraftBlockData.register(DeadCoralPlantBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralDead::new));
        CraftBlockData.register(CoralFinBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralFan::new));
        CraftBlockData.register(CoralFanBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralFanAbstract::new));
        CraftBlockData.register(CoralWallFanBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralFanWall::new));
        CraftBlockData.register(DeadCoralWallFanBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralFanWallAbstract::new));
        CraftBlockData.register(CoralPlantBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralPlant::new));
        CraftBlockData.register(CropsBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCrops::new));
        CraftBlockData.register(DaylightDetectorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDaylightDetector::new));
        CraftBlockData.register(SnowyDirtBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDirtSnow::new));
        CraftBlockData.register(DispenserBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDispenser::new));
        CraftBlockData.register(DoorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDoor::new));
        CraftBlockData.register(DropperBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDropper::new));
        CraftBlockData.register(EnderChestBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftEnderChest::new));
        CraftBlockData.register(EndPortalFrameBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftEnderPortalFrame::new));
        CraftBlockData.register(EndRodBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftEndRod::new));
        CraftBlockData.register(FenceBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFence::new));
        CraftBlockData.register(FenceGateBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFenceGate::new));
        CraftBlockData.register(FireBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFire::new));
        CraftBlockData.register(StandingSignBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFloorSign::new));
        CraftBlockData.register(FlowingFluidBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFluids::new));
        CraftBlockData.register(FurnaceBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFurnaceFurace::new));
        CraftBlockData.register(GlazedTerracottaBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftGlazedTerracotta::new));
        CraftBlockData.register(GrassBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftGrass::new));
        CraftBlockData.register(GrindstoneBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftGrindstone::new));
        CraftBlockData.register(HayBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftHay::new));
        CraftBlockData.register(HopperBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftHopper::new));
        CraftBlockData.register(HugeMushroomBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftHugeMushroom::new));
        CraftBlockData.register(FrostedIceBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftIceFrost::new));
        CraftBlockData.register(PaneBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftIronBars::new));
        CraftBlockData.register(JigsawBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftJigsaw::new));
        CraftBlockData.register(JukeboxBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftJukeBox::new));
        CraftBlockData.register(KelpBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftKelp::new));
        CraftBlockData.register(LadderBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLadder::new));
        CraftBlockData.register(LanternBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLantern::new));
        CraftBlockData.register(LeavesBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLeaves::new));
        CraftBlockData.register(LecternBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLectern::new));
        CraftBlockData.register(LeverBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLever::new));
        CraftBlockData.register(LoomBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLoom::new));
        CraftBlockData.register(DetectorRailBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftMinecartDetector::new));
        CraftBlockData.register(RailBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftMinecartTrack::new));
        CraftBlockData.register(MyceliumBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftMycel::new));
        CraftBlockData.register(NetherWartBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftNetherWart::new));
        CraftBlockData.register(NoteBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftNote::new));
        CraftBlockData.register(ObserverBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftObserver::new));
        CraftBlockData.register(PistonBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPiston::new));
        CraftBlockData.register(PistonHeadBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPistonExtension::new));
        CraftBlockData.register(MovingPistonBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPistonMoving::new));
        CraftBlockData.register(NetherPortalBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPortal::new));
        CraftBlockData.register(PotatoBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPotatoes::new));
        CraftBlockData.register(PoweredRailBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPoweredRail::new));
        CraftBlockData.register(PressurePlateBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPressurePlateBinary::new));
        CraftBlockData.register(WeightedPressurePlateBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPressurePlateWeighted::new));
        CraftBlockData.register(CarvedPumpkinBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPumpkinCarved::new));
        CraftBlockData.register(ComparatorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneComparator::new));
        CraftBlockData.register(RedstoneLampBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneLamp::new));
        CraftBlockData.register(RedstoneOreBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneOre::new));
        CraftBlockData.register(RedstoneTorchBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneTorch::new));
        CraftBlockData.register(RedstoneWallTorchBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneTorchWall::new));
        CraftBlockData.register(RedstoneWireBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneWire::new));
        CraftBlockData.register(SugarCaneBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftReed::new));
        CraftBlockData.register(RepeaterBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRepeater::new));
        CraftBlockData.register(RespawnAnchorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRespawnAnchor::new));
        CraftBlockData.register(RotatedPillarBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRotatable::new));
        CraftBlockData.register(SaplingBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSapling::new));
        CraftBlockData.register(ScaffoldingBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftScaffolding::new));
        CraftBlockData.register(SeaPickleBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSeaPickle::new));
        CraftBlockData.register(ShulkerBoxBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftShulkerBox::new));
        CraftBlockData.register(SkullBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSkull::new));
        CraftBlockData.register(SkullPlayerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSkullPlayer::new));
        CraftBlockData.register(SkullWallPlayerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSkullPlayerWall::new));
        CraftBlockData.register(WallSkullBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSkullWall::new));
        CraftBlockData.register(SmokerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSmoker::new));
        CraftBlockData.register(SnowBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSnow::new));
        CraftBlockData.register(FarmlandBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSoil::new));
        CraftBlockData.register(StainedGlassPaneBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStainedGlassPane::new));
        CraftBlockData.register(StairsBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStairs::new));
        CraftBlockData.register(StemBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStem::new));
        CraftBlockData.register(AttachedStemBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStemAttached::new));
        CraftBlockData.register(SlabBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStepAbstract::new));
        CraftBlockData.register(StoneButtonBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStoneButton::new));
        CraftBlockData.register(StonecutterBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStonecutter::new));
        CraftBlockData.register(StructureBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStructure::new));
        CraftBlockData.register(SweetBerryBushBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSweetBerryBush::new));
        CraftBlockData.register(DoublePlantBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTallPlant::new));
        CraftBlockData.register(TallFlowerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTallPlantFlower::new));
        CraftBlockData.register(TallSeaGrassBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTallSeaGrass::new));
        CraftBlockData.register(TargetBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTarget::new));
        CraftBlockData.register(TNTBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTNT::new));
        CraftBlockData.register(WallTorchBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTorchWall::new));
        CraftBlockData.register(TrapDoorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTrapdoor::new));
        CraftBlockData.register(TripWireBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTripwire::new));
        CraftBlockData.register(TripWireHookBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTripwireHook::new));
        CraftBlockData.register(TurtleEggBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTurtleEgg::new));
        CraftBlockData.register(TwistingVinesTopBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTwistingVines::new));
        CraftBlockData.register(VineBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftVine::new));
        CraftBlockData.register(WallSignBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWallSign::new));
        CraftBlockData.register(WeepingVinesTopBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWeepingVines::new));
        CraftBlockData.register(WitherSkeletonSkullBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWitherSkull::new));
        CraftBlockData.register(WitherSkeletonWallSkullBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWitherSkullWall::new));
        CraftBlockData.register(WoodButtonBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWoodButton::new));
    }
}

