/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mohistmc.entity.CraftCustomAbstractHorse;
import com.mohistmc.entity.CraftCustomChestHorse;
import com.mohistmc.entity.CraftCustomEntity;
import com.mohistmc.entity.CraftCustomFakePlayer;
import com.mohistmc.entity.CraftCustomMinecartContainer;
import com.mohistmc.entity.CraftCustomMinecraft;
import com.mohistmc.entity.CraftCustomProjectileEntity;
import com.mohistmc.entity.CraftCustomRaider;
import com.mohistmc.entity.CraftCustomThrowableEntity;
import com.mohistmc.entity.CraftCustomThrowableProjectile;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.CommandBlockMinecartEntity;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.item.minecart.SpawnerMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinBruteEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.AmbientEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.entity.projectile.EyeOfEnderEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftAmbient;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftAreaEffectCloud;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftBat;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftBee;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftBlaze;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftCat;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftCaveSpider;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftCod;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftComplexPart;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftCow;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftDolphin;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftDonkey;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftDragonFireball;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftDrowned;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEgg;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftElderGuardian;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEnderPearl;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEnderSignal;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEndermite;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEvoker;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEvokerFangs;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftFireball;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftFish;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftFlying;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftFox;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftGhast;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftGiant;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftGolem;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftGuardian;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHoglin;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHorse;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHusk;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftIllager;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftIllusioner;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftIronGolem;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftItem;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftItemFrame;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLargeFireball;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLeash;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLlama;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLlamaSpit;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMagmaCube;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMinecart;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMinecartChest;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMinecartFurnace;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMinecartHopper;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMinecartMobSpawner;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMinecartRideable;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMinecartTNT;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMule;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftMushroomCow;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftOcelot;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPainting;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPanda;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftParrot;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPhantom;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPig;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPigZombie;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPiglinAbstract;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPiglinBrute;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPillager;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPolarBear;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPufferFish;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftRabbit;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftRavager;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSalmon;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSheep;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftShulkerBullet;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSilverfish;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSkeleton;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSkeletonHorse;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSlime;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSmallFireball;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSnowball;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSnowman;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSpectralArrow;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSpellcaster;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSpider;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftSquid;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftStray;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftStrider;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftTNTPrimed;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftThrownExpBottle;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftThrownPotion;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftTippedArrow;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftTraderLlama;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftTrident;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftTropicalFish;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftTurtle;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftVex;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftVillagerZombie;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftVindicator;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftWanderingTrader;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftWaterMob;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftWitch;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftWither;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftWitherSkeleton;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftZoglin;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftZombieHorse;
import org.bukkit.craftbukkit.v1_16_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_16_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pose;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public abstract class CraftEntity
implements Entity {
    private static PermissibleBase perm;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    protected final CraftServer server;
    protected net.minecraft.entity.Entity entity;
    private EntityDamageEvent lastDamageEvent;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private final Entity.Spigot spigot = new Entity.Spigot(){

        @Override
        public void sendMessage(BaseComponent component) {
        }

        @Override
        public void sendMessage(BaseComponent ... components) {
        }

        @Override
        public void sendMessage(UUID sender, BaseComponent ... components) {
        }

        @Override
        public void sendMessage(UUID sender, BaseComponent component) {
        }
    };

    public CraftEntity(CraftServer server, net.minecraft.entity.Entity entity) {
        this.server = server;
        this.entity = entity;
    }

    public static CraftEntity getEntity(CraftServer server, net.minecraft.entity.Entity entity) {
        if (entity instanceof LivingEntity) {
            if (entity instanceof PlayerEntity) {
                if (entity instanceof ServerPlayerEntity) {
                    return new CraftPlayer(server, (ServerPlayerEntity)entity);
                }
                return new CraftCustomFakePlayer(server, (PlayerEntity)entity);
            }
            if (entity instanceof WaterMobEntity) {
                if (entity instanceof SquidEntity) {
                    return new CraftSquid(server, (SquidEntity)entity);
                }
                if (entity instanceof AbstractFishEntity) {
                    if (entity instanceof CodEntity) {
                        return new CraftCod(server, (CodEntity)entity);
                    }
                    if (entity instanceof PufferfishEntity) {
                        return new CraftPufferFish(server, (PufferfishEntity)entity);
                    }
                    if (entity instanceof SalmonEntity) {
                        return new CraftSalmon(server, (SalmonEntity)entity);
                    }
                    if (entity instanceof TropicalFishEntity) {
                        return new CraftTropicalFish(server, (TropicalFishEntity)entity);
                    }
                    return new CraftFish(server, (AbstractFishEntity)entity);
                }
                if (entity instanceof DolphinEntity) {
                    return new CraftDolphin(server, (DolphinEntity)entity);
                }
                return new CraftWaterMob(server, (WaterMobEntity)entity);
            }
            if (entity instanceof CreatureEntity) {
                if (entity instanceof AnimalEntity) {
                    if (entity instanceof ChickenEntity) {
                        return new CraftChicken(server, (ChickenEntity)entity);
                    }
                    if (entity instanceof CowEntity) {
                        if (entity instanceof MooshroomEntity) {
                            return new CraftMushroomCow(server, (MooshroomEntity)entity);
                        }
                        return new CraftCow(server, (CowEntity)entity);
                    }
                    if (entity instanceof PigEntity) {
                        return new CraftPig(server, (PigEntity)entity);
                    }
                    if (entity instanceof TameableEntity) {
                        if (entity instanceof WolfEntity) {
                            return new CraftWolf(server, (WolfEntity)entity);
                        }
                        if (entity instanceof CatEntity) {
                            return new CraftCat(server, (CatEntity)entity);
                        }
                        if (entity instanceof ParrotEntity) {
                            return new CraftParrot(server, (ParrotEntity)entity);
                        }
                        return new CraftTameableAnimal(server, (TameableEntity)entity);
                    }
                    if (entity instanceof SheepEntity) {
                        return new CraftSheep(server, (SheepEntity)entity);
                    }
                    if (entity instanceof AbstractHorseEntity) {
                        if (entity instanceof AbstractChestedHorseEntity) {
                            if (entity instanceof DonkeyEntity) {
                                return new CraftDonkey(server, (DonkeyEntity)entity);
                            }
                            if (entity instanceof MuleEntity) {
                                return new CraftMule(server, (MuleEntity)entity);
                            }
                            if (entity instanceof TraderLlamaEntity) {
                                return new CraftTraderLlama(server, (TraderLlamaEntity)entity);
                            }
                            if (entity instanceof LlamaEntity) {
                                return new CraftLlama(server, (LlamaEntity)entity);
                            }
                            return new CraftCustomChestHorse(server, (AbstractChestedHorseEntity)entity);
                        }
                        if (entity instanceof HorseEntity) {
                            return new CraftHorse(server, (HorseEntity)entity);
                        }
                        if (entity instanceof SkeletonHorseEntity) {
                            return new CraftSkeletonHorse(server, (SkeletonHorseEntity)entity);
                        }
                        if (entity instanceof ZombieHorseEntity) {
                            return new CraftZombieHorse(server, (ZombieHorseEntity)entity);
                        }
                        return new CraftCustomAbstractHorse(server, (AbstractHorseEntity)entity);
                    }
                    if (entity instanceof RabbitEntity) {
                        return new CraftRabbit(server, (RabbitEntity)entity);
                    }
                    if (entity instanceof PolarBearEntity) {
                        return new CraftPolarBear(server, (PolarBearEntity)entity);
                    }
                    if (entity instanceof TurtleEntity) {
                        return new CraftTurtle(server, (TurtleEntity)entity);
                    }
                    if (entity instanceof OcelotEntity) {
                        return new CraftOcelot(server, (OcelotEntity)entity);
                    }
                    if (entity instanceof PandaEntity) {
                        return new CraftPanda(server, (PandaEntity)entity);
                    }
                    if (entity instanceof FoxEntity) {
                        return new CraftFox(server, (FoxEntity)entity);
                    }
                    if (entity instanceof BeeEntity) {
                        return new CraftBee(server, (BeeEntity)entity);
                    }
                    if (entity instanceof HoglinEntity) {
                        return new CraftHoglin(server, (HoglinEntity)entity);
                    }
                    if (entity instanceof StriderEntity) {
                        return new CraftStrider(server, (StriderEntity)entity);
                    }
                    return new CraftAnimals(server, (AnimalEntity)entity);
                }
                if (entity instanceof MonsterEntity) {
                    if (entity instanceof ZombieEntity) {
                        if (entity instanceof ZombifiedPiglinEntity) {
                            return new CraftPigZombie(server, (ZombifiedPiglinEntity)entity);
                        }
                        if (entity instanceof HuskEntity) {
                            return new CraftHusk(server, (HuskEntity)entity);
                        }
                        if (entity instanceof ZombieVillagerEntity) {
                            return new CraftVillagerZombie(server, (ZombieVillagerEntity)entity);
                        }
                        if (entity instanceof DrownedEntity) {
                            return new CraftDrowned(server, (DrownedEntity)entity);
                        }
                        return new CraftZombie(server, (ZombieEntity)entity);
                    }
                    if (entity instanceof CreeperEntity) {
                        return new CraftCreeper(server, (CreeperEntity)entity);
                    }
                    if (entity instanceof EndermanEntity) {
                        return new CraftEnderman(server, (EndermanEntity)entity);
                    }
                    if (entity instanceof SilverfishEntity) {
                        return new CraftSilverfish(server, (SilverfishEntity)entity);
                    }
                    if (entity instanceof GiantEntity) {
                        return new CraftGiant(server, (GiantEntity)entity);
                    }
                    if (entity instanceof AbstractSkeletonEntity) {
                        if (entity instanceof StrayEntity) {
                            return new CraftStray(server, (StrayEntity)entity);
                        }
                        if (entity instanceof WitherSkeletonEntity) {
                            return new CraftWitherSkeleton(server, (WitherSkeletonEntity)entity);
                        }
                        return new CraftSkeleton(server, (AbstractSkeletonEntity)entity);
                    }
                    if (entity instanceof BlazeEntity) {
                        return new CraftBlaze(server, (BlazeEntity)entity);
                    }
                    if (entity instanceof WitchEntity) {
                        return new CraftWitch(server, (WitchEntity)entity);
                    }
                    if (entity instanceof WitherEntity) {
                        return new CraftWither(server, (WitherEntity)entity);
                    }
                    if (entity instanceof SpiderEntity) {
                        if (entity instanceof CaveSpiderEntity) {
                            return new CraftCaveSpider(server, (CaveSpiderEntity)entity);
                        }
                        return new CraftSpider(server, (SpiderEntity)entity);
                    }
                    if (entity instanceof EndermiteEntity) {
                        return new CraftEndermite(server, (EndermiteEntity)entity);
                    }
                    if (entity instanceof GuardianEntity) {
                        if (entity instanceof ElderGuardianEntity) {
                            return new CraftElderGuardian(server, (ElderGuardianEntity)entity);
                        }
                        return new CraftGuardian(server, (GuardianEntity)entity);
                    }
                    if (entity instanceof VexEntity) {
                        return new CraftVex(server, (VexEntity)entity);
                    }
                    if (entity instanceof AbstractIllagerEntity) {
                        if (entity instanceof SpellcastingIllagerEntity) {
                            if (entity instanceof EvokerEntity) {
                                return new CraftEvoker(server, (EvokerEntity)entity);
                            }
                            if (entity instanceof IllusionerEntity) {
                                return new CraftIllusioner(server, (IllusionerEntity)entity);
                            }
                            return new CraftSpellcaster(server, (SpellcastingIllagerEntity)entity);
                        }
                        if (entity instanceof VindicatorEntity) {
                            return new CraftVindicator(server, (VindicatorEntity)entity);
                        }
                        if (entity instanceof PillagerEntity) {
                            return new CraftPillager(server, (PillagerEntity)entity);
                        }
                        return new CraftIllager(server, (AbstractIllagerEntity)entity);
                    }
                    if (entity instanceof RavagerEntity) {
                        return new CraftRavager(server, (RavagerEntity)entity);
                    }
                    if (entity instanceof AbstractPiglinEntity) {
                        if (entity instanceof PiglinEntity) {
                            return new CraftPiglin(server, (PiglinEntity)entity);
                        }
                        if (entity instanceof PiglinBruteEntity) {
                            return new CraftPiglinBrute(server, (PiglinBruteEntity)entity);
                        }
                        return new CraftPiglinAbstract(server, (AbstractPiglinEntity)entity);
                    }
                    if (entity instanceof ZoglinEntity) {
                        return new CraftZoglin(server, (ZoglinEntity)entity);
                    }
                    if (entity instanceof AbstractRaiderEntity) {
                        return new CraftCustomRaider(server, (AbstractRaiderEntity)entity);
                    }
                    return new CraftMonster(server, (MonsterEntity)entity);
                }
                if (entity instanceof GolemEntity) {
                    if (entity instanceof SnowGolemEntity) {
                        return new CraftSnowman(server, (SnowGolemEntity)entity);
                    }
                    if (entity instanceof IronGolemEntity) {
                        return new CraftIronGolem(server, (IronGolemEntity)entity);
                    }
                    if (entity instanceof ShulkerEntity) {
                        return new CraftShulker(server, (ShulkerEntity)entity);
                    }
                    return new CraftGolem(server, (GolemEntity)entity);
                }
                if (entity instanceof AbstractVillagerEntity) {
                    if (entity instanceof VillagerEntity) {
                        return new CraftVillager(server, (VillagerEntity)entity);
                    }
                    if (entity instanceof WanderingTraderEntity) {
                        return new CraftWanderingTrader(server, (WanderingTraderEntity)entity);
                    }
                    return new CraftAbstractVillager(server, (AbstractVillagerEntity)entity);
                }
                return new CraftCreature(server, (CreatureEntity)entity);
            }
            if (entity instanceof SlimeEntity) {
                if (entity instanceof MagmaCubeEntity) {
                    return new CraftMagmaCube(server, (MagmaCubeEntity)entity);
                }
                return new CraftSlime(server, (SlimeEntity)entity);
            }
            if (entity instanceof FlyingEntity) {
                if (entity instanceof GhastEntity) {
                    return new CraftGhast(server, (GhastEntity)entity);
                }
                if (entity instanceof PhantomEntity) {
                    return new CraftPhantom(server, (PhantomEntity)entity);
                }
                return new CraftFlying(server, (FlyingEntity)entity);
            }
            if (entity instanceof EnderDragonEntity) {
                return new CraftEnderDragon(server, (EnderDragonEntity)entity);
            }
            if (entity instanceof AmbientEntity) {
                if (entity instanceof BatEntity) {
                    return new CraftBat(server, (BatEntity)entity);
                }
                return new CraftAmbient(server, (AmbientEntity)entity);
            }
            if (entity instanceof ArmorStandEntity) {
                return new CraftArmorStand(server, (ArmorStandEntity)entity);
            }
            return new CraftLivingEntity(server, (LivingEntity)entity);
        }
        if (entity instanceof EnderDragonPartEntity) {
            EnderDragonPartEntity part = (EnderDragonPartEntity)entity;
            if (part.field_213852_b instanceof EnderDragonEntity) {
                return new CraftEnderDragonPart(server, (EnderDragonPartEntity)entity);
            }
            return new CraftComplexPart(server, (EnderDragonPartEntity)entity);
        }
        if (entity instanceof ExperienceOrbEntity) {
            return new CraftExperienceOrb(server, (ExperienceOrbEntity)entity);
        }
        if (entity instanceof ArrowEntity) {
            return new CraftTippedArrow(server, (ArrowEntity)entity);
        }
        if (entity instanceof SpectralArrowEntity) {
            return new CraftSpectralArrow(server, (SpectralArrowEntity)entity);
        }
        if (entity instanceof AbstractArrowEntity) {
            if (entity instanceof TridentEntity) {
                return new CraftTrident(server, (TridentEntity)entity);
            }
            return new CraftArrow(server, (AbstractArrowEntity)entity);
        }
        if (entity instanceof BoatEntity) {
            return new CraftBoat(server, (BoatEntity)entity);
        }
        if (entity instanceof ThrowableEntity) {
            if (entity instanceof EggEntity) {
                return new CraftEgg(server, (EggEntity)entity);
            }
            if (entity instanceof SnowballEntity) {
                return new CraftSnowball(server, (SnowballEntity)entity);
            }
            if (entity instanceof PotionEntity) {
                return new CraftThrownPotion(server, (PotionEntity)entity);
            }
            if (entity instanceof EnderPearlEntity) {
                return new CraftEnderPearl(server, (EnderPearlEntity)entity);
            }
            if (entity instanceof ExperienceBottleEntity) {
                return new CraftThrownExpBottle(server, (ExperienceBottleEntity)entity);
            }
            return new CraftCustomThrowableEntity(server, (ThrowableEntity)entity);
        }
        if (entity instanceof FallingBlockEntity) {
            return new CraftFallingBlock(server, (FallingBlockEntity)entity);
        }
        if (entity instanceof DamagingProjectileEntity) {
            if (entity instanceof SmallFireballEntity) {
                return new CraftSmallFireball(server, (SmallFireballEntity)entity);
            }
            if (entity instanceof FireballEntity) {
                return new CraftLargeFireball(server, (FireballEntity)entity);
            }
            if (entity instanceof WitherSkullEntity) {
                return new CraftWitherSkull(server, (WitherSkullEntity)entity);
            }
            if (entity instanceof DragonFireballEntity) {
                return new CraftDragonFireball(server, (DragonFireballEntity)entity);
            }
            return new CraftFireball(server, (DamagingProjectileEntity)entity);
        }
        if (entity instanceof EyeOfEnderEntity) {
            return new CraftEnderSignal(server, (EyeOfEnderEntity)entity);
        }
        if (entity instanceof EnderCrystalEntity) {
            return new CraftEnderCrystal(server, (EnderCrystalEntity)entity);
        }
        if (entity instanceof FishingBobberEntity) {
            return new CraftFishHook(server, (FishingBobberEntity)entity);
        }
        if (entity instanceof ItemEntity) {
            return new CraftItem(server, (ItemEntity)entity);
        }
        if (entity instanceof LightningBoltEntity) {
            return new CraftLightningStrike(server, (LightningBoltEntity)entity);
        }
        if (entity instanceof AbstractMinecartEntity) {
            if (entity instanceof FurnaceMinecartEntity) {
                return new CraftMinecartFurnace(server, (FurnaceMinecartEntity)entity);
            }
            if (entity instanceof ChestMinecartEntity) {
                return new CraftMinecartChest(server, (ChestMinecartEntity)entity);
            }
            if (entity instanceof TNTMinecartEntity) {
                return new CraftMinecartTNT(server, (TNTMinecartEntity)entity);
            }
            if (entity instanceof HopperMinecartEntity) {
                return new CraftMinecartHopper(server, (HopperMinecartEntity)entity);
            }
            if (entity instanceof SpawnerMinecartEntity) {
                return new CraftMinecartMobSpawner(server, (SpawnerMinecartEntity)entity);
            }
            if (entity instanceof MinecartEntity) {
                return new CraftMinecartRideable(server, (AbstractMinecartEntity)((MinecartEntity)entity));
            }
            if (entity instanceof CommandBlockMinecartEntity) {
                return new CraftMinecartCommand(server, (CommandBlockMinecartEntity)entity);
            }
            return new CraftMinecart(server, (AbstractMinecartEntity)entity);
        }
        if (entity instanceof HangingEntity) {
            if (entity instanceof PaintingEntity) {
                return new CraftPainting(server, (PaintingEntity)entity);
            }
            if (entity instanceof ItemFrameEntity) {
                return new CraftItemFrame(server, (ItemFrameEntity)entity);
            }
            if (entity instanceof LeashKnotEntity) {
                return new CraftLeash(server, (LeashKnotEntity)entity);
            }
            return new CraftHanging(server, (HangingEntity)entity);
        }
        if (entity instanceof TNTEntity) {
            return new CraftTNTPrimed(server, (TNTEntity)entity);
        }
        if (entity instanceof FireworkRocketEntity) {
            return new CraftFirework(server, (FireworkRocketEntity)entity);
        }
        if (entity instanceof ShulkerBulletEntity) {
            return new CraftShulkerBullet(server, (ShulkerBulletEntity)entity);
        }
        if (entity instanceof AreaEffectCloudEntity) {
            return new CraftAreaEffectCloud(server, (AreaEffectCloudEntity)entity);
        }
        if (entity instanceof EvokerFangsEntity) {
            return new CraftEvokerFangs(server, (EvokerFangsEntity)entity);
        }
        if (entity instanceof LlamaSpitEntity) {
            return new CraftLlamaSpit(server, (LlamaSpitEntity)entity);
        }
        if (entity instanceof ProjectileEntity) {
            return new CraftCustomProjectileEntity(server, (ProjectileEntity)entity);
        }
        if (entity instanceof ProjectileItemEntity) {
            return new CraftCustomThrowableProjectile(server, (ProjectileItemEntity)entity);
        }
        if (entity instanceof AbstractMinecartEntity) {
            return new CraftCustomMinecraft(server, (AbstractMinecartEntity)entity);
        }
        if (entity instanceof ContainerMinecartEntity) {
            return new CraftCustomMinecartContainer(server, (AbstractMinecartEntity)((ContainerMinecartEntity)entity));
        }
        return new CraftCustomEntity(server, entity);
    }

    @Override
    public Location getLocation() {
        return new Location(this.getWorld(), this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_(), this.entity.getBukkitYaw(), this.entity.field_70125_A);
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.func_226277_ct_());
            loc.setY(this.entity.func_226278_cu_());
            loc.setZ(this.entity.func_226281_cx_());
            loc.setYaw(this.entity.getBukkitYaw());
            loc.setPitch(this.entity.field_70125_A);
        }
        return loc;
    }

    @Override
    public Vector getVelocity() {
        return CraftVector.toBukkit(this.entity.func_213322_ci());
    }

    @Override
    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"velocity");
        this.entity.func_213317_d(CraftVector.toNMS(velocity));
        this.entity.field_70133_I = true;
    }

    @Override
    public double getHeight() {
        return this.getHandle().func_213302_cg();
    }

    @Override
    public double getWidth() {
        return this.getHandle().func_213311_cf();
    }

    @Override
    public BoundingBox getBoundingBox() {
        AxisAlignedBB bb = this.getHandle().func_174813_aQ();
        return new BoundingBox(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
    }

    @Override
    public boolean isOnGround() {
        if (this.entity instanceof AbstractArrowEntity) {
            return ((AbstractArrowEntity)this.entity).field_70254_i;
        }
        return this.entity.func_233570_aj_();
    }

    @Override
    public boolean isInWater() {
        return this.entity.func_70090_H();
    }

    @Override
    public World getWorld() {
        return this.entity.field_70170_p.getWorld();
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        NumberConversions.checkFinite(pitch, "pitch not finite");
        NumberConversions.checkFinite(yaw, "yaw not finite");
        yaw = Location.normalizeYaw(yaw);
        pitch = Location.normalizePitch(pitch);
        this.entity.field_70177_z = yaw;
        this.entity.field_70125_A = pitch;
        this.entity.field_70126_B = yaw;
        this.entity.field_70127_C = pitch;
        this.entity.func_70034_d(yaw);
    }

    @Override
    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        location.checkFinite();
        if (this.entity.func_184207_aI() || this.entity.field_70128_L) {
            return false;
        }
        this.entity.func_184210_p();
        if (!location.getWorld().equals(this.getWorld())) {
            this.entity.teleportTo(((CraftWorld)location.getWorld()).getHandle(), new BlockPos(location.getX(), location.getY(), location.getZ()));
            return true;
        }
        this.entity.func_70080_a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.entity.func_70034_d(location.getYaw());
        return true;
    }

    @Override
    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    @Override
    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    @Override
    public List<Entity> getNearbyEntities(double x, double y, double z) {
        List notchEntityList = this.entity.field_70170_p.func_175674_a(this.entity, this.entity.func_174813_aQ().func_72314_b(x, y, z), null);
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (net.minecraft.entity.Entity e : notchEntityList) {
            bukkitEntityList.add(e.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    @Override
    public int getEntityId() {
        return this.entity.func_145782_y();
    }

    @Override
    public int getFireTicks() {
        return this.entity.field_190534_ay;
    }

    @Override
    public int getMaxFireTicks() {
        return this.entity.func_190531_bD();
    }

    @Override
    public void setFireTicks(int ticks) {
        this.entity.field_190534_ay = ticks;
    }

    @Override
    public void remove() {
        this.entity.func_70106_y();
    }

    public void remove(boolean keepData) {
        this.entity.remove(keepData);
    }

    @Override
    public boolean isDead() {
        return !this.entity.func_70089_S();
    }

    @Override
    public boolean isValid() {
        return this.entity.func_70089_S() && this.entity.valid && this.entity.isChunkLoaded();
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public boolean isPersistent() {
        return this.entity.persist;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.entity.persist = persistent;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    @Override
    public Entity getPassenger() {
        return this.isEmpty() ? null : ((net.minecraft.entity.Entity)this.getHandle().field_184244_h.get(0)).getBukkitEntity();
    }

    @Override
    public boolean setPassenger(Entity passenger) {
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        if (passenger instanceof CraftEntity) {
            this.eject();
            return ((CraftEntity)passenger).getHandle().func_184220_m(this.getHandle());
        }
        return false;
    }

    @Override
    public List<Entity> getPassengers() {
        return Lists.newArrayList((Iterable)Lists.transform((List)this.getHandle().field_184244_h, (Function)new Function<net.minecraft.entity.Entity, Entity>(){

            public Entity apply(net.minecraft.entity.Entity input) {
                return input.getBukkitEntity();
            }
        }));
    }

    @Override
    public boolean addPassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"passenger == null");
        return ((CraftEntity)passenger).getHandle().func_184205_a(this.getHandle(), true);
    }

    @Override
    public boolean removePassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"passenger == null");
        ((CraftEntity)passenger).getHandle().func_184210_p();
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !this.getHandle().func_184207_aI();
    }

    @Override
    public boolean eject() {
        if (this.isEmpty()) {
            return false;
        }
        this.getHandle().func_184226_ay();
        return true;
    }

    @Override
    public float getFallDistance() {
        return this.getHandle().field_70143_R;
    }

    @Override
    public void setFallDistance(float distance) {
        this.getHandle().field_70143_R = distance;
    }

    @Override
    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    @Override
    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    @Override
    public UUID getUniqueId() {
        return this.getHandle().func_110124_au();
    }

    @Override
    public int getTicksLived() {
        return this.getHandle().field_70173_aa;
    }

    @Override
    public void setTicksLived(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Age must be at least 1 tick");
        }
        this.getHandle().field_70173_aa = value;
    }

    public net.minecraft.entity.Entity getHandle() {
        return this.entity;
    }

    @Override
    public void playEffect(EntityEffect type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type");
        if (type.getApplicable().isInstance(this)) {
            this.getHandle().field_70170_p.func_72960_a(this.getHandle(), type.getData());
        }
    }

    public void setHandle(net.minecraft.entity.Entity entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.getHandle() == other.getHandle();
    }

    public int hashCode() {
        return this.getUniqueId().hashCode();
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean isInsideVehicle() {
        return this.getHandle().func_184218_aH();
    }

    @Override
    public boolean leaveVehicle() {
        if (!this.isInsideVehicle()) {
            return false;
        }
        this.getHandle().func_184210_p();
        return true;
    }

    @Override
    public Entity getVehicle() {
        if (!this.isInsideVehicle()) {
            return null;
        }
        return this.getHandle().func_184187_bx().getBukkitEntity();
    }

    @Override
    public void setCustomName(String name) {
        if (name != null && name.length() > 256) {
            name = name.substring(0, 256);
        }
        this.getHandle().func_200203_b(CraftChatMessage.fromStringOrNull(name));
    }

    @Override
    public String getCustomName() {
        ITextComponent name = this.getHandle().func_200201_e();
        if (name == null) {
            return null;
        }
        return CraftChatMessage.fromComponent(name);
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        this.getHandle().func_174805_g(flag);
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.getHandle().func_174833_aM();
    }

    @Override
    public void sendMessage(String message) {
    }

    @Override
    public void sendMessage(String[] messages) {
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        this.sendMessage(message);
    }

    @Override
    public void sendMessage(UUID sender, String[] messages) {
        this.sendMessage(messages);
    }

    @Override
    public String getName() {
        return CraftChatMessage.fromComponent(this.getHandle().func_200200_C_());
    }

    @Override
    public boolean isPermissionSet(String name) {
        return CraftEntity.getPermissibleBase().isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return CraftEntity.getPermissibleBase().isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return CraftEntity.getPermissibleBase().hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return CraftEntity.getPermissibleBase().hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        CraftEntity.getPermissibleBase().removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        CraftEntity.getPermissibleBase().recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return CraftEntity.getPermissibleBase().getEffectivePermissions();
    }

    @Override
    public boolean isOp() {
        return CraftEntity.getPermissibleBase().isOp();
    }

    @Override
    public void setOp(boolean value) {
        CraftEntity.getPermissibleBase().setOp(value);
    }

    @Override
    public void setGlowing(boolean flag) {
        this.getHandle().field_184238_ar = flag;
        net.minecraft.entity.Entity e = this.getHandle();
        if (e.func_70083_f(6) != flag) {
            e.func_70052_a(6, flag);
        }
    }

    @Override
    public boolean isGlowing() {
        return this.getHandle().field_184238_ar;
    }

    @Override
    public void setInvulnerable(boolean flag) {
        this.getHandle().func_184224_h(flag);
    }

    @Override
    public boolean isInvulnerable() {
        return this.getHandle().func_180431_b(DamageSource.field_76377_j);
    }

    @Override
    public boolean isSilent() {
        return this.getHandle().func_174814_R();
    }

    @Override
    public void setSilent(boolean flag) {
        this.getHandle().func_174810_b(flag);
    }

    @Override
    public boolean hasGravity() {
        return !this.getHandle().func_189652_ae();
    }

    @Override
    public void setGravity(boolean gravity) {
        this.getHandle().func_189654_d(!gravity);
    }

    @Override
    public int getPortalCooldown() {
        return this.getHandle().field_242273_aw;
    }

    @Override
    public void setPortalCooldown(int cooldown) {
        this.getHandle().field_242273_aw = cooldown;
    }

    @Override
    public Set<String> getScoreboardTags() {
        return this.getHandle().func_184216_O();
    }

    @Override
    public boolean addScoreboardTag(String tag) {
        return this.getHandle().func_184211_a(tag);
    }

    @Override
    public boolean removeScoreboardTag(String tag) {
        return this.getHandle().func_184197_b(tag);
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(this.getHandle().func_184192_z().ordinal());
    }

    @Override
    public BlockFace getFacing() {
        return CraftBlock.notchToBlockFace(this.getHandle().func_184172_bi());
    }

    @Override
    public CraftPersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    @Override
    public Pose getPose() {
        return Pose.values()[this.getHandle().func_213283_Z().ordinal()];
    }

    public void storeBukkitValues(CompoundNBT c) {
        if (!this.persistentDataContainer.isEmpty()) {
            c.func_218657_a("BukkitValues", (INBT)this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(CompoundNBT c) {
        INBT base = c.func_74781_a("BukkitValues");
        if (base != null) {
            this.persistentDataContainer.putAll((CompoundNBT)base);
        }
    }

    protected CompoundNBT save() {
        CompoundNBT nbttagcompound = new CompoundNBT();
        nbttagcompound.func_74778_a("id", this.getHandle().func_70022_Q());
        this.getHandle().func_189511_e(nbttagcompound);
        return nbttagcompound;
    }

    private static PermissibleBase getPermissibleBase() {
        if (perm == null) {
            perm = new PermissibleBase(new ServerOperator(){

                @Override
                public boolean isOp() {
                    return false;
                }

                @Override
                public void setOp(boolean value) {
                }
            });
        }
        return perm;
    }

    @Override
    public Entity.Spigot spigot() {
        return this.spigot;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    }
}

