/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftProjectile;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;

public class CraftFishHook
extends CraftProjectile
implements FishHook {
    private double biteChance = -1.0;

    public CraftFishHook(CraftServer server, FishingBobberEntity entity) {
        super(server, (ProjectileEntity)entity);
    }

    public FishingBobberEntity getHandle() {
        return (FishingBobberEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFishingHook";
    }

    @Override
    public EntityType getType() {
        return EntityType.FISHING_HOOK;
    }

    @Override
    public int getMinWaitTime() {
        return this.getHandle().minWaitTime;
    }

    @Override
    public void setMinWaitTime(int minWaitTime) {
        FishingBobberEntity hook = this.getHandle();
        Validate.isTrue((minWaitTime >= 0 && minWaitTime <= this.getMaxWaitTime() ? 1 : 0) != 0, (String)"The minimum wait time should be between 0 and the maximum wait time.");
        hook.minWaitTime = minWaitTime;
    }

    @Override
    public int getMaxWaitTime() {
        return this.getHandle().maxWaitTime;
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
        FishingBobberEntity hook = this.getHandle();
        Validate.isTrue((maxWaitTime >= 0 && maxWaitTime >= this.getMinWaitTime() ? 1 : 0) != 0, (String)"The maximum wait time should be higher than or equal to 0 and the minimum wait time.");
        hook.maxWaitTime = maxWaitTime;
    }

    @Override
    public boolean getApplyLure() {
        return this.getHandle().applyLure;
    }

    @Override
    public void setApplyLure(boolean applyLure) {
        this.getHandle().applyLure = applyLure;
    }

    @Override
    public double getBiteChance() {
        FishingBobberEntity hook = this.getHandle();
        if (this.biteChance == -1.0) {
            if (hook.field_70170_p.func_175727_C(new BlockPos(MathHelper.func_76128_c((double)hook.func_226277_ct_()), MathHelper.func_76128_c((double)hook.func_226278_cu_()) + 1, MathHelper.func_76128_c((double)hook.func_226281_cx_())))) {
                return 0.0033333333333333335;
            }
            return 0.002;
        }
        return this.biteChance;
    }

    @Override
    public void setBiteChance(double chance) {
        Validate.isTrue((chance >= 0.0 && chance <= 1.0 ? 1 : 0) != 0, (String)"The bite chance must be between 0 and 1.");
        this.biteChance = chance;
    }

    @Override
    public boolean isInOpenWater() {
        return this.getHandle().func_234605_g_();
    }

    @Override
    public org.bukkit.entity.Entity getHookedEntity() {
        Entity hooked = this.getHandle().field_146043_c;
        return hooked != null ? hooked.getBukkitEntity() : null;
    }

    @Override
    public void setHookedEntity(org.bukkit.entity.Entity entity) {
        FishingBobberEntity hook = this.getHandle();
        hook.field_146043_c = entity != null ? ((CraftEntity)entity).getHandle() : null;
        hook.func_184212_Q().func_187227_b(FishingBobberEntity.field_184528_c, (Object)(hook.field_146043_c != null ? hook.field_146043_c.func_145782_y() + 1 : 0));
    }

    @Override
    public boolean pullHookedEntity() {
        FishingBobberEntity hook = this.getHandle();
        if (hook.field_146043_c == null) {
            return false;
        }
        hook.func_184527_k();
        return true;
    }

    @Override
    public FishHook.HookState getState() {
        String name = String.valueOf(this.getHandle().field_190627_av);
        if (name.equals("FLYING")) {
            return FishHook.HookState.UNHOOKED;
        }
        if (name.equals("HOOKED_IN_ENTITY")) {
            return FishHook.HookState.HOOKED_ENTITY;
        }
        return FishHook.HookState.valueOf(name);
    }
}

