/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.scoreboard;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_16_R3.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_16_R3.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final ScorePlayerTeam team;

    CraftTeam(CraftScoreboard scoreboard, ScorePlayerTeam team) {
        super(scoreboard);
        this.team = team;
    }

    @Override
    public String getName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.func_96661_b();
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.func_96669_c());
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalStateException {
        Validate.notNull((Object)displayName, (String)"Display name cannot be null");
        Validate.isTrue((displayName.length() <= 128 ? 1 : 0) != 0, (String)("Display name '" + displayName + "' is longer than the limit of 128 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.team.func_96664_a(CraftChatMessage.fromString(displayName)[0]);
    }

    @Override
    public String getPrefix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.func_207406_e());
    }

    @Override
    public void setPrefix(String prefix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)prefix, (String)"Prefix cannot be null");
        Validate.isTrue((prefix.length() <= 64 ? 1 : 0) != 0, (String)("Prefix '" + prefix + "' is longer than the limit of 64 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.team.func_207408_a(CraftChatMessage.fromStringOrNull(prefix));
    }

    @Override
    public String getSuffix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.func_207407_f());
    }

    @Override
    public void setSuffix(String suffix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)suffix, (String)"Suffix cannot be null");
        Validate.isTrue((suffix.length() <= 64 ? 1 : 0) != 0, (String)("Suffix '" + suffix + "' is longer than the limit of 64 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.team.func_207409_b(CraftChatMessage.fromStringOrNull(suffix));
    }

    @Override
    public ChatColor getColor() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.getColor(this.team.func_178775_l());
    }

    @Override
    public void setColor(ChatColor color) {
        Validate.notNull((Object)((Object)color), (String)"Color cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        this.team.func_178774_a(CraftChatMessage.getColor(color));
    }

    @Override
    public boolean allowFriendlyFire() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.func_96665_g();
    }

    @Override
    public void setAllowFriendlyFire(boolean enabled) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.func_96660_a(enabled);
    }

    @Override
    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.func_98297_h();
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean enabled) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.func_96660_a(enabled);
    }

    @Override
    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftTeam.notchToBukkit(this.team.func_178770_i());
    }

    @Override
    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.func_178772_a(CraftTeam.bukkitToNotch(visibility));
    }

    @Override
    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.func_96670_d()) {
            players.add((Object)Bukkit.getOfflinePlayer(playerName));
        }
        return players.build();
    }

    @Override
    public Set<String> getEntries() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.func_96670_d()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    @Override
    public int getSize() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.func_96670_d().size();
    }

    @Override
    public void addPlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        this.addEntry(player.getName());
    }

    @Override
    public void addEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.func_197901_a(entry, this.team);
    }

    @Override
    public boolean removePlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        return this.removeEntry(player.getName());
    }

    @Override
    public boolean removeEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        if (!this.team.func_96670_d().contains(entry)) {
            return false;
        }
        scoreboard.board.func_96512_b(entry, this.team);
        return true;
    }

    @Override
    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        return this.hasEntry(player.getName());
    }

    @Override
    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        return this.team.func_96670_d().contains(entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.func_96511_d(this.team);
    }

    @Override
    public Team.OptionStatus getOption(Team.Option option) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.func_178770_i().ordinal()];
            }
            case DEATH_MESSAGE_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.func_178771_j().ordinal()];
            }
            case COLLISION_RULE: {
                return Team.OptionStatus.values()[this.team.func_186681_k().ordinal()];
            }
        }
        throw new IllegalArgumentException("Unrecognised option " + (Object)((Object)option));
    }

    @Override
    public void setOption(Team.Option option, Team.OptionStatus status) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.func_178772_a(Team.Visible.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.func_178773_b(Team.Visible.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.func_186682_a(Team.CollisionRule.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + (Object)((Object)option));
            }
        }
    }

    public static Team.Visible bukkitToNotch(NameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return Team.Visible.ALWAYS;
            }
            case NEVER: {
                return Team.Visible.NEVER;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return Team.Visible.HIDE_FOR_OTHER_TEAMS;
            }
            case HIDE_FOR_OWN_TEAM: {
                return Team.Visible.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + (Object)((Object)visibility));
    }

    public static NameTagVisibility notchToBukkit(Team.Visible visibility) {
        switch (visibility) {
            case ALWAYS: {
                return NameTagVisibility.ALWAYS;
            }
            case NEVER: {
                return NameTagVisibility.NEVER;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case HIDE_FOR_OWN_TEAM: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        if (((CraftScoreboard)this.getScoreboard()).board.func_96508_e(this.team.func_96661_b()) == null) {
            throw new IllegalStateException("Unregistered scoreboard component");
        }
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftTeam other = (CraftTeam)obj;
        return this.team == other.team || this.team != null && this.team.equals(other.team);
    }
}

