/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.util;

import co.aikar.timings.TimingsExport;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.world.storage.FolderName;
import org.bukkit.Bukkit;
import org.bukkit.Fluid;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.UnsafeValues;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.legacy.CraftLegacy;
import org.bukkit.craftbukkit.v1_16_R3.util.Commodore;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;

public final class CraftMagicNumbers
implements UnsafeValues {
    public static final UnsafeValues INSTANCE = new CraftMagicNumbers();
    public static final Map<Block, Material> BLOCK_MATERIAL = new HashMap<Block, Material>();
    public static final Map<Item, Material> ITEM_MATERIAL = new HashMap<Item, Material>();
    private static final Map<net.minecraft.fluid.Fluid, Fluid> FLUID_MATERIAL = new HashMap<net.minecraft.fluid.Fluid, Fluid>();
    public static final Map<Material, Item> MATERIAL_ITEM = new HashMap<Material, Item>();
    public static final Map<Material, Block> MATERIAL_BLOCK = new HashMap<Material, Block>();
    private static final Map<Material, net.minecraft.fluid.Fluid> MATERIAL_FLUID = new HashMap<Material, net.minecraft.fluid.Fluid>();
    public static final int LEGACY_FIRST_POS;
    public static final int LEGACY_LAST_POS;
    private static final List<String> SUPPORTED_API;

    private CraftMagicNumbers() {
    }

    public static BlockState getBlock(MaterialData material) {
        return CraftMagicNumbers.getBlock(material.getItemType(), material.getData());
    }

    public static BlockState getBlock(Material material, byte data) {
        return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
    }

    public static MaterialData getMaterial(BlockState data) {
        return CraftLegacy.toLegacy(CraftMagicNumbers.getMaterial(data.func_177230_c())).getNewData(CraftMagicNumbers.toLegacyData(data));
    }

    public static Item getItem(Material material, short data) {
        if (material.isLegacy()) {
            return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
        }
        return CraftMagicNumbers.getItem(material);
    }

    public static MaterialData getMaterialData(Item item) {
        return CraftLegacy.toLegacyData(CraftMagicNumbers.getMaterial(item));
    }

    public static Material getMaterial(Block block) {
        return BLOCK_MATERIAL.get(block);
    }

    public static Material getMaterial(Item item) {
        return ITEM_MATERIAL.getOrDefault(item, Material.AIR);
    }

    public static Fluid getFluid(net.minecraft.fluid.Fluid fluid) {
        return FLUID_MATERIAL.get(fluid);
    }

    public static Item getItem(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_ITEM.get(material);
    }

    public static Block getBlock(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_BLOCK.get(material);
    }

    public static net.minecraft.fluid.Fluid getFluid(Fluid fluid) {
        return MATERIAL_FLUID.get(fluid);
    }

    public static ResourceLocation key(Material mat) {
        return CraftNamespacedKey.toMinecraft(mat.getKey());
    }

    @Override
    public void reportTimings() {
        TimingsExport.reportTimings();
    }

    public static byte toLegacyData(BlockState data) {
        return CraftLegacy.toLegacyData(data);
    }

    @Override
    public Material toLegacy(Material material) {
        return CraftLegacy.toLegacy(material);
    }

    @Override
    public Material fromLegacy(Material material) {
        return CraftLegacy.fromLegacy(material);
    }

    @Override
    public Material fromLegacy(MaterialData material) {
        return CraftLegacy.fromLegacy(material);
    }

    @Override
    public Material fromLegacy(MaterialData material, boolean itemPriority) {
        return CraftLegacy.fromLegacy(material, itemPriority);
    }

    @Override
    public BlockData fromLegacy(Material material, byte data) {
        return CraftBlockData.fromData(CraftMagicNumbers.getBlock(material, data));
    }

    @Override
    public Material getMaterial(String material, int version) {
        Dynamic converted;
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material == null");
        Preconditions.checkArgument((version <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        if (version == this.getDataVersion()) {
            return Material.getMaterial(material);
        }
        Dynamic name = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)StringNBT.func_229705_a_((String)("minecraft:" + material.toLowerCase(Locale.ROOT))));
        if (name.equals((Object)(converted = DataFixesManager.func_210901_a().update(TypeReferences.field_211301_q, name, version, this.getDataVersion())))) {
            converted = DataFixesManager.func_210901_a().update(TypeReferences.field_211300_p, name, version, this.getDataVersion());
        }
        return Material.matchMaterial(converted.asString(""));
    }

    public String getMappingsVersion() {
        return "54e89c47309b53737f894f1bf1b0edbe";
    }

    @Override
    public int getDataVersion() {
        return SharedConstants.func_215069_a().getWorldVersion();
    }

    @Override
    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        net.minecraft.item.ItemStack nmsStack = CraftItemStack.asNMSCopy(stack);
        try {
            nmsStack.func_77982_d(JsonToNBT.func_180713_a((String)arguments));
        }
        catch (CommandSyntaxException ex) {
            Logger.getLogger(CraftMagicNumbers.class.getName()).log(Level.SEVERE, null, ex);
        }
        stack.setItemMeta(CraftItemStack.getItemMeta(nmsStack));
        return stack;
    }

    private static File getBukkitDataPackFolder() {
        return new File(MinecraftServer.getServer().func_240776_a_(FolderName.field_237251_g_).toFile(), "bukkit");
    }

    @Override
    public Advancement loadAdvancement(NamespacedKey key, String advancement) {
        if (Bukkit.getAdvancement(key) != null) {
            throw new IllegalArgumentException("Advancement " + key + " already exists.");
        }
        ResourceLocation minecraftkey = CraftNamespacedKey.toMinecraft(key);
        JsonElement jsonelement = (JsonElement)AdvancementManager.field_192783_b.fromJson(advancement, JsonElement.class);
        JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)jsonelement, (String)"advancement");
        Advancement.Builder nms = Advancement.Builder.func_241043_a_((JsonObject)jsonobject, (ConditionArrayParser)new ConditionArrayParser(minecraftkey, MinecraftServer.getServer().func_229736_aP_()));
        if (nms != null) {
            MinecraftServer.getServer().func_191949_aK().field_223388_c.func_192083_a((Map)Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
            Advancement bukkit = Bukkit.getAdvancement(key);
            if (bukkit != null) {
                File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
                file.getParentFile().mkdirs();
                try {
                    Files.write((CharSequence)advancement, (File)file, (Charset)Charsets.UTF_8);
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "Error saving advancement " + key, ex);
                }
                MinecraftServer.getServer().func_184103_al().func_193244_w();
                return bukkit;
            }
        }
        return null;
    }

    @Override
    public boolean removeAdvancement(NamespacedKey key) {
        File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
        return file.delete();
    }

    @Override
    public void checkSupported(PluginDescriptionFile pdf) throws InvalidPluginException {
        String minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        int minimumIndex = SUPPORTED_API.indexOf(minimumVersion);
        if (pdf.getAPIVersion() != null) {
            int pluginIndex = SUPPORTED_API.indexOf(pdf.getAPIVersion());
            if (pluginIndex == -1) {
                throw new InvalidPluginException("Unsupported API version " + pdf.getAPIVersion());
            }
            if (pluginIndex < minimumIndex) {
                throw new InvalidPluginException("Plugin API version " + pdf.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
            }
        } else if (minimumIndex == -1) {
            CraftLegacy.init();
            Bukkit.getLogger().log(Level.WARNING, "Legacy plugin " + pdf.getFullName() + " does not specify an api-version.");
        } else {
            throw new InvalidPluginException("Plugin API version " + pdf.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
        }
    }

    public static boolean isLegacy(PluginDescriptionFile pdf) {
        return pdf.getAPIVersion() == null;
    }

    @Override
    public byte[] processClass(PluginDescriptionFile pdf, String path, byte[] clazz) {
        try {
            clazz = Commodore.convert(clazz, !CraftMagicNumbers.isLegacy(pdf));
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Fatal error trying to convert " + pdf.getFullName() + ":" + path, ex);
        }
        return clazz;
    }

    @Override
    public String getTimingsServerName() {
        return "mohist";
    }

    static {
        for (Block block2 : net.minecraft.util.registry.Registry.field_212618_g) {
            BLOCK_MATERIAL.put(block2, Material.getMaterial(net.minecraft.util.registry.Registry.field_212618_g.func_177774_c((Object)block2).func_110623_a().toUpperCase(Locale.ROOT)));
        }
        for (Item item2 : net.minecraft.util.registry.Registry.field_212630_s) {
            ITEM_MATERIAL.put(item2, Material.getMaterial(net.minecraft.util.registry.Registry.field_212630_s.func_177774_c((Object)item2).func_110623_a().toUpperCase(Locale.ROOT)));
        }
        for (net.minecraft.fluid.Fluid fluid2 : net.minecraft.util.registry.Registry.field_212619_h) {
            FLUID_MATERIAL.put(fluid2, Registry.FLUID.get(CraftNamespacedKey.fromMinecraft(net.minecraft.util.registry.Registry.field_212619_h.func_177774_c((Object)fluid2))));
        }
        Integer legacyFirstPos = null;
        Integer legacyLastPos = null;
        for (Material material : Material.values()) {
            if (material.isLegacy()) {
                int ord = material.ordinal();
                if (legacyFirstPos == null) {
                    legacyFirstPos = ord;
                }
                legacyLastPos = ord;
                continue;
            }
            ResourceLocation key = CraftMagicNumbers.key(material);
            net.minecraft.util.registry.Registry.field_212630_s.func_241873_b(key).ifPresent(item -> MATERIAL_ITEM.put(material, (Item)item));
            net.minecraft.util.registry.Registry.field_212618_g.func_241873_b(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (Block)block));
            net.minecraft.util.registry.Registry.field_212619_h.func_241873_b(key).ifPresent(fluid -> MATERIAL_FLUID.put(material, (net.minecraft.fluid.Fluid)fluid));
        }
        LEGACY_FIRST_POS = legacyFirstPos;
        LEGACY_LAST_POS = legacyLastPos;
        SUPPORTED_API = Arrays.asList("1.13", "1.14", "1.15", "1.16");
    }

    public static class NBT {
        public static final int TAG_END = 0;
        public static final int TAG_BYTE = 1;
        public static final int TAG_SHORT = 2;
        public static final int TAG_INT = 3;
        public static final int TAG_LONG = 4;
        public static final int TAG_FLOAT = 5;
        public static final int TAG_DOUBLE = 6;
        public static final int TAG_BYTE_ARRAY = 7;
        public static final int TAG_STRING = 8;
        public static final int TAG_LIST = 9;
        public static final int TAG_COMPOUND = 10;
        public static final int TAG_INT_ARRAY = 11;
        public static final int TAG_ANY_NUMBER = 99;
    }
}

