/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class VineBlock
extends Block {
    public static final BooleanProperty field_176277_a = SixWayBlock.field_196496_z;
    public static final BooleanProperty field_176273_b = SixWayBlock.field_196488_a;
    public static final BooleanProperty field_176278_M = SixWayBlock.field_196490_b;
    public static final BooleanProperty field_176279_N = SixWayBlock.field_196492_c;
    public static final BooleanProperty field_176280_O = SixWayBlock.field_196495_y;
    public static final Map<Direction, BooleanProperty> field_196546_A = SixWayBlock.field_196491_B.entrySet().stream().filter(entry -> entry.getKey() != Direction.DOWN).collect(Util.func_199749_a());
    private static final VoxelShape field_185757_g = Block.func_208617_a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape field_185754_C = Block.func_208617_a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape field_185753_B = Block.func_208617_a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape field_185756_E = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape field_185755_D = Block.func_208617_a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<BlockState, VoxelShape> field_242684_o;

    public VineBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176277_a, false)).func_206870_a(field_176273_b, false)).func_206870_a(field_176278_M, false)).func_206870_a(field_176279_N, false)).func_206870_a(field_176280_O, false));
        this.field_242684_o = ImmutableMap.copyOf(this.field_176227_L.func_177619_a().stream().collect(Collectors.toMap(Function.identity(), VineBlock::func_242685_h)));
    }

    private static VoxelShape func_242685_h(BlockState blockState) {
        VoxelShape voxelShape = VoxelShapes.func_197880_a();
        if (blockState.func_177229_b(field_176277_a).booleanValue()) {
            voxelShape = field_185757_g;
        }
        if (blockState.func_177229_b(field_176273_b).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_185756_E);
        }
        if (blockState.func_177229_b(field_176279_N).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_185755_D);
        }
        if (blockState.func_177229_b(field_176278_M).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_185753_B);
        }
        if (blockState.func_177229_b(field_176280_O).booleanValue()) {
            voxelShape = VoxelShapes.func_197872_a(voxelShape, field_185754_C);
        }
        return voxelShape;
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.field_242684_o.get(blockState);
    }

    @Override
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        return this.func_196543_i(this.func_196545_h(blockState, iWorldReader, blockPos));
    }

    private boolean func_196543_i(BlockState blockState) {
        return this.func_208496_w(blockState) > 0;
    }

    private int func_208496_w(BlockState blockState) {
        int n = 0;
        for (BooleanProperty booleanProperty : field_196546_A.values()) {
            if (!blockState.func_177229_b(booleanProperty).booleanValue()) continue;
            ++n;
        }
        return n;
    }

    private boolean func_196541_a(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        if (direction == Direction.DOWN) {
            return false;
        }
        BlockPos blockPos2 = blockPos.func_177972_a(direction);
        if (VineBlock.func_196542_b(iBlockReader, blockPos2, direction)) {
            return true;
        }
        if (direction.func_176740_k() != Direction.Axis.Y) {
            BooleanProperty booleanProperty = field_196546_A.get(direction);
            BlockState \u26032 = iBlockReader.func_180495_p(blockPos.func_177984_a());
            return \u26032.func_203425_a(this) && \u26032.func_177229_b(booleanProperty) != false;
        }
        return false;
    }

    public static boolean func_196542_b(IBlockReader iBlockReader, BlockPos blockPos, Direction direction) {
        BlockState blockState = iBlockReader.func_180495_p(blockPos);
        return Block.func_208061_a(blockState.func_196952_d(iBlockReader, blockPos), direction.func_176734_d());
    }

    private BlockState func_196545_h(BlockState blockState2, IBlockReader iBlockReader, BlockPos blockPos) {
        BlockState blockState2;
        \u2603 = blockPos.func_177984_a();
        if (blockState2.func_177229_b(field_176277_a).booleanValue()) {
            blockState2 = (BlockState)blockState2.func_206870_a(field_176277_a, VineBlock.func_196542_b(iBlockReader, \u2603, Direction.DOWN));
        }
        AbstractBlock.AbstractBlockState abstractBlockState = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanProperty = VineBlock.func_176267_a(direction);
            if (!blockState2.func_177229_b(booleanProperty).booleanValue()) continue;
            boolean \u26032 = this.func_196541_a(iBlockReader, blockPos, direction);
            if (!\u26032) {
                if (abstractBlockState == null) {
                    abstractBlockState = iBlockReader.func_180495_p(\u2603);
                }
                \u26032 = abstractBlockState.func_203425_a(this) && abstractBlockState.func_177229_b(booleanProperty) != false;
            }
            blockState2 = (BlockState)blockState2.func_206870_a(booleanProperty, \u26032);
        }
        return blockState2;
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN) {
            return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
        }
        BlockState blockState3 = this.func_196545_h(blockState, iWorld, blockPos);
        if (!this.func_196543_i(blockState3)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return blockState3;
    }

    @Override
    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        if (serverWorld.field_73012_v.nextInt(4) != 0) {
            return;
        }
        Direction direction = Direction.func_239631_a_(random);
        BlockPos \u26032 = blockPos.func_177984_a();
        if (direction.func_176740_k().func_176722_c() && !blockState.func_177229_b(VineBlock.func_176267_a(direction)).booleanValue()) {
            if (!this.func_196539_a(serverWorld, blockPos)) {
                return;
            }
            BlockPos blockPos2 = blockPos.func_177972_a(direction);
            BlockState \u26033 = serverWorld.func_180495_p(blockPos2);
            if (\u26033.func_196958_f()) {
                Direction direction2 = direction.func_176746_e();
                \u2603 = direction.func_176735_f();
                boolean \u26034 = blockState.func_177229_b(VineBlock.func_176267_a(direction2));
                boolean \u26035 = blockState.func_177229_b(VineBlock.func_176267_a(\u2603));
                BlockPos \u26036 = blockPos2.func_177972_a(direction2);
                BlockPos \u26037 = blockPos2.func_177972_a(\u2603);
                if (\u26034 && VineBlock.func_196542_b(serverWorld, \u26036, direction2)) {
                    serverWorld.func_180501_a(blockPos2, (BlockState)this.func_176223_P().func_206870_a(VineBlock.func_176267_a(direction2), true), 2);
                } else if (\u26035 && VineBlock.func_196542_b(serverWorld, \u26037, \u2603)) {
                    serverWorld.func_180501_a(blockPos2, (BlockState)this.func_176223_P().func_206870_a(VineBlock.func_176267_a(\u2603), true), 2);
                } else {
                    \u2603 = direction.func_176734_d();
                    if (\u26034 && serverWorld.func_175623_d(\u26036) && VineBlock.func_196542_b(serverWorld, blockPos.func_177972_a(direction2), \u2603)) {
                        serverWorld.func_180501_a(\u26036, (BlockState)this.func_176223_P().func_206870_a(VineBlock.func_176267_a(\u2603), true), 2);
                    } else if (\u26035 && serverWorld.func_175623_d(\u26037) && VineBlock.func_196542_b(serverWorld, blockPos.func_177972_a(\u2603), \u2603)) {
                        serverWorld.func_180501_a(\u26037, (BlockState)this.func_176223_P().func_206870_a(VineBlock.func_176267_a(\u2603), true), 2);
                    } else if ((double)serverWorld.field_73012_v.nextFloat() < 0.05 && VineBlock.func_196542_b(serverWorld, blockPos2.func_177984_a(), Direction.UP)) {
                        serverWorld.func_180501_a(blockPos2, (BlockState)this.func_176223_P().func_206870_a(field_176277_a, true), 2);
                    }
                }
            } else if (VineBlock.func_196542_b(serverWorld, blockPos2, direction)) {
                serverWorld.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(VineBlock.func_176267_a(direction), true), 2);
            }
            return;
        }
        if (direction == Direction.UP && blockPos.func_177956_o() < 255) {
            if (this.func_196541_a(serverWorld, blockPos, direction)) {
                serverWorld.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176277_a, true), 2);
                return;
            }
            if (serverWorld.func_175623_d(\u26032)) {
                if (!this.func_196539_a(serverWorld, blockPos)) {
                    return;
                }
                BlockState \u26038 = blockState;
                for (Direction direction3 : Direction.Plane.HORIZONTAL) {
                    if (!random.nextBoolean() && VineBlock.func_196542_b(serverWorld, \u26032.func_177972_a(direction3), Direction.UP)) continue;
                    \u26038 = (BlockState)\u26038.func_206870_a(VineBlock.func_176267_a(direction3), false);
                }
                if (this.func_196540_x(\u26038)) {
                    serverWorld.func_180501_a(\u26032, \u26038, 2);
                }
                return;
            }
        }
        if (blockPos.func_177956_o() > 0 && ((\u2603 = serverWorld.func_180495_p(\u2603 = blockPos.func_177977_b())).func_196958_f() || \u2603.func_203425_a(this)) && (\u2603 = \u2603.func_196958_f() ? this.func_176223_P() : \u2603) != (\u2603 = this.func_196544_a(blockState, \u2603, random)) && this.func_196540_x(\u2603)) {
            serverWorld.func_180501_a(\u2603, \u2603, 2);
        }
    }

    private BlockState func_196544_a(BlockState blockState, BlockState blockState22, Random random) {
        BlockState blockState22;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!random.nextBoolean() || !blockState.func_177229_b(\u2603 = VineBlock.func_176267_a(direction)).booleanValue()) continue;
            blockState22 = (BlockState)blockState22.func_206870_a(\u2603, true);
        }
        return blockState22;
    }

    private boolean func_196540_x(BlockState blockState) {
        return blockState.func_177229_b(field_176273_b) != false || blockState.func_177229_b(field_176278_M) != false || blockState.func_177229_b(field_176279_N) != false || blockState.func_177229_b(field_176280_O) != false;
    }

    private boolean func_196539_a(IBlockReader iBlockReader, BlockPos blockPos) {
        int n = 4;
        Iterable<BlockPos> \u26032 = BlockPos.func_191531_b(blockPos.func_177958_n() - 4, blockPos.func_177956_o() - 1, blockPos.func_177952_p() - 4, blockPos.func_177958_n() + 4, blockPos.func_177956_o() + 1, blockPos.func_177952_p() + 4);
        \u2603 = 5;
        for (BlockPos blockPos2 : \u26032) {
            if (!iBlockReader.func_180495_p(blockPos2).func_203425_a(this) || --\u2603 > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_196253_a(BlockState blockState, BlockItemUseContext blockItemUseContext) {
        BlockState blockState2 = blockItemUseContext.func_195991_k().func_180495_p(blockItemUseContext.func_195995_a());
        if (blockState2.func_203425_a(this)) {
            return this.func_208496_w(blockState2) < field_196546_A.size();
        }
        return super.func_196253_a(blockState, blockItemUseContext);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        BlockState blockState;
        BlockState blockState2 = blockItemUseContext.func_195991_k().func_180495_p(blockItemUseContext.func_195995_a());
        boolean \u26032 = blockState2.func_203425_a(this);
        blockState = \u26032 ? blockState2 : this.func_176223_P();
        for (Direction direction : blockItemUseContext.func_196009_e()) {
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanProperty = VineBlock.func_176267_a(direction);
            boolean bl = \u2603 = \u26032 && blockState2.func_177229_b(booleanProperty) != false;
            if (\u2603 || !this.func_196541_a(blockItemUseContext.func_195991_k(), blockItemUseContext.func_195995_a(), direction)) continue;
            return (BlockState)blockState.func_206870_a(booleanProperty, true);
        }
        return \u26032 ? blockState : null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176277_a, field_176273_b, field_176278_M, field_176279_N, field_176280_O);
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a(field_176273_b, blockState.func_177229_b(field_176279_N))).func_206870_a(field_176278_M, blockState.func_177229_b(field_176280_O))).func_206870_a(field_176279_N, blockState.func_177229_b(field_176273_b))).func_206870_a(field_176280_O, blockState.func_177229_b(field_176278_M));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a(field_176273_b, blockState.func_177229_b(field_176278_M))).func_206870_a(field_176278_M, blockState.func_177229_b(field_176279_N))).func_206870_a(field_176279_N, blockState.func_177229_b(field_176280_O))).func_206870_a(field_176280_O, blockState.func_177229_b(field_176273_b));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState.func_206870_a(field_176273_b, blockState.func_177229_b(field_176280_O))).func_206870_a(field_176278_M, blockState.func_177229_b(field_176273_b))).func_206870_a(field_176279_N, blockState.func_177229_b(field_176278_M))).func_206870_a(field_176280_O, blockState.func_177229_b(field_176279_N));
            }
        }
        return blockState;
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)blockState.func_206870_a(field_176273_b, blockState.func_177229_b(field_176279_N))).func_206870_a(field_176279_N, blockState.func_177229_b(field_176273_b));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)blockState.func_206870_a(field_176278_M, blockState.func_177229_b(field_176280_O))).func_206870_a(field_176280_O, blockState.func_177229_b(field_176278_M));
            }
        }
        return super.func_185471_a(blockState, mirror);
    }

    public static BooleanProperty func_176267_a(Direction direction) {
        return field_196546_A.get(direction);
    }
}

