/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.crash;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashReport {
    private static final Logger field_147150_a = LogManager.getLogger();
    private final String field_71513_a;
    private final Throwable field_71511_b;
    private final CrashReportCategory field_85061_c = new CrashReportCategory(this, "System Details");
    private final List<CrashReportCategory> field_71512_c = Lists.newArrayList();
    private File field_71510_d;
    private boolean field_85059_f = true;
    private StackTraceElement[] field_85060_g = new StackTraceElement[0];

    public CrashReport(String string, Throwable throwable) {
        this.field_71513_a = string;
        this.field_71511_b = throwable;
        this.func_71504_g();
    }

    private void func_71504_g() {
        this.field_85061_c.func_189529_a("Minecraft Version", () -> SharedConstants.func_215069_a().getName());
        this.field_85061_c.func_189529_a("Minecraft Version ID", () -> SharedConstants.func_215069_a().getId());
        this.field_85061_c.func_189529_a("Operating System", () -> System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        this.field_85061_c.func_189529_a("Java Version", () -> System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        this.field_85061_c.func_189529_a("Java VM Version", () -> System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        this.field_85061_c.func_189529_a("Memory", () -> {
            Runtime runtime = Runtime.getRuntime();
            long \u26032 = runtime.maxMemory();
            long \u26033 = runtime.totalMemory();
            long \u26034 = runtime.freeMemory();
            long \u26035 = \u26032 / 1024L / 1024L;
            long \u26036 = \u26033 / 1024L / 1024L;
            long \u26037 = \u26034 / 1024L / 1024L;
            return \u26034 + " bytes (" + \u26037 + " MB) / " + \u26033 + " bytes (" + \u26036 + " MB) up to " + \u26032 + " bytes (" + \u26035 + " MB)";
        });
        this.field_85061_c.func_71507_a("CPUs", Runtime.getRuntime().availableProcessors());
        this.field_85061_c.func_189529_a("JVM Flags", () -> {
            List list = Util.func_211565_f().collect(Collectors.toList());
            return String.format("%d total; %s", list.size(), list.stream().collect(Collectors.joining(" ")));
        });
    }

    public String func_71501_a() {
        return this.field_71513_a;
    }

    public Throwable func_71505_b() {
        return this.field_71511_b;
    }

    public void func_71506_a(StringBuilder stringBuilder2) {
        StringBuilder stringBuilder2;
        if (!(this.field_85060_g != null && this.field_85060_g.length > 0 || this.field_71512_c.isEmpty())) {
            this.field_85060_g = (StackTraceElement[])ArrayUtils.subarray((Object[])this.field_71512_c.get(0).func_147152_a(), (int)0, (int)1);
        }
        if (this.field_85060_g != null && this.field_85060_g.length > 0) {
            stringBuilder2.append("-- Head --\n");
            stringBuilder2.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            stringBuilder2.append("Stacktrace:\n");
            for (StackTraceElement stackTraceElement : this.field_85060_g) {
                stringBuilder2.append("\t").append("at ").append(stackTraceElement);
                stringBuilder2.append("\n");
            }
            stringBuilder2.append("\n");
        }
        for (CrashReportCategory crashReportCategory : this.field_71512_c) {
            crashReportCategory.func_85072_a(stringBuilder2);
            stringBuilder2.append("\n\n");
        }
        this.field_85061_c.func_85072_a(stringBuilder2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String func_71498_d() {
        String string;
        StringWriter stringWriter = null;
        PrintWriter \u26032 = null;
        Throwable \u26033 = this.field_71511_b;
        if (\u26033.getMessage() == null) {
            if (\u26033 instanceof NullPointerException) {
                \u26033 = new NullPointerException(this.field_71513_a);
            } else if (\u26033 instanceof StackOverflowError) {
                \u26033 = new StackOverflowError(this.field_71513_a);
            } else if (\u26033 instanceof OutOfMemoryError) {
                \u26033 = new OutOfMemoryError(this.field_71513_a);
            }
            \u26033.setStackTrace(this.field_71511_b.getStackTrace());
        }
        try {
            stringWriter = new StringWriter();
            \u26032 = new PrintWriter(stringWriter);
            \u26033.printStackTrace(\u26032);
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Writer)stringWriter);
            IOUtils.closeQuietly(\u26032);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)stringWriter);
        IOUtils.closeQuietly((Writer)\u26032);
        return string;
    }

    public String func_71502_e() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---- Minecraft Crash Report ----\n");
        stringBuilder.append("// ");
        stringBuilder.append(CrashReport.func_71503_h());
        stringBuilder.append("\n\n");
        stringBuilder.append("Time: ");
        stringBuilder.append(new SimpleDateFormat().format(new Date()));
        stringBuilder.append("\n");
        stringBuilder.append("Description: ");
        stringBuilder.append(this.field_71513_a);
        stringBuilder.append("\n\n");
        stringBuilder.append(this.func_71498_d());
        stringBuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i = 0; i < 87; ++i) {
            stringBuilder.append("-");
        }
        stringBuilder.append("\n\n");
        this.func_71506_a(stringBuilder);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_147149_a(File file) {
        boolean bl;
        if (this.field_71510_d != null) {
            return false;
        }
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            outputStreamWriter.write(this.func_71502_e());
            this.field_71510_d = file;
            bl = true;
        }
        catch (Throwable \u26032) {
            boolean bl2;
            try {
                field_147150_a.error("Could not save crash report to {}", (Object)file, (Object)\u26032);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)outputStreamWriter);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
        return bl;
    }

    public CrashReportCategory func_85056_g() {
        return this.field_85061_c;
    }

    public CrashReportCategory func_85058_a(String string) {
        return this.func_85057_a(string, 1);
    }

    public CrashReportCategory func_85057_a(String string, int n) {
        CrashReportCategory crashReportCategory = new CrashReportCategory(this, string);
        if (this.field_85059_f) {
            int n2 = crashReportCategory.func_85073_a(n);
            StackTraceElement[] \u26032 = this.field_71511_b.getStackTrace();
            StackTraceElement \u26033 = null;
            StackTraceElement \u26034 = null;
            \u2603 = \u26032.length - n2;
            if (\u2603 < 0) {
                System.out.println("Negative index in crash report handler (" + \u26032.length + "/" + n2 + ")");
            }
            if (\u26032 != null && 0 <= \u2603 && \u2603 < \u26032.length) {
                \u26033 = \u26032[\u2603];
                if (\u26032.length + 1 - n2 < \u26032.length) {
                    \u26034 = \u26032[\u26032.length + 1 - n2];
                }
            }
            this.field_85059_f = crashReportCategory.func_85069_a(\u26033, \u26034);
            if (n2 > 0 && !this.field_71512_c.isEmpty()) {
                CrashReportCategory crashReportCategory2 = this.field_71512_c.get(this.field_71512_c.size() - 1);
                crashReportCategory2.func_85070_b(n2);
            } else if (\u26032 != null && \u26032.length >= n2 && 0 <= \u2603 && \u2603 < \u26032.length) {
                this.field_85060_g = new StackTraceElement[\u2603];
                System.arraycopy(\u26032, 0, this.field_85060_g, 0, this.field_85060_g.length);
            } else {
                this.field_85059_f = false;
            }
        }
        this.field_71512_c.add(crashReportCategory);
        return crashReportCategory;
    }

    private static String func_71503_h() {
        String[] stringArray = new String[]{"Who set us up the TNT?", "Everything's going to plan. No, really, that was supposed to happen.", "Uh... Did I do that?", "Oops.", "Why did you do that?", "I feel sad now :(", "My bad.", "I'm sorry, Dave.", "I let you down. Sorry :(", "On the bright side, I bought you a teddy bear!", "Daisy, daisy...", "Oh - I know what I did wrong!", "Hey, that tickles! Hehehe!", "I blame Dinnerbone.", "You should try our sister game, Minceraft!", "Don't be sad. I'll do better next time, I promise!", "Don't be sad, have a hug! <3", "I just don't know what went wrong :(", "Shall we play a game?", "Quite honestly, I wouldn't worry myself about that.", "I bet Cylons wouldn't have this problem.", "Sorry :(", "Surprise! Haha. Well, this is awkward.", "Would you like a cupcake?", "Hi. I'm Minecraft, and I'm a crashaholic.", "Ooh. Shiny.", "This doesn't make any sense!", "Why is it breaking :(", "Don't do that.", "Ouch. That hurt :(", "You're mean.", "This is a token for 1 free hug. Redeem at your nearest Mojangsta: [~~HUG~~]", "There are four lights!", "But it works on my machine."};
        try {
            return stringArray[(int)(Util.func_211178_c() % (long)stringArray.length)];
        }
        catch (Throwable \u26032) {
            return "Witty comment unavailable :(";
        }
    }

    public static CrashReport func_85055_a(Throwable throwable2, String string) {
        Throwable throwable2;
        while (throwable2 instanceof CompletionException && throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        CrashReport \u26032 = throwable2 instanceof ReportedException ? ((ReportedException)throwable2).func_71575_a() : new CrashReport(string, throwable2);
        return \u26032;
    }

    public static void func_230188_h_() {
        new CrashReport("Don't panic!", new Throwable()).func_71502_e();
    }
}

