/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.world.server.ServerWorld;

public class InteractWithEntityTask<E extends LivingEntity, T extends LivingEntity>
extends Task<E> {
    private final int field_220446_a;
    private final float field_220447_b;
    private final EntityType<? extends T> field_220448_c;
    private final int field_220449_d;
    private final Predicate<T> field_220450_e;
    private final Predicate<E> field_220451_f;
    private final MemoryModuleType<T> field_220452_g;

    public InteractWithEntityTask(EntityType<? extends T> entityType, int n, Predicate<E> predicate, Predicate<T> predicate2, MemoryModuleType<T> memoryModuleType, float f, int n2) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of(MemoryModuleType.field_220951_l, (Object)((Object)MemoryModuleStatus.REGISTERED), MemoryModuleType.field_220950_k, (Object)((Object)MemoryModuleStatus.VALUE_ABSENT), MemoryModuleType.field_220946_g, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT)));
        this.field_220448_c = entityType;
        this.field_220447_b = f;
        this.field_220449_d = n * n;
        this.field_220446_a = n2;
        this.field_220450_e = predicate2;
        this.field_220451_f = predicate;
        this.field_220452_g = memoryModuleType;
    }

    public static <T extends LivingEntity> InteractWithEntityTask<LivingEntity, T> func_220445_a(EntityType<? extends T> entityType, int n, MemoryModuleType<T> memoryModuleType, float f, int n2) {
        return new InteractWithEntityTask<LivingEntity, LivingEntity>(entityType, n, livingEntity -> true, livingEntity -> true, memoryModuleType, f, n2);
    }

    @Override
    protected boolean func_212832_a_(ServerWorld serverWorld, E e) {
        return this.field_220451_f.test(e) && this.func_233913_a_(e);
    }

    private boolean func_233913_a_(E e) {
        List<LivingEntity> list = ((LivingEntity)e).func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g).get();
        return list.stream().anyMatch(this::func_233914_b_);
    }

    private boolean func_233914_b_(LivingEntity livingEntity) {
        return this.field_220448_c.equals(livingEntity.func_200600_R()) && this.field_220450_e.test(livingEntity);
    }

    @Override
    protected void func_212831_a_(ServerWorld serverWorld, E e, long l) {
        Brain<?> brain = ((LivingEntity)e).func_213375_cj();
        brain.func_218207_c(MemoryModuleType.field_220946_g).ifPresent(list -> list.stream().filter(livingEntity -> this.field_220448_c.equals(livingEntity.func_200600_R())).map(livingEntity -> livingEntity).filter(livingEntity2 -> livingEntity2.func_70068_e((Entity)e) <= (double)this.field_220449_d).filter(this.field_220450_e).findFirst().ifPresent(livingEntity -> {
            brain.func_218205_a(this.field_220452_g, livingEntity);
            brain.func_218205_a(MemoryModuleType.field_220951_l, new EntityPosWrapper((Entity)livingEntity, true));
            brain.func_218205_a(MemoryModuleType.field_220950_k, new WalkTarget(new EntityPosWrapper((Entity)livingEntity, false), this.field_220447_b, this.field_220446_a));
        }));
    }
}

