/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.BoostHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PigEntity
extends AnimalEntity
implements IRideable,
IEquipable {
    private static final DataParameter<Boolean> field_184763_bv = EntityDataManager.func_187226_a(PigEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_191520_bx = EntityDataManager.func_187226_a(PigEntity.class, DataSerializers.field_187192_b);
    private static final Ingredient field_184764_bw = Ingredient.func_199804_a(Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV);
    private final BoostHelper field_234214_bx_;

    public PigEntity(EntityType<? extends PigEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
        this.field_234214_bx_ = new BoostHelper(this.field_70180_af, field_191520_bx, field_184763_bv);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new PanicGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(3, new BreedGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a(Items.field_151146_bM), false));
        this.field_70714_bg.func_75776_a(4, new TemptGoal((CreatureEntity)this, 1.2, false, field_184764_bw));
        this.field_70714_bg.func_75776_a(5, new FollowParentGoal(this, 1.1));
        this.field_70714_bg.func_75776_a(6, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
    }

    public static AttributeModifierMap.MutableAttribute func_234215_eI_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        if (this.func_184188_bt().isEmpty()) {
            return null;
        }
        return this.func_184188_bt().get(0);
    }

    @Override
    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity \u26032 = (PlayerEntity)entity;
        return \u26032.func_184614_ca().func_77973_b() == Items.field_151146_bM || \u26032.func_184592_cb().func_77973_b() == Items.field_151146_bM;
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_191520_bx.equals(dataParameter) && this.field_70170_p.field_72995_K) {
            this.field_234214_bx_.func_233616_a_();
        }
        super.func_184206_a(dataParameter);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184763_bv, false);
        this.field_70180_af.func_187214_a(field_191520_bx, 0);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        this.field_234214_bx_.func_233618_a_(compoundNBT);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.field_234214_bx_.func_233621_b_(compoundNBT);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187703_dN;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand hand) {
        boolean bl = this.func_70877_b(playerEntity.func_184586_b(hand));
        if (!bl && this.func_110257_ck() && !this.func_184207_aI() && !playerEntity.func_226563_dT_()) {
            if (!this.field_70170_p.field_72995_K) {
                playerEntity.func_184220_m(this);
            }
            return ActionResultType.func_233537_a_(this.field_70170_p.field_72995_K);
        }
        ActionResultType \u26032 = super.func_230254_b_(playerEntity, hand);
        if (!\u26032.func_226246_a_()) {
            ItemStack itemStack = playerEntity.func_184586_b(hand);
            if (itemStack.func_77973_b() == Items.field_151141_av) {
                return itemStack.func_111282_a_(playerEntity, this, hand);
            }
            return ActionResultType.PASS;
        }
        return \u26032;
    }

    @Override
    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_();
    }

    @Override
    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.func_110257_ck()) {
            this.func_199703_a(Items.field_151141_av);
        }
    }

    @Override
    public boolean func_110257_ck() {
        return this.field_234214_bx_.func_233620_b_();
    }

    @Override
    public void func_230266_a_(@Nullable SoundCategory soundCategory) {
        this.field_234214_bx_.func_233619_a_(true);
        if (soundCategory != null) {
            this.field_70170_p.func_217384_a(null, this, SoundEvents.field_187706_dO, soundCategory, 0.5f, 1.0f);
        }
    }

    @Override
    public Vector3d func_230268_c_(LivingEntity livingEntity2) {
        LivingEntity livingEntity2;
        Direction direction = this.func_184172_bi();
        if (direction.func_176740_k() == Direction.Axis.Y) {
            return super.func_230268_c_(livingEntity2);
        }
        int[][] \u26032 = TransportationHelper.func_234632_a_(direction);
        BlockPos \u26033 = this.func_233580_cy_();
        BlockPos.Mutable \u26034 = new BlockPos.Mutable();
        for (Pose pose : livingEntity2.func_230297_ef_()) {
            AxisAlignedBB axisAlignedBB = livingEntity2.func_233648_f_(pose);
            for (int[] nArray : \u26032) {
                \u26034.func_181079_c(\u26033.func_177958_n() + nArray[0], \u26033.func_177956_o(), \u26033.func_177952_p() + nArray[1]);
                double d = this.field_70170_p.func_242403_h(\u26034);
                if (!TransportationHelper.func_234630_a_(d) || !TransportationHelper.func_234631_a_(this.field_70170_p, livingEntity2, axisAlignedBB.func_191194_a(\u2603 = Vector3d.func_237490_a_(\u26034, d)))) continue;
                livingEntity2.func_213301_b(pose);
                return \u2603;
            }
        }
        return super.func_230268_c_(livingEntity2);
    }

    @Override
    public void func_241841_a(ServerWorld serverWorld2, LightningBoltEntity lightningBoltEntity) {
        if (serverWorld2.func_175659_aa() != Difficulty.PEACEFUL) {
            ZombifiedPiglinEntity zombifiedPiglinEntity = EntityType.field_233592_ba_.func_200721_a(serverWorld2);
            zombifiedPiglinEntity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151010_B));
            zombifiedPiglinEntity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            zombifiedPiglinEntity.func_94061_f(this.func_175446_cd());
            zombifiedPiglinEntity.func_82227_f(this.func_70631_g_());
            if (this.func_145818_k_()) {
                zombifiedPiglinEntity.func_200203_b(this.func_200201_e());
                zombifiedPiglinEntity.func_174805_g(this.func_174833_aM());
            }
            zombifiedPiglinEntity.func_110163_bv();
            serverWorld2.func_217376_c(zombifiedPiglinEntity);
            this.func_70106_y();
        } else {
            ServerWorld serverWorld2;
            super.func_241841_a(serverWorld2, lightningBoltEntity);
        }
    }

    @Override
    public void func_213352_e(Vector3d vector3d) {
        this.func_233622_a_(this, this.field_234214_bx_, vector3d);
    }

    @Override
    public float func_230265_N__() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_) * 0.225f;
    }

    @Override
    public void func_230267_a__(Vector3d vector3d) {
        super.func_213352_e(vector3d);
    }

    @Override
    public boolean func_184762_da() {
        return this.field_234214_bx_.func_233617_a_(this.func_70681_au());
    }

    @Override
    public PigEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return EntityType.field_200784_X.func_200721_a(serverWorld);
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return field_184764_bw.test(itemStack);
    }

    @Override
    public /* synthetic */ AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return this.func_241840_a(serverWorld, ageableEntity);
    }
}

