/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LecternBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.WritableBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.World;

public class WrittenBookItem
extends Item {
    public WrittenBookItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean func_77828_a(@Nullable CompoundNBT compoundNBT) {
        if (!WritableBookItem.func_150930_a(compoundNBT)) {
            return false;
        }
        if (!compoundNBT.func_150297_b("title", 8)) {
            return false;
        }
        String string = compoundNBT.func_74779_i("title");
        if (string.length() > 32) {
            return false;
        }
        return compoundNBT.func_150297_b("author", 8);
    }

    public static int func_179230_h(ItemStack itemStack) {
        return itemStack.func_77978_p().func_74762_e("generation");
    }

    public static int func_220049_j(ItemStack itemStack) {
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        return compoundNBT != null ? compoundNBT.func_150295_c("pages", 8).size() : 0;
    }

    @Override
    public ITextComponent func_200295_i(ItemStack itemStack) {
        if (itemStack.func_77942_o() && !StringUtils.func_151246_b(\u2603 = (\u2603 = itemStack.func_77978_p()).func_74779_i("title"))) {
            return new StringTextComponent(\u2603);
        }
        return super.func_200295_i(itemStack);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext itemUseContext) {
        World world = itemUseContext.func_195991_k();
        BlockState \u26032 = world.func_180495_p(\u2603 = itemUseContext.func_195995_a());
        if (\u26032.func_203425_a(Blocks.field_222428_lQ)) {
            return LecternBlock.func_220151_a(world, \u2603, \u26032, itemUseContext.func_195996_i()) ? ActionResultType.func_233537_a_(world.field_72995_K) : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        playerEntity.func_184814_a(itemStack, hand);
        playerEntity.func_71029_a(Stats.field_75929_E.func_199076_b(this));
        return ActionResult.func_233538_a_(itemStack, world.func_201670_d());
    }

    public static boolean func_220050_a(ItemStack itemStack, @Nullable CommandSource commandSource, @Nullable PlayerEntity playerEntity) {
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        if (compoundNBT == null || compoundNBT.func_74767_n("resolved")) {
            return false;
        }
        compoundNBT.func_74757_a("resolved", true);
        if (!WrittenBookItem.func_77828_a(compoundNBT)) {
            return false;
        }
        ListNBT \u26032 = compoundNBT.func_150295_c("pages", 8);
        for (int i = 0; i < \u26032.size(); ++i) {
            IFormattableTextComponent iFormattableTextComponent;
            String string = \u26032.func_150307_f(i);
            try {
                iFormattableTextComponent = ITextComponent.Serializer.func_240644_b_(string);
                iFormattableTextComponent = TextComponentUtils.func_240645_a_(commandSource, iFormattableTextComponent, playerEntity, 0);
            }
            catch (Exception exception) {
                iFormattableTextComponent = new StringTextComponent(string);
            }
            \u26032.set(i, StringNBT.func_229705_a_(ITextComponent.Serializer.func_150696_a(iFormattableTextComponent)));
        }
        compoundNBT.func_218657_a("pages", \u26032);
        return true;
    }

    @Override
    public boolean func_77636_d(ItemStack itemStack) {
        return true;
    }
}

