/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class UserList<K, V extends UserListEntry<K>> {
    protected static final Logger field_152693_a = LogManager.getLogger();
    private static final Gson field_232645_b_ = new GsonBuilder().setPrettyPrinting().create();
    private final File field_152695_c;
    private final Map<String, V> field_152696_d = Maps.newHashMap();

    public UserList(File file) {
        this.field_152695_c = file;
    }

    public File func_152691_c() {
        return this.field_152695_c;
    }

    public void func_152687_a(V v) {
        this.field_152696_d.put(this.func_152681_a(((UserListEntry)v).func_152640_f()), v);
        try {
            this.func_152678_f();
        }
        catch (IOException iOException) {
            field_152693_a.warn("Could not save the list after adding a user.", (Throwable)iOException);
        }
    }

    @Nullable
    public V func_152683_b(K k) {
        this.func_152680_h();
        return (V)((UserListEntry)this.field_152696_d.get(this.func_152681_a(k)));
    }

    public void func_152684_c(K k) {
        this.field_152696_d.remove(this.func_152681_a(k));
        try {
            this.func_152678_f();
        }
        catch (IOException iOException) {
            field_152693_a.warn("Could not save the list after removing a user.", (Throwable)iOException);
        }
    }

    public void func_199042_b(UserListEntry<K> userListEntry) {
        this.func_152684_c(userListEntry.func_152640_f());
    }

    public String[] func_152685_a() {
        return this.field_152696_d.keySet().toArray(new String[this.field_152696_d.size()]);
    }

    public boolean func_152690_d() {
        return this.field_152696_d.size() < 1;
    }

    protected String func_152681_a(K k) {
        return k.toString();
    }

    protected boolean func_152692_d(K k) {
        return this.field_152696_d.containsKey(this.func_152681_a(k));
    }

    private void func_152680_h() {
        ArrayList arrayList = Lists.newArrayList();
        for (Object \u26032 : this.field_152696_d.values()) {
            if (!((UserListEntry)\u26032).func_73682_e()) continue;
            arrayList.add(((UserListEntry)\u26032).func_152640_f());
        }
        for (Object \u26032 : arrayList) {
            this.field_152696_d.remove(this.func_152681_a(\u26032));
        }
    }

    protected abstract UserListEntry<K> func_152682_a(JsonObject var1);

    public Collection<V> func_199043_f() {
        return this.field_152696_d.values();
    }

    public void func_152678_f() throws IOException {
        JsonArray jsonArray = new JsonArray();
        this.field_152696_d.values().stream().map(userListEntry -> Util.func_200696_a(new JsonObject(), userListEntry::func_152641_a)).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        try (BufferedWriter \u26032 = Files.newWriter((File)this.field_152695_c, (Charset)StandardCharsets.UTF_8);){
            field_232645_b_.toJson((JsonElement)jsonArray, (Appendable)\u26032);
        }
    }

    public void func_152679_g() throws IOException {
        if (!this.field_152695_c.exists()) {
            return;
        }
        try (BufferedReader bufferedReader = Files.newReader((File)this.field_152695_c, (Charset)StandardCharsets.UTF_8);){
            JsonArray jsonArray = (JsonArray)field_232645_b_.fromJson((Reader)bufferedReader, JsonArray.class);
            this.field_152696_d.clear();
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "entry");
                UserListEntry<K> \u26032 = this.func_152682_a(jsonObject);
                if (\u26032.func_152640_f() == null) continue;
                this.field_152696_d.put(this.func_152681_a(\u26032.func_152640_f()), \u26032);
            }
        }
    }
}

