/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ITickList;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.TickPriority;

public class SerializableTickList<T>
implements ITickList<T> {
    private final List<TickHolder<T>> field_219500_a;
    private final Function<T, ResourceLocation> field_219501_b;

    public SerializableTickList(Function<T, ResourceLocation> function, List<NextTickListEntry<T>> list, long l) {
        this(function, list.stream().map(nextTickListEntry -> new TickHolder(nextTickListEntry.func_151351_a(), nextTickListEntry.field_180282_a, (int)(nextTickListEntry.field_235017_b_ - l), nextTickListEntry.field_82754_f)).collect(Collectors.toList()));
    }

    private SerializableTickList(Function<T, ResourceLocation> function, List<TickHolder<T>> list) {
        this.field_219500_a = list;
        this.field_219501_b = function;
    }

    @Override
    public boolean func_205359_a(BlockPos blockPos, T t) {
        return false;
    }

    @Override
    public void func_205362_a(BlockPos blockPos, T t, int n, TickPriority tickPriority) {
        this.field_219500_a.add(new TickHolder(t, blockPos, n, tickPriority));
    }

    @Override
    public boolean func_205361_b(BlockPos blockPos, T t) {
        return false;
    }

    public ListNBT func_234857_b_() {
        ListNBT listNBT = new ListNBT();
        for (TickHolder<T> tickHolder : this.field_219500_a) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74778_a("i", this.field_219501_b.apply(((TickHolder)tickHolder).field_234861_d_).toString());
            compoundNBT.func_74768_a("x", tickHolder.field_234858_a_.func_177958_n());
            compoundNBT.func_74768_a("y", tickHolder.field_234858_a_.func_177956_o());
            compoundNBT.func_74768_a("z", tickHolder.field_234858_a_.func_177952_p());
            compoundNBT.func_74768_a("t", tickHolder.field_234859_b_);
            compoundNBT.func_74768_a("p", tickHolder.field_234860_c_.func_205398_a());
            listNBT.add(compoundNBT);
        }
        return listNBT;
    }

    public static <T> SerializableTickList<T> func_222984_a(ListNBT listNBT, Function<T, ResourceLocation> function, Function<ResourceLocation, T> function2) {
        ArrayList arrayList = Lists.newArrayList();
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compoundNBT = listNBT.func_150305_b(i);
            T \u26032 = function2.apply(new ResourceLocation(compoundNBT.func_74779_i("i")));
            if (\u26032 == null) continue;
            BlockPos \u26033 = new BlockPos(compoundNBT.func_74762_e("x"), compoundNBT.func_74762_e("y"), compoundNBT.func_74762_e("z"));
            arrayList.add(new TickHolder(\u26032, \u26033, compoundNBT.func_74762_e("t"), TickPriority.func_205397_a(compoundNBT.func_74762_e("p"))));
        }
        return new SerializableTickList<T>(function, arrayList);
    }

    public void func_234855_a_(ITickList<T> iTickList) {
        this.field_219500_a.forEach(tickHolder -> iTickList.func_205362_a(tickHolder.field_234858_a_, ((TickHolder)tickHolder).field_234861_d_, tickHolder.field_234859_b_, tickHolder.field_234860_c_));
    }

    static class TickHolder<T> {
        private final T field_234861_d_;
        public final BlockPos field_234858_a_;
        public final int field_234859_b_;
        public final TickPriority field_234860_c_;

        private TickHolder(T t, BlockPos blockPos, int n, TickPriority tickPriority) {
            this.field_234861_d_ = t;
            this.field_234858_a_ = blockPos;
            this.field_234859_b_ = n;
            this.field_234860_c_ = tickPriority;
        }

        public String toString() {
            return this.field_234861_d_ + ": " + this.field_234858_a_ + ", " + this.field_234859_b_ + ", " + (Object)((Object)this.field_234860_c_);
        }
    }
}

