/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installertools;

import de.siegmar.fastcsv.reader.CsvContainer;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraftforge.installertools.Task;
import net.minecraftforge.installertools.util.Utils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class SrgMcpRenamer
extends Task {
    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec mcpO = parser.accepts("mcp").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec inputO = parser.accepts("input").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        parser.accepts("strip-signatures");
        try {
            OptionSet options = parser.parse(args);
            File mcp = ((File)options.valueOf((OptionSpec)mcpO)).getAbsoluteFile();
            File input = ((File)options.valueOf((OptionSpec)inputO)).getAbsoluteFile();
            File output = ((File)options.valueOf((OptionSpec)outputO)).getAbsoluteFile();
            boolean stripSignatures = options.has("strip-signatures");
            this.log("Input:  " + input);
            this.log("Output: " + output);
            this.log("MCP:    " + mcp);
            if (!mcp.exists()) {
                this.error("Missing required MCP data: " + mcp);
            }
            if (!input.exists()) {
                this.error("Missing required input jar: " + input);
            }
            if (output.exists()) {
                output.delete();
            }
            if (!output.getParentFile().exists()) {
                output.getParentFile().mkdirs();
            }
            output.createNewFile();
            this.log("Loading MCP Data");
            final HashMap<String, String> map = new HashMap<String, String>();
            try (ZipFile zip = new ZipFile(mcp);){
                List entries = zip.stream().filter(e -> e.getName().endsWith(".csv")).collect(Collectors.toList());
                for (ZipEntry entry : entries) {
                    CsvReader reader = new CsvReader();
                    reader.setContainsHeader(true);
                    CsvContainer csv = reader.read((Reader)new InputStreamReader(zip.getInputStream(entry)));
                    for (CsvRow row : csv.getRows()) {
                        String searge = row.getField("searge");
                        if (searge == null) {
                            searge = row.getField("param");
                        }
                        map.put(searge, row.getField("name"));
                    }
                }
            }
            Remapper remapper = new Remapper(){

                public String mapFieldName(String owner, String name, String descriptor) {
                    return map.getOrDefault(name, name);
                }

                public String mapInvokeDynamicMethodName(String name, String descriptor) {
                    return map.getOrDefault(name, name);
                }

                public String mapMethodName(String owner, String name, String descriptor) {
                    return map.getOrDefault(name, name);
                }
            };
            ByteArrayOutputStream memory = input.equals(output) ? new ByteArrayOutputStream() : null;
            ZipOutputStream zout = new ZipOutputStream(memory == null ? new FileOutputStream(output) : memory);
            Object object = null;
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(input));){
                ZipEntry ein = null;
                while ((ein = zin.getNextEntry()) != null) {
                    if (ein.getName().endsWith(".class")) {
                        byte[] data = Utils.toByteArray(zin);
                        ClassReader reader = new ClassReader(data);
                        ClassWriter writer = new ClassWriter(0);
                        reader.accept((ClassVisitor)new ClassRemapper((ClassVisitor)writer, remapper), 0);
                        data = writer.toByteArray();
                        ZipEntry eout = new ZipEntry(ein.getName());
                        eout.setTime(946684800L);
                        zout.putNextEntry(eout);
                        zout.write(data);
                        continue;
                    }
                    if (stripSignatures && ein.getName().startsWith("META-INF/") && (ein.getName().endsWith(".SF") || ein.getName().endsWith(".RSA"))) {
                        this.log("Stripped signature entry data " + ein.getName());
                        continue;
                    }
                    if (stripSignatures && ein.getName().endsWith("META-INF/MANIFEST.MF")) {
                        Manifest min = new Manifest(zin);
                        Manifest mout = new Manifest();
                        mout.getMainAttributes().putAll((Map<?, ?>)min.getMainAttributes());
                        min.getEntries().forEach((name, ain) -> {
                            Attributes aout = new Attributes();
                            ain.forEach((k, v) -> {
                                if (!"SHA-256-Digest".equalsIgnoreCase(k.toString())) {
                                    aout.put(k, v);
                                }
                            });
                            if (!aout.values().isEmpty()) {
                                mout.getEntries().put((String)name, aout);
                            }
                        });
                        ZipEntry eout = new ZipEntry(ein.getName());
                        eout.setTime(946684800L);
                        zout.putNextEntry(eout);
                        mout.write(zout);
                        this.log("Stripped Manifest of sha digests");
                        continue;
                    }
                    zout.putNextEntry(ein);
                    Utils.copy(zin, zout);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (zout != null) {
                    if (object != null) {
                        try {
                            zout.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        zout.close();
                    }
                }
            }
            if (memory != null) {
                Files.write(output.toPath(), memory.toByteArray(), new OpenOption[0]);
            }
            this.log("Process complete");
        }
        catch (OptionException e2) {
            parser.printHelpOn((OutputStream)System.out);
            e2.printStackTrace();
        }
    }
}

