/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.util.i18n.i18n;

public enum DownloadSource {
    MOHIST("https://maven.mohistmc.com/"),
    CHINA("http://s1.devicloud.cn:25119/"),
    GITHUB("https://mavenmirror.mohistmc.com/");

    String url;
    public static DownloadSource defaultSource;

    private DownloadSource(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public static DownloadSource get() {
        String ds = MohistConfigUtil.sMohist("libraries_downloadsource", defaultSource.name());
        for (DownloadSource me : DownloadSource.values()) {
            if (!me.name().equalsIgnoreCase(ds)) continue;
            return me;
        }
        return defaultSource;
    }

    static {
        defaultSource = i18n.isCN() ? CHINA : MOHIST;
    }
}

