/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.nio.file.Path;
import java.nio.file.Paths;

public class MavenCoordinateResolver {
    public static Path get(String coordinate) {
        String[] parts = coordinate.split(":");
        String groupId = parts[0];
        String artifactId = parts[1];
        String classifier = parts.length > 3 ? parts[2] : "";
        String[] versext = parts[parts.length - 1].split("@");
        String version = versext[0];
        String extension = versext.length > 1 ? versext[1] : "";
        return MavenCoordinateResolver.get(groupId, artifactId, extension, classifier, version);
    }

    public static Path get(String groupId, String artifactId, String extension, String classifier, String version) {
        String fileName = artifactId + "-" + version + (!classifier.isEmpty() ? "-" + classifier : "") + (!extension.isEmpty() ? "." + extension : ".jar");
        String[] groups = groupId.split("\\.");
        Path result = Paths.get(groups[0], new String[0]);
        for (int i = 1; i < groups.length; ++i) {
            result = result.resolve(groups[i]);
        }
        return result.resolve(artifactId).resolve(version).resolve(fileName);
    }
}

