/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractJarFileLocator
implements IModLocator {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Map<IModFile, FileSystem> modJars = new HashMap<IModFile, FileSystem>();
    static final Method ENSURE_INIT = (Method)LamdbaExceptionUtils.uncheck(() -> JarFile.class.getDeclaredMethod("ensureInitialization", new Class[0]));

    protected FileSystem createFileSystem(IModFile modFile) {
        try {
            return FileSystems.newFileSystem(modFile.getFilePath(), modFile.getClass().getClassLoader());
        }
        catch (IOException | ZipError e) {
            LOGGER.debug(LogMarkers.SCAN, "Invalid JAR file {} - no filesystem created", (Object)modFile.getFilePath());
            return null;
        }
    }

    public Path findPath(IModFile modFile, String ... path) {
        if (path.length < 1) {
            throw new IllegalArgumentException("Missing path");
        }
        return this.modJars.get(modFile).getPath("", path);
    }

    public void scanFile(IModFile file, Consumer<Path> pathConsumer) {
        LOGGER.debug(LogMarkers.SCAN, "Scan started: {}", (Object)file);
        FileSystem fs = this.modJars.get(file);
        fs.getRootDirectories().forEach(path -> {
            try (Stream<Path> files = Files.find(path, Integer.MAX_VALUE, (p, a) -> p.getNameCount() > 0 && p.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);){
                files.forEach(pathConsumer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        LOGGER.debug(LogMarkers.SCAN, "Scan finished: {}", (Object)file);
    }

    public Optional<Manifest> findManifest(Path file) {
        return (Optional)this.findManifestAndSigners(file).getKey();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pair<Optional<Manifest>, Optional<CodeSigner[]>> findManifestAndSigners(Path file) {
        try (JarFile jf = new JarFile(file.toFile());){
            Manifest manifest = jf.getManifest();
            if (manifest != null) {
                JarEntry jarEntry = jf.getJarEntry("META-INF/MANIFEST.MF");
                LamdbaExceptionUtils.uncheck(() -> ENSURE_INIT.invoke((Object)jf, new Object[0]));
                Pair pair = Pair.of(Optional.of(manifest), Optional.ofNullable(jarEntry.getCodeSigners()));
                return pair;
            }
            Pair pair = Pair.of(Optional.empty(), Optional.empty());
            return pair;
        }
        catch (IOException e) {
            return Pair.of(Optional.empty(), Optional.empty());
        }
    }

    public boolean isValid(IModFile modFile) {
        return this.modJars.get(modFile) != null;
    }

    static {
        ENSURE_INIT.setAccessible(true);
    }
}

