/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.google.common.base.Strings;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.net.URL;
import java.security.CodeSigner;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.Java9BackportUtils;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.maven.artifact.versioning.VersionRange;

public class ModFileInfo
implements IModFileInfo,
IConfigurable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IConfigurable config;
    private final ModFile modFile;
    private final URL issueURL;
    private final String modLoader;
    private final VersionRange modLoaderVersion;
    private final boolean showAsResourcePack;
    private final List<IModInfo> mods;
    private final Map<String, Object> properties;
    private final String license;
    private final Optional<Manifest> manifest;
    private final Optional<CodeSigner[]> signers;

    ModFileInfo(ModFile modFile, IConfigurable config) {
        this.modFile = modFile;
        this.config = config;
        this.modLoader = (String)config.getConfigElement(new String[]{"modLoader"}).orElseThrow(() -> new InvalidModFileException("Missing ModLoader in file", this));
        this.modLoaderVersion = config.getConfigElement(new String[]{"loaderVersion"}).map(MavenVersionAdapter::createFromVersionSpec).orElseThrow(() -> new InvalidModFileException("Missing ModLoader version in file", this));
        this.license = config.getConfigElement(new String[]{"license"}).orElse("");
        this.showAsResourcePack = config.getConfigElement(new String[]{"showAsResourcePack"}).orElse(false);
        this.properties = config.getConfigElement(new String[]{"properties"}).orElse(Collections.emptyMap());
        this.modFile.setFileProperties(this.properties);
        this.issueURL = config.getConfigElement(new String[]{"issueTrackerURL"}).map(StringUtils::toURL).orElse(null);
        List modConfigs = config.getConfigList(new String[]{"mods"});
        if (modConfigs.isEmpty()) {
            throw new InvalidModFileException("Missing mods list", this);
        }
        this.mods = modConfigs.stream().map(mi -> new ModInfo(this, (IConfigurable)mi)).collect(Collectors.toList());
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = this.modFile::getFileName;
        supplierArray[1] = () -> this.mods.stream().map(IModInfo::getModId).collect(Collectors.joining(",", "{", "}"));
        supplierArray[2] = () -> this.mods.stream().map(IModInfo::getVersion).map(Objects::toString).collect(Collectors.joining(",", "{", "}"));
        LOGGER.debug(LogMarkers.LOADING, "Found valid mod file {} with {} mods - versions {}", supplierArray);
        Pair manifestAndSigners = modFile.getLocator().findManifestAndSigners(modFile.getFilePath());
        this.manifest = (Optional)manifestAndSigners.getKey();
        this.signers = (Optional)manifestAndSigners.getValue();
    }

    public List<IModInfo> getMods() {
        return this.mods;
    }

    public ModFile getFile() {
        return this.modFile;
    }

    public String getModLoader() {
        return this.modLoader;
    }

    public VersionRange getModLoaderVersion() {
        return this.modLoaderVersion;
    }

    public Map<String, Object> getFileProperties() {
        return this.properties;
    }

    public Optional<Manifest> getManifest() {
        return this.manifest;
    }

    public boolean showAsResourcePack() {
        return this.showAsResourcePack;
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        return this.config.getConfigElement(key);
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        return this.config.getConfigList(key);
    }

    public String getLicense() {
        return this.license;
    }

    public URL getIssueURL() {
        return this.issueURL;
    }

    public boolean missingLicense() {
        return Strings.isNullOrEmpty((String)this.license);
    }

    public Optional<CodeSigner[]> getCodeSigners() {
        return this.signers;
    }

    public Optional<String> getCodeSigningFingerprint() {
        return Java9BackportUtils.toStream(this.signers).flatMap(csa -> csa[0].getSignerCertPath().getCertificates().stream()).findFirst().map(LamdbaExceptionUtils.rethrowFunction(Certificate::getEncoded)).map(bytes -> ((MessageDigest)LamdbaExceptionUtils.uncheck(() -> MessageDigest.getInstance("SHA-256"))).digest((byte[])bytes)).map(StringUtils::binToHex).map(str -> String.join((CharSequence)":", str.split("(?<=\\G.{2})")));
    }

    public Optional<String> getTrustData() {
        return Java9BackportUtils.toStream(this.signers).flatMap(csa -> csa[0].getSignerCertPath().getCertificates().stream()).findFirst().map(X509Certificate.class::cast).map(c -> {
            StringBuffer sb = new StringBuffer();
            sb.append(c.getSubjectX500Principal().getName("RFC2253").split(",")[0]);
            boolean selfSigned = false;
            try {
                c.verify(c.getPublicKey());
                selfSigned = true;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException generalSecurityException) {
                // empty catch block
            }
            if (selfSigned) {
                sb.append(" self-signed");
            } else {
                sb.append(" signed by ").append(c.getIssuerX500Principal().getName("RFC2253").split(",")[0]);
            }
            return sb.toString();
        });
    }
}

