/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.PortalSize;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByBlockEvent;

public abstract class AbstractFireBlock
extends Block {
    private final float field_235325_g_;
    protected static final VoxelShape field_235320_b_ = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public AbstractFireBlock(AbstractBlock.Properties p_i241173_1_, float p_i241173_2_) {
        super(p_i241173_1_);
        this.field_235325_g_ = p_i241173_2_;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        return AbstractFireBlock.func_235326_a_((IBlockReader)((Object)p_196258_1_.func_195991_k()), p_196258_1_.func_195995_a());
    }

    public static BlockState func_235326_a_(IBlockReader p_235326_0_, BlockPos p_235326_1_) {
        BlockPos blockpos = p_235326_1_.func_177977_b();
        BlockState blockstate = p_235326_0_.func_180495_p(blockpos);
        return SoulFireBlock.func_235577_c_((Block)blockstate.func_177230_c()) ? Blocks.field_235335_bO_.func_176223_P() : ((FireBlock)Blocks.field_150480_ab).func_196448_a(p_235326_0_, p_235326_1_);
    }

    @Override
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return field_235320_b_;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        block12: {
            block11: {
                BlockPos blockpos;
                BlockState blockstate;
                if (p_180655_4_.nextInt(24) == 0) {
                    p_180655_2_.func_184134_a((double)p_180655_3_.func_177958_n() + 0.5, (double)p_180655_3_.func_177956_o() + 0.5, (double)p_180655_3_.func_177952_p() + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + p_180655_4_.nextFloat(), p_180655_4_.nextFloat() * 0.7f + 0.3f, false);
                }
                if (this.func_196446_i(blockstate = p_180655_2_.func_180495_p(blockpos = p_180655_3_.func_177977_b())) || blockstate.func_224755_d((IBlockReader)((Object)p_180655_2_), blockpos, Direction.UP)) break block11;
                if (this.func_196446_i(p_180655_2_.func_180495_p(p_180655_3_.func_177976_e()))) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)p_180655_3_.func_177958_n() + p_180655_4_.nextDouble() * (double)0.1f;
                        double d8 = (double)p_180655_3_.func_177956_o() + p_180655_4_.nextDouble();
                        double d13 = (double)p_180655_3_.func_177952_p() + p_180655_4_.nextDouble();
                        p_180655_2_.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d3, d8, d13, 0.0, 0.0, 0.0);
                    }
                }
                if (this.func_196446_i(p_180655_2_.func_180495_p(p_180655_3_.func_177974_f()))) {
                    for (int k = 0; k < 2; ++k) {
                        double d4 = (double)(p_180655_3_.func_177958_n() + 1) - p_180655_4_.nextDouble() * (double)0.1f;
                        double d9 = (double)p_180655_3_.func_177956_o() + p_180655_4_.nextDouble();
                        double d14 = (double)p_180655_3_.func_177952_p() + p_180655_4_.nextDouble();
                        p_180655_2_.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d4, d9, d14, 0.0, 0.0, 0.0);
                    }
                }
                if (this.func_196446_i(p_180655_2_.func_180495_p(p_180655_3_.func_177978_c()))) {
                    for (int l = 0; l < 2; ++l) {
                        double d5 = (double)p_180655_3_.func_177958_n() + p_180655_4_.nextDouble();
                        double d10 = (double)p_180655_3_.func_177956_o() + p_180655_4_.nextDouble();
                        double d15 = (double)p_180655_3_.func_177952_p() + p_180655_4_.nextDouble() * (double)0.1f;
                        p_180655_2_.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d5, d10, d15, 0.0, 0.0, 0.0);
                    }
                }
                if (this.func_196446_i(p_180655_2_.func_180495_p(p_180655_3_.func_177968_d()))) {
                    for (int i1 = 0; i1 < 2; ++i1) {
                        double d6 = (double)p_180655_3_.func_177958_n() + p_180655_4_.nextDouble();
                        double d11 = (double)p_180655_3_.func_177956_o() + p_180655_4_.nextDouble();
                        double d16 = (double)(p_180655_3_.func_177952_p() + 1) - p_180655_4_.nextDouble() * (double)0.1f;
                        p_180655_2_.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d6, d11, d16, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.func_196446_i(p_180655_2_.func_180495_p(p_180655_3_.func_177984_a()))) break block12;
                for (int j1 = 0; j1 < 2; ++j1) {
                    double d7 = (double)p_180655_3_.func_177958_n() + p_180655_4_.nextDouble();
                    double d12 = (double)(p_180655_3_.func_177956_o() + 1) - p_180655_4_.nextDouble() * (double)0.1f;
                    double d17 = (double)p_180655_3_.func_177952_p() + p_180655_4_.nextDouble();
                    p_180655_2_.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d7, d12, d17, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)p_180655_3_.func_177958_n() + p_180655_4_.nextDouble();
                double d1 = (double)p_180655_3_.func_177956_o() + p_180655_4_.nextDouble() * 0.5 + 0.5;
                double d2 = (double)p_180655_3_.func_177952_p() + p_180655_4_.nextDouble();
                p_180655_2_.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean func_196446_i(BlockState var1);

    @Override
    public void func_196262_a(BlockState p_196262_1_, World p_196262_2_, BlockPos p_196262_3_, Entity p_196262_4_) {
        if (!p_196262_4_.func_230279_az_()) {
            p_196262_4_.func_241209_g_(p_196262_4_.func_223314_ad() + 1);
            if (p_196262_4_.func_223314_ad() == 0) {
                EntityCombustByBlockEvent event = new EntityCombustByBlockEvent((org.bukkit.block.Block)CraftBlock.at((IWorld)p_196262_2_, (BlockPos)p_196262_3_), (org.bukkit.entity.Entity)p_196262_4_.getBukkitEntity(), 8);
                p_196262_2_.getCBServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    p_196262_4_.putCallCombustEvent(false);
                    p_196262_4_.func_70015_d(event.getDuration());
                }
            }
            p_196262_4_.func_70097_a(DamageSource.field_76372_a, this.field_235325_g_);
        }
        super.func_196262_a(p_196262_1_, p_196262_2_, p_196262_3_, p_196262_4_);
    }

    @Override
    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
        if (!p_220082_4_.func_203425_a(p_220082_1_.func_177230_c())) {
            if (AbstractFireBlock.func_242649_a(p_220082_2_)) {
                Optional optional = PortalSize.func_242964_a(p_220082_2_, p_220082_3_, Direction.Axis.X);
                if ((optional = ForgeEventFactory.onTrySpawnPortal((IWorld)p_220082_2_, (BlockPos)p_220082_3_, optional)).isPresent()) {
                    ((PortalSize)optional.get()).placePortalBlocks();
                    return;
                }
            }
            if (!p_220082_1_.func_196955_c((IWorldReader)((Object)p_220082_2_), p_220082_3_)) {
                this.fireExtinguished(p_220082_2_, p_220082_3_);
            }
        }
    }

    private static boolean func_242649_a(World p_242649_0_) {
        return p_242649_0_.func_234923_W_() == World.field_234918_g_ || p_242649_0_.func_234923_W_() == World.field_234919_h_;
    }

    @Override
    public void func_176208_a(World p_176208_1_, BlockPos p_176208_2_, BlockState p_176208_3_, PlayerEntity p_176208_4_) {
        if (!p_176208_1_.func_201670_d()) {
            p_176208_1_.func_217378_a(null, 1009, p_176208_2_, 0);
        }
    }

    public static boolean func_241465_a_(World p_241465_0_, BlockPos p_241465_1_, Direction p_241465_2_) {
        BlockState blockstate = p_241465_0_.func_180495_p(p_241465_1_);
        if (!blockstate.func_196958_f()) {
            return false;
        }
        return AbstractFireBlock.func_235326_a_((IBlockReader)((Object)p_241465_0_), p_241465_1_).func_196955_c((IWorldReader)((Object)p_241465_0_), p_241465_1_) || AbstractFireBlock.func_241466_b_(p_241465_0_, p_241465_1_, p_241465_2_);
    }

    private static boolean func_241466_b_(World p_241466_0_, BlockPos p_241466_1_, Direction p_241466_2_) {
        if (!AbstractFireBlock.func_242649_a(p_241466_0_)) {
            return false;
        }
        BlockPos.Mutable blockpos$mutable = p_241466_1_.func_239590_i_();
        boolean flag = false;
        for (Direction direction : Direction.values()) {
            if (!p_241466_0_.func_180495_p(blockpos$mutable.func_189533_g(p_241466_1_).func_189536_c(direction)).func_203425_a(Blocks.field_150343_Z)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        Direction.Axis direction$axis = p_241466_2_.func_176740_k().func_176722_c() ? p_241466_2_.func_176735_f().func_176740_k() : Direction.Plane.HORIZONTAL.func_244803_b(p_241466_0_.field_73012_v);
        return PortalSize.func_242964_a(p_241466_0_, p_241466_1_, direction$axis).isPresent();
    }

    protected void fireExtinguished(IWorld world, BlockPos position) {
        if (!CraftEventFactory.callBlockFadeEvent((IWorld)world, (BlockPos)position, (BlockState)Blocks.field_150350_a.func_176223_P()).isCancelled()) {
            world.func_217377_a(position, false);
        }
    }
}

