/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class FlowingFluidBlock
extends Block
implements IBucketPickupHandler {
    public static final IntegerProperty field_176367_b = BlockStateProperties.field_208132_ag;
    private final FlowingFluid field_204517_c;
    private final List<FluidState> field_212565_c;
    public static final VoxelShape field_235510_c_ = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    private final Supplier<? extends Fluid> supplier;
    private boolean fluidStateCacheInitialized = false;

    @Deprecated
    public FlowingFluidBlock(FlowingFluid p_i49014_1_, AbstractBlock.Properties p_i49014_2_) {
        super(p_i49014_2_);
        this.field_204517_c = p_i49014_1_;
        this.field_212565_c = Lists.newArrayList();
        this.field_212565_c.add(p_i49014_1_.func_207204_a(false));
        for (int i = 1; i < 8; ++i) {
            this.field_212565_c.add(p_i49014_1_.func_207207_a(8 - i, false));
        }
        this.field_212565_c.add(p_i49014_1_.func_207207_a(8, true));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176367_b, 0));
        this.fluidStateCacheInitialized = true;
        this.supplier = p_i49014_1_.delegate;
    }

    public FlowingFluidBlock(Supplier<? extends FlowingFluid> supplier, AbstractBlock.Properties p_i48368_1_) {
        super(p_i48368_1_);
        this.field_204517_c = null;
        this.field_212565_c = Lists.newArrayList();
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176367_b, 0));
        this.supplier = supplier;
    }

    @Override
    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return p_220071_4_.func_216378_a(field_235510_c_, p_220071_3_, true) && p_220071_1_.func_177229_b(field_176367_b) == 0 && p_220071_4_.func_230426_a_(p_220071_2_.func_204610_c(p_220071_3_.func_177984_a()), this.field_204517_c) ? field_235510_c_ : VoxelShapes.func_197880_a();
    }

    @Override
    public boolean func_149653_t(BlockState p_149653_1_) {
        return p_149653_1_.func_204520_s().func_206890_h();
    }

    @Override
    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        p_225542_1_.func_204520_s().func_206891_b(p_225542_2_, p_225542_3_, p_225542_4_);
    }

    @Override
    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return false;
    }

    @Override
    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return !this.field_204517_c.func_207185_a(FluidTags.field_206960_b);
    }

    @Override
    public FluidState func_204507_t(BlockState p_204507_1_) {
        int i = p_204507_1_.func_177229_b(field_176367_b);
        if (!this.fluidStateCacheInitialized) {
            this.initFluidStateCache();
        }
        return this.field_212565_c.get(Math.min(i, 8));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState p_200122_1_, BlockState p_200122_2_, Direction p_200122_3_) {
        return p_200122_2_.func_204520_s().func_206886_c().func_207187_a(this.field_204517_c);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.INVISIBLE;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return Collections.emptyList();
    }

    @Override
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
        if (this.func_204515_c(p_220082_2_, p_220082_3_, p_220082_1_)) {
            p_220082_2_.func_205219_F_().func_205360_a(p_220082_3_, (Object)p_220082_1_.func_204520_s().func_206886_c(), this.field_204517_c.func_205569_a((IWorldReader)((Object)p_220082_2_)));
        }
    }

    @Override
    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (p_196271_1_.func_204520_s().func_206889_d() || p_196271_3_.func_204520_s().func_206889_d()) {
            p_196271_4_.func_205219_F_().func_205360_a(p_196271_5_, (Object)p_196271_1_.func_204520_s().func_206886_c(), this.field_204517_c.func_205569_a((IWorldReader)((Object)p_196271_4_)));
        }
        return super.func_196271_a(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    @Override
    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (this.func_204515_c(p_220069_2_, p_220069_3_, p_220069_1_)) {
            p_220069_2_.func_205219_F_().func_205360_a(p_220069_3_, (Object)p_220069_1_.func_204520_s().func_206886_c(), this.field_204517_c.func_205569_a((IWorldReader)((Object)p_220069_2_)));
        }
    }

    private boolean func_204515_c(World p_204515_1_, BlockPos p_204515_2_, BlockState p_204515_3_) {
        if (this.field_204517_c.func_207185_a(FluidTags.field_206960_b)) {
            boolean flag = p_204515_1_.func_180495_p(p_204515_2_.func_177977_b()).func_203425_a(Blocks.field_235336_cN_);
            for (Direction direction : Direction.values()) {
                if (direction == Direction.DOWN) continue;
                BlockPos blockpos = p_204515_2_.func_177972_a(direction);
                if (p_204515_1_.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a)) {
                    Block block;
                    Block block2 = block = p_204515_1_.func_204610_c(p_204515_2_).func_206889_d() ? Blocks.field_150343_Z : Blocks.field_150347_e;
                    if (CraftEventFactory.handleBlockFormEvent((World)p_204515_1_, (BlockPos)p_204515_2_, (BlockState)ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)p_204515_1_, (BlockPos)p_204515_2_, (BlockPos)p_204515_2_, (BlockState)block.func_176223_P()))) {
                        this.func_180688_d(p_204515_1_, p_204515_2_);
                    }
                    return false;
                }
                if (!flag || !p_204515_1_.func_180495_p(blockpos).func_203425_a(Blocks.field_205164_gk)) continue;
                if (CraftEventFactory.handleBlockFormEvent((World)p_204515_1_, (BlockPos)p_204515_2_, (BlockState)ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)p_204515_1_, (BlockPos)p_204515_2_, (BlockPos)p_204515_2_, (BlockState)Blocks.field_235337_cO_.func_176223_P()))) {
                    this.func_180688_d(p_204515_1_, p_204515_2_);
                }
                return false;
            }
        }
        return true;
    }

    private void func_180688_d(IWorld p_180688_1_, BlockPos p_180688_2_) {
        p_180688_1_.func_217379_c(1501, p_180688_2_, 0);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_176367_b});
    }

    public Fluid func_204508_a(IWorld p_204508_1_, BlockPos p_204508_2_, BlockState p_204508_3_) {
        if (p_204508_3_.func_177229_b(field_176367_b) == 0) {
            p_204508_1_.func_180501_a(p_204508_2_, Blocks.field_150350_a.func_176223_P(), 11);
            return this.field_204517_c;
        }
        return Fluids.field_204541_a;
    }

    public FlowingFluid getFluid() {
        return (FlowingFluid)this.supplier.get();
    }

    protected synchronized void initFluidStateCache() {
        if (!this.fluidStateCacheInitialized) {
            this.field_212565_c.add(this.getFluid().func_207204_a(false));
            for (int i = 1; i < 8; ++i) {
                this.field_212565_c.add(this.getFluid().func_207207_a(8 - i, false));
            }
            this.field_212565_c.add(this.getFluid().func_207207_a(8, true));
            this.fluidStateCacheInitialized = true;
        }
    }
}

