/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class RedstoneOreBlock
extends Block {
    public static final BooleanProperty field_196501_a = RedstoneTorchBlock.field_196528_a;

    public RedstoneOreBlock(AbstractBlock.Properties p_i48345_1_) {
        super(p_i48345_1_);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(field_196501_a, false));
    }

    @Override
    public void func_196270_a(BlockState p_196270_1_, World p_196270_2_, BlockPos p_196270_3_, PlayerEntity p_196270_4_) {
        RedstoneOreBlock.interact(p_196270_1_, p_196270_2_, p_196270_3_, p_196270_4_);
        super.func_196270_a(p_196270_1_, p_196270_2_, p_196270_3_, p_196270_4_);
    }

    @Override
    public void func_176199_a(World p_176199_1_, BlockPos p_176199_2_, Entity p_176199_3_) {
        if (p_176199_3_ instanceof PlayerEntity) {
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((PlayerEntity)((PlayerEntity)p_176199_3_), (Action)Action.PHYSICAL, (BlockPos)p_176199_2_, null, null, null);
            if (!event.isCancelled()) {
                RedstoneOreBlock.interact(p_176199_1_.func_180495_p(p_176199_2_), p_176199_1_, p_176199_2_, p_176199_3_);
                super.func_176199_a(p_176199_1_, p_176199_2_, p_176199_3_);
            }
        } else {
            EntityInteractEvent event = new EntityInteractEvent((org.bukkit.entity.Entity)p_176199_3_.getBukkitEntity(), p_176199_1_.getWorld().getBlockAt(p_176199_2_.func_177958_n(), p_176199_2_.func_177956_o(), p_176199_2_.func_177952_p()));
            p_176199_1_.getCBServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                RedstoneOreBlock.interact(p_176199_1_.func_180495_p(p_176199_2_), p_176199_1_, p_176199_2_, p_176199_3_);
                super.func_176199_a(p_176199_1_, p_176199_2_, p_176199_3_);
            }
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_2_.field_72995_K) {
            RedstoneOreBlock.func_180691_e(p_225533_2_, p_225533_3_);
        } else {
            RedstoneOreBlock.interact(p_225533_1_, p_225533_2_, p_225533_3_, p_225533_4_);
        }
        ItemStack itemstack = p_225533_4_.func_184586_b(p_225533_5_);
        return itemstack.func_77973_b() instanceof BlockItem && new BlockItemUseContext(p_225533_4_, p_225533_5_, itemstack, p_225533_6_).func_196011_b() ? ActionResultType.PASS : ActionResultType.SUCCESS;
    }

    private static void interact(BlockState state, World world, BlockPos pos, Entity entity) {
        RedstoneOreBlock.func_180691_e(world, pos);
        if (!((Boolean)state.func_177229_b(field_196501_a)).booleanValue()) {
            if (CraftEventFactory.callEntityChangeBlockEvent((Entity)entity, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(field_196501_a, true))).isCancelled()) {
                return;
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a(field_196501_a, true), 3);
        }
    }

    @Override
    public boolean func_149653_t(BlockState p_149653_1_) {
        return (Boolean)p_149653_1_.func_177229_b(field_196501_a);
    }

    @Override
    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        if (((Boolean)p_225542_1_.func_177229_b(field_196501_a)).booleanValue()) {
            if (CraftEventFactory.callBlockFadeEvent((IWorld)p_225542_2_, (BlockPos)p_225542_3_, (BlockState)((BlockState)p_225542_1_.func_206870_a(field_196501_a, true))).isCancelled()) {
                return;
            }
            p_225542_2_.func_180501_a(p_225542_3_, (BlockState)p_225542_1_.func_206870_a(field_196501_a, false), 3);
        }
    }

    @Override
    public void func_220062_a(BlockState p_220062_1_, ServerWorld p_220062_2_, BlockPos p_220062_3_, ItemStack p_220062_4_) {
        super.func_220062_a(p_220062_1_, p_220062_2_, p_220062_3_, p_220062_4_);
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos pos, int fortune, int silktouch) {
        return silktouch == 0 ? 1 + this.RANDOM.nextInt(5) : 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        if (((Boolean)p_180655_1_.func_177229_b(field_196501_a)).booleanValue()) {
            RedstoneOreBlock.func_180691_e(p_180655_2_, p_180655_3_);
        }
    }

    private static void func_180691_e(World p_180691_0_, BlockPos p_180691_1_) {
        double d0 = 0.5625;
        Random random = p_180691_0_.field_73012_v;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = p_180691_1_.func_177972_a(direction);
            if (p_180691_0_.func_180495_p(blockpos).func_200015_d((IBlockReader)((Object)p_180691_0_), blockpos)) continue;
            Direction.Axis direction$axis = direction.func_176740_k();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.func_82601_c() : (double)random.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.func_96559_d() : (double)random.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.func_82599_e() : (double)random.nextFloat();
            p_180691_0_.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)p_180691_1_.func_177958_n() + d1, (double)p_180691_1_.func_177956_o() + d2, (double)p_180691_1_.func_177952_p() + d3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_196501_a});
    }
}

